/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimerTask;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.SensorDataPacket;

public class InstrumentSampler
extends TimerTask {
    Node _node;

    public InstrumentSampler(Node node) {
        this._node = node;
    }

    public void run() {
        System.out.println("Sample instruments: ");
        try {
            Device[] devices = this._node.getDevices();
            int i = 0;
            while (i < devices.length) {
                if (devices[i] instanceof Instrument) {
                    Device device = devices[i];
                    synchronized (device) {
                        if (devices[i].getStatus() != 3) {
                            String name = new String(devices[i].getName());
                            System.out.println("\n** Sampling instrument " + i + " " + name + " (id=" + devices[i].getId() + ")");
                            Instrument instrument = (Instrument)devices[i];
                            try {
                                SensorDataPacket packet = instrument.getData();
                                String timestamp = DateFormat.getDateTimeInstance().format(new Date(packet.systemTime()));
                                System.out.println(timestamp + ": " + new String(packet.dataBuffer()));
                            }
                            catch (NoDataException e) {
                                System.err.println("No data from instrument: " + e.getMessage());
                            }
                        } else {
                            System.err.println("Service " + new String(devices[i].getName()) + " is shutting down.");
                        }
                    }
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.err.println("InstrumentSampler.run() - Caught RemoteException: ");
            e.getMessage();
        }
    }
}

