/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.deployed.InstrumentPort;

public class InstrumentConsole {
    private InputStream _fromInstrument;
    private OutputStream _toInstrument;
    private InstrumentPort _instrumentPort;

    public InstrumentConsole(InstrumentPort instPort, InputStream is, OutputStream os) throws IOException {
        if (instPort == null) {
            throw new IOException("InstrumentPort is null");
        }
        this._instrumentPort = instPort;
        this._fromInstrument = is;
        this._toInstrument = os;
    }

    public void write(int b) throws IOException {
        if (!this._instrumentPort.isSuspended()) {
            throw new IOException("InstrumentPort not suspended");
        }
        this._toInstrument.write(b);
    }

    public int read() throws IOException {
        if (!this._instrumentPort.isSuspended()) {
            throw new IOException("InstrumentPort not suspended");
        }
        return this._fromInstrument.read();
    }

    public int available() throws IOException {
        if (!this._instrumentPort.isSuspended()) {
            throw new IOException("InstrumentPort not suspended");
        }
        return this._fromInstrument.available();
    }
}

