/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import gnu.io.SerialPort;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import moos.deployed.IoResource;
import moos.deployed.IoResourceType;
import moos.deployed.SpiMaster;

public class DpaBoard {
    private DpaChannel _dpaLeftChannel;
    private boolean _dpaAvailChecked;
    private boolean _dpaHardwareIsPresent;
    private DpaChannel dpaRightChannel;
    private int[] _adcReg = new int[1];
    private int[] _leftRelayReg = new int[1];
    private int[] _rightRelayReg = new int[1];
    private int[] _leftChannelCtrlReg = new int[1];
    private int[] _rightChannelCtrlReg = new int[1];
    private int[] _interruptReg = new int[1];
    private Adc _adc;
    public BoardAdc _boardAdc;
    protected boolean doDebug;
    protected int _spiSlaveSelectValue;
    protected static SpiMaster _spi = SpiMaster.getInstance();
    protected boolean _boardInitialized;

    public DpaBoard(int spiSlaveSelectValue) {
        this._adcReg[0] = 0;
        this._leftRelayReg[0] = 0;
        this._rightRelayReg[0] = 0;
        this._leftChannelCtrlReg[0] = 0;
        this._rightChannelCtrlReg[0] = 0;
        this._interruptReg[0] = 0;
        this._adc = new Adc(this._adcReg);
        this._boardAdc = new BoardAdc();
        this.doDebug = false;
        this._boardInitialized = false;
        DebugMessage.println("DpaBoard ctor invoked");
        this._spiSlaveSelectValue = spiSlaveSelectValue;
    }

    public DpaChannel getLeftChannel() {
        if (this._dpaLeftChannel == null) {
            this._dpaLeftChannel = new DpaLeftChannel();
        }
        return this._dpaLeftChannel;
    }

    public DpaChannel getRightChannel() {
        if (this.dpaRightChannel == null) {
            this.dpaRightChannel = new DpaRightChannel();
        }
        return this.dpaRightChannel;
    }

    static int writeReadSpi(int slaveSelect, int dataOut) {
        int dataIn;
        SpiMaster spiMaster = _spi;
        synchronized (spiMaster) {
            _spi.setSlaveSelect(slaveSelect);
            dataIn = _spi.writeReadData(dataOut);
            _spi.setSlaveSelect(7);
        }
        return dataIn;
    }

    public static boolean checkForDpaHardware(int slaveSelectVal) {
        DpaBoard.writeReadSpi(slaveSelectVal, 20496);
        int dataIn = DpaBoard.writeReadSpi(slaveSelectVal, 49152);
        if ((dataIn & 0x30) != 16) {
            return false;
        }
        DpaBoard.writeReadSpi(slaveSelectVal, 20512);
        dataIn = DpaBoard.writeReadSpi(slaveSelectVal, 49152);
        return (dataIn & 0x30) == 32;
    }

    protected int writeReadSpi(int dataOut) {
        return DpaBoard.writeReadSpi(this._spiSlaveSelectValue, dataOut);
    }

    public synchronized void stallOnBusyBit() {
        if (this._dpaHardwareIsPresent) {
            int regVal;
            while (((regVal = this.writeReadSpi(61440)) & Short.MAX_VALUE) == Short.MAX_VALUE) {
            }
        }
    }

    public class DpaRightChannel
    extends DpaChannel {
        DpaRightChannel() {
            DebugMessage.println("DpaRightChannel ctor invoked");
            this._channelAdc = new RightChannelAdc();
            this._relayReg = new RightRelayReg(DpaBoard.this._rightRelayReg);
            this._channelCtrlReg = new RightChannelCtrlReg(DpaBoard.this._rightChannelCtrlReg);
            this._interruptCtrlReg = new RightInterruptReg(DpaBoard.this._interruptReg);
        }

        protected void movePot(int direction, int nStepsUp) {
            DebugMessage.println("DpaRightChannel movePot(dir=" + direction + "; steps=" + nStepsUp);
            int regValue = 0x1000 | direction << 8 | 0 | nStepsUp & 0x7F;
            DpaBoard.this.writeReadSpi(regValue);
        }
    }

    public class DpaLeftChannel
    extends DpaChannel {
        DpaLeftChannel() {
            DebugMessage.println("DpaLeftChannel ctor invoked");
            this._channelAdc = new LeftChannelAdc();
            this._relayReg = new LeftRelayReg(DpaBoard.this._leftRelayReg);
            this._channelCtrlReg = new LeftChannelCtrlReg(DpaBoard.this._leftChannelCtrlReg);
            this._interruptCtrlReg = new LeftInterruptReg(DpaBoard.this._interruptReg);
        }

        protected void movePot(int direction, int nStepsUp) {
            DebugMessage.println("DpaLeftChannel movePot(dir=" + direction + "; steps=" + nStepsUp);
            int regValue = 0 | direction << 8 | 0 | nStepsUp & 0x7F;
            DpaBoard.this.writeReadSpi(regValue);
        }
    }

    public abstract class DpaChannel
    implements IoResource {
        protected boolean _channelInitialized = false;
        protected boolean _currentCtrlInitialized = false;
        protected InstrumentService _instrument;
        protected SerialPort _instrumentPort;
        protected int _presentPosition;
        protected static final int MOVE_UP = 1;
        protected static final int MOVE_DOWN = 0;
        public ChannelAdc _channelAdc;
        public RelayReg _relayReg;
        public ChannelCtrlReg _channelCtrlReg;
        protected InterruptReg _interruptCtrlReg;
        protected int _defaultCurrentLimit = 1000;

        public DpaChannel() {
            DebugMessage.println("DpaChannel ctor invoked");
        }

        public void initialize() {
            DebugMessage.println("DpaChannel.initialize() - not implemented");
        }

        public void setCurrentLimit(long currentLimit) {
            DebugMessage.println("DpaChannel.setCurrentLimit() - not implemented");
        }

        public void enableCommunications() {
            DebugMessage.println("DpaChannel.enableCommunications() - not implemented");
        }

        public void disableCommunications() {
            DebugMessage.println("DpaChannel.disableCommunications() - not implemented");
        }

        public void connectPower() {
            DebugMessage.println("DpaChannel.connectPower() - not implemented");
        }

        public void disconnectPower() {
            DebugMessage.println("DpaChannel.disconnectPower() - not implemented");
        }

        public void initializeChannel() {
            DebugMessage.println("Initializing DpaChannel " + this);
            if (!this._channelInitialized) {
                this.initializeBoard();
                DebugMessage.println("Disconnecting RS485 terminators");
                DebugMessage.println("Isolating communications ground");
                DebugMessage.println("Isolating Instrument power");
                this._relayReg.disconnect485Terminators();
                this._relayReg.isolateCommunicationsGround();
                this._relayReg.isolateInstrumentPower();
                this._relayReg.write();
                DebugMessage.println("Setting Current Limit to " + this._defaultCurrentLimit);
                this.setCurrentLimit(this._defaultCurrentLimit);
                DebugMessage.println("initializing channelCtrlReg");
                this._channelCtrlReg.setTxLoPower();
                this._channelCtrlReg.setSlewRateNotLimited();
                this._channelCtrlReg.setCommModeRs232();
                this._channelCtrlReg.setCommFullDuplex();
                this._channelCtrlReg.write();
                DebugMessage.println("Setting COMM and INSTR power OFF ");
                this._channelCtrlReg.setCommPowerOff();
                this._channelCtrlReg.setInstrumentPowerOff();
                this._channelCtrlReg.write();
                this._interruptCtrlReg.setOvercurrentIntrEn();
                this._interruptCtrlReg.write();
                this._channelInitialized = true;
            }
        }

        protected void checkOnceForDpaHardware() {
            if (!DpaBoard.this._dpaAvailChecked) {
                int spiVal = DpaBoard.this.writeReadSpi(61440);
                DpaBoard.this._dpaAvailChecked = true;
                DpaBoard.this._dpaHardwareIsPresent = (spiVal & Short.MAX_VALUE) != Short.MAX_VALUE;
                DebugMessage.print("checkOnceForDpaHardware() called...");
                if (DpaBoard.this._dpaHardwareIsPresent) {
                    DebugMessage.println("DPA is available");
                } else {
                    DebugMessage.println("found no DPA hardware.");
                }
            }
        }

        protected void initializeBoard() {
            DebugMessage.println("first line of initializeBoard()");
            if (!DpaBoard.this._boardInitialized) {
                DebugMessage.println("Doing DpaChannel.initializeBoard()");
                _spi.setClkDivider(64);
                _spi.setSlaveSelect(7);
                _spi.writeReadData(0);
                this.checkOnceForDpaHardware();
                DpaBoard.this._adc.initialize();
                this._interruptCtrlReg.setGlobalOvercurrentEn();
                this._interruptCtrlReg.write();
                DpaBoard.this._boardInitialized = true;
            }
        }

        public void setSerialPort(SerialPort aPort) {
            this._instrumentPort = aPort;
        }

        public Object getResourceType(IoResourceType aType) {
            if (aType == IoResourceType.DPA_BOARD) {
                return this;
            }
            if (aType == IoResourceType.INSTRUMENT) {
                return this._instrument;
            }
            return null;
        }

        private void initializeCurrentCtrl() {
            DebugMessage.println("in InitializeCurrentCtrl()");
            this.movePot(0, 99);
            DpaBoard.this.stallOnBusyBit();
            this._presentPosition = 0;
            this._currentCtrlInitialized = true;
        }

        public void setCurrentLimit(int milliamps) {
            DebugMessage.println("In setCurrentLimit(int milliamps) " + milliamps);
            DebugMessage.println("On Entry Present Position = " + this._presentPosition);
            if (!this._currentCtrlInitialized) {
                DebugMessage.println("  about to initializeCurrentCtrl()...");
                this.initializeCurrentCtrl();
                DebugMessage.println("  initializeCurrentCtrl() done.");
            }
            DebugMessage.println("After Init Present Position = " + this._presentPosition);
            int newPosition = milliamps / 120;
            int diff = newPosition - this._presentPosition;
            if (diff > 0) {
                this.movePot(1, diff);
            } else if (diff < 0) {
                this.movePot(0, -diff);
            }
            DpaBoard.this.stallOnBusyBit();
            DebugMessage.println("Present " + this._presentPosition);
            DebugMessage.println("New " + newPosition);
            DebugMessage.println("diff " + diff);
            this._presentPosition = newPosition;
        }

        int getCurrentLimitCtrlValue() {
            return this._presentPosition * 120;
        }

        protected abstract void movePot(int var1, int var2);

        public void setInstrument(InstrumentService anInstrument) {
            this._instrument = anInstrument;
        }
    }

    private class RightInterruptReg
    extends InterruptReg {
        private RightInterruptReg(int[] regVal) {
            super(regVal);
        }

        public void setOvercurrentIntrEn() {
            this.set(16);
        }

        public void clearOvercurrentIntrEn() {
            this.clear(16);
        }

        public boolean isOvercurrentFlagSet() {
            return (this._regVal[0] & 2) != 0;
        }
    }

    private class LeftInterruptReg
    extends InterruptReg {
        private LeftInterruptReg(int[] regVal) {
            super(regVal);
        }

        public void setOvercurrentIntrEn() {
            this.set(32);
        }

        public void clearOvercurrentIntrEn() {
            this.clear(32);
        }

        public boolean isOvercurrentFlagSet() {
            return (this._regVal[0] & 4) != 0;
        }
    }

    private abstract class InterruptReg
    extends HdwrReg {
        public static final int Wr = 20480;
        public static final int EnableMask = 56;
        public static final int LeftOvercurrentEnable = 32;
        public static final int RightOvercurrentEnable = 16;
        public static final int GlobalOvercurrentEnable = 8;
        public static final int FlagMask = 7;
        public static final int LeftOvercurrentIntrFlag = 4;
        public static final int RightOvercurrentIntrFlag = 2;
        public static final int GlobalOvercurrentIntrFlag = 1;

        public InterruptReg(int[] regVal) {
            super(regVal);
        }

        public void setGlobalOvercurrentEn() {
            this.set(8);
        }

        public void clearGlobalOvercurrentEn() {
            this.clear(8);
        }

        public boolean isGlobalOvercurrentIntrFlagSet() {
            return (this._regVal[0] & 1) != 0;
        }

        public abstract void setOvercurrentIntrEn();

        public abstract void clearOvercurrentIntrEn();

        public abstract boolean isOvercurrentFlagSet();

        public void write() {
            int retval = DpaBoard.this.writeReadSpi(0x5000 | this._regVal[0]);
            this._regVal[0] = this._regVal[0] & 0x38 | retval & 7;
            DpaBoard.this.stallOnBusyBit();
        }
    }

    public class RightChannelCtrlReg
    extends ChannelCtrlReg {
        private static final int Wr = 28672;
        private static final int Re = 57344;

        private RightChannelCtrlReg(int[] regVal) {
            super(regVal);
            DebugMessage.println("RightChannelCtrlReg ctor invoked");
        }

        public void write() {
            DpaBoard.this.writeReadSpi(0x7000 | this._regVal[0]);
            DpaBoard.this.stallOnBusyBit();
        }

        public int read() {
            int i = DpaBoard.this.writeReadSpi(57344);
            DpaBoard.this.stallOnBusyBit();
            return i;
        }
    }

    private class LeftChannelCtrlReg
    extends ChannelCtrlReg {
        private static final int Wr = 24576;
        private static final int Re = 53248;

        private LeftChannelCtrlReg(int[] regVal) {
            super(regVal);
            DebugMessage.println("LeftChannelCtrlReg ctor invoked");
        }

        public void write() {
            DpaBoard.this.writeReadSpi(0x6000 | this._regVal[0]);
            DpaBoard.this.stallOnBusyBit();
        }

        public int read() {
            int i = DpaBoard.this.writeReadSpi(53248);
            DpaBoard.this.stallOnBusyBit();
            return i;
        }
    }

    public abstract class ChannelCtrlReg
    extends HdwrReg {
        private static final int TxHiPowerOn = 32;
        private static final int CommHalfDuplex = 16;
        private static final int CommMode485 = 8;
        private static final int SlewRateNotLimited = 4;
        private static final int CommPowerOn = 2;
        private static final int InstrumentPowerOn = 1;

        ChannelCtrlReg(int[] regVal) {
            super(regVal);
        }

        public void setTxHiPower() {
            this.set(32);
        }

        public void setTxLoPower() {
            this.clear(32);
        }

        public void setSlewRateNotLimited() {
            this.set(4);
        }

        public void setSlewRateLimited() {
            this.clear(4);
        }

        public void setCommModeRs485() {
            this.set(8);
        }

        public void setCommModeRs232() {
            this.clear(8);
        }

        public void setCommHalfDuplex() {
            this.set(16);
        }

        public void setCommFullDuplex() {
            this.clear(16);
        }

        public void setCommPowerOn() {
            this.set(2);
        }

        public void setCommPowerOff() {
            this.clear(2);
        }

        public void setInstrumentPowerOn() {
            this.set(1);
        }

        public void setInstrumentPowerOff() {
            this.clear(1);
        }

        public abstract void write();

        public abstract int read();
    }

    private class RightRelayReg
    extends RelayReg {
        private static final int Wr = 12288;
        private static final int Re = 45056;

        RightRelayReg(int[] regVal) {
            super(regVal);
            DebugMessage.println("RightRelayReg ctor invoked");
        }

        public void write() {
            DpaBoard.this.writeReadSpi(0x3000 | this._regVal[0]);
            DpaBoard.this.stallOnBusyBit();
        }

        public int read() {
            int i = DpaBoard.this.writeReadSpi(45056);
            DpaBoard.this.stallOnBusyBit();
            return i;
        }
    }

    private class LeftRelayReg
    extends RelayReg {
        private static final int Wr = 8192;
        private static final int Re = 40960;

        LeftRelayReg(int[] regVal) {
            super(regVal);
            DebugMessage.println("LeftRelayReg ctor invoked");
        }

        public void write() {
            DpaBoard.this.writeReadSpi(0x2000 | this._regVal[0]);
            DpaBoard.this.stallOnBusyBit();
        }

        public int read() {
            int i = DpaBoard.this.writeReadSpi(40960);
            DpaBoard.this.stallOnBusyBit();
            return i;
        }
    }

    public abstract class RelayReg
    extends HdwrReg {
        private static final int Connect485Terminators = 4;
        private static final int IsolateCommunicationsGround = 2;
        private static final int IsolateInstrumentPower = 1;

        RelayReg(int[] regVal) {
            super(regVal);
            DebugMessage.println("RelayReg ctor invoked");
        }

        public void connect485Terminators() {
            this.set(4);
        }

        public void disconnect485Terminators() {
            this.clear(4);
        }

        public void isolateCommunicationsGround() {
            this.set(2);
        }

        public void connectCommunicationsGround() {
            this.clear(2);
        }

        public void isolateInstrumentPower() {
            this.set(1);
        }

        public void connectInstrumentPower() {
            this.clear(1);
        }

        public abstract void write();

        public abstract int read();
    }

    public class RightChannelAdc
    extends ChannelAdc {
        public int getVoltage() {
            return DpaBoard.this._adc.getReading(6);
        }

        public int getTripLevel() {
            return DpaBoard.this._adc.getReading(5);
        }

        public int getCurrent() {
            return DpaBoard.this._adc.getReading(4);
        }
    }

    public class LeftChannelAdc
    extends ChannelAdc {
        public int getVoltage() {
            return DpaBoard.this._adc.getReading(2);
        }

        public int getTripLevel() {
            return DpaBoard.this._adc.getReading(1);
        }

        public int getCurrent() {
            return DpaBoard.this._adc.getReading(0);
        }
    }

    public abstract class ChannelAdc {
        public abstract int getVoltage();

        public abstract int getTripLevel();

        public abstract int getCurrent();
    }

    public class BoardAdc {
        public int getBatterySupplyVoltage() {
            return DpaBoard.this._adc.getReading(7);
        }

        public int getHeatSinkTemp() {
            return DpaBoard.this._adc.getReading(3);
        }
    }

    class Adc
    extends HdwrReg {
        public static final int WR = 16384;
        public static final int RD = 45056;
        private static final int POWER_MASK = 192;
        private static final int POWER_OFF = 0;
        private static final int POWER_STBY = 64;
        private static final int POWER_ON_INT_CLK = 128;
        private static final int ACQ_EXT = 32;
        private static final int SGL_DRIVE = 16;
        private static final int UNIPOLAR = 8;
        private static final int BATTERY_SUPPLY_VOLTAGE = 7;
        protected static final int RIGHT_VOLTAGE = 6;
        protected static final int RIGHT_TRIP_LEVEL = 5;
        protected static final int RIGHT_CURRENT = 4;
        private static final int HEATSINK_TEMP = 3;
        protected static final int LEFT_VOLTAGE = 2;
        protected static final int LEFT_TRIP_LEVEL = 1;
        protected static final int LEFT_CURRENT = 0;

        private Adc(int[] regVal) {
            super(regVal);
            this.setSglDrive();
            this.setUnipolar();
        }

        public void setPowerOff() {
            this.set(192, 0);
        }

        public void setPowerStby() {
            this.set(192, 64);
        }

        public void setPowerOnIntClk() {
            this.set(192, 128);
        }

        public void setAcqExternal() {
            this.set(32, 32);
        }

        public void setAcqInternal() {
            this.set(32, 0);
        }

        public void setSglDrive() {
            this.set(16, 16);
        }

        public void setDifferentialDrive() {
            this.set(16, 0);
        }

        public void setUnipolar() {
            this.set(8, 8);
        }

        public void setBipolar() {
            this.set(8, 0);
        }

        void initialize() {
            this.setAcqInternal();
            this.setPowerStby();
            DpaBoard.this.writeReadSpi(0x4000 | this._regVal[0] | 0);
            DpaBoard.this.stallOnBusyBit();
        }

        protected int getReading(int adcChannel) {
            this.setAcqExternal();
            this.setPowerOnIntClk();
            DpaBoard.this.writeReadSpi(0x4000 | this._regVal[0] | adcChannel);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                DebugMessage.println("ADC sleep got interrupted: " + e);
            }
            DpaBoard.this.stallOnBusyBit();
            this.setAcqInternal();
            this.setPowerStby();
            DpaBoard.this.writeReadSpi(0x4000 | this._regVal[0] | adcChannel);
            DpaBoard.this.stallOnBusyBit();
            int retval = DpaBoard.this.writeReadSpi(45056);
            DpaBoard.this.stallOnBusyBit();
            return retval;
        }
    }

    public abstract class HdwrReg {
        protected int[] _regVal;
        protected boolean _changed = true;

        HdwrReg() {
            DebugMessage.println("HdwrReg(void) ctor invoked");
        }

        HdwrReg(int[] regVal) {
            DebugMessage.println("HdwrReg(int[]) ctor invoked");
            this._regVal = regVal;
        }

        protected void set(int mask, int val) {
            if ((this._regVal[0] & mask) == val) {
                return;
            }
            this._regVal[0] = this._regVal[0] & ~mask;
            this._regVal[0] = this._regVal[0] | val;
            this._changed = true;
        }

        protected void set(int bitmask) {
            this.set(bitmask, bitmask);
        }

        protected void clear(int mask) {
            this.set(mask, 0);
        }
    }
}

