/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceService;
import moos.deployed.InstrumentPort;

public class DeviceServiceClassLoader
extends URLClassLoader {
    private URL url;
    File _file = null;

    public DeviceServiceClassLoader(URL url) {
        super(new URL[]{url});
        this.url = url;
    }

    public DeviceServiceClassLoader(File file) throws MalformedURLException {
        super(new URL[]{file.toURL()});
        this.url = file.toURL();
        try {
            URL[] urls = this.getURLs();
            URLConnection uc = this.url.openConnection();
            uc.setUseCaches(false);
            uc.setDefaultUseCaches(false);
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
        }
        this._file = file;
    }

    public String getEntryClassName() throws IOException {
        if (this._file != null) {
            System.out.println("Getting attributes from jar file");
            JarFile jarFile = new JarFile(this._file);
            return jarFile.getManifest().getMainAttributes().getValue("Port-Service-Class");
        }
        URL u = new URL("jar", "", this.url + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        uc.setUseCaches(false);
        Attributes attr = uc.getMainAttributes();
        return attr.getValue("Port-Service-Class");
    }

    public DeviceService startService(String name, InstrumentPort port) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String[] args = new String[]{""};
        Class<?> c = this.loadClass(name);
        DeviceService deviceService = (DeviceService)c.newInstance();
        long dl = DebugMessage.getLevel();
        DebugMessage.setLevel(1L);
        deviceService.start(port, args);
        DebugMessage.setLevel(dl);
        return deviceService;
    }
}

