/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentPort;
import moos.deployed.NodeProperties;
import moos.deployed.PuckSerialInstrumentPort;
import moos.deployed.RangeException;
import moos.deployed.RemoteSerialPortServer;
import moos.deployed.SerialInstrumentPort;
import moos.deployed.SerialPortParameters;
import moos.deployed.ServiceProperties;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.InvalidPropertyException;
import org.mbari.isi.interfaces.Location;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.MissingPropertyException;
import org.mbari.isi.interfaces.NoChildrenException;
import org.mbari.isi.interfaces.NoParentException;
import org.mbari.isi.interfaces.Parent;
import org.mbari.isi.interfaces.RemoteSerialPort;
import org.mbari.isi.interfaces.UnknownLocationException;

public abstract class DeviceService
extends UnicastRemoteObject
implements Device {
    Parent _parentNode = null;
    private static final String ISI_ID_KEY = "isiID";
    protected String _serviceName;
    protected String _registryName;
    protected ServiceProperties _serviceProperties = new ServiceProperties();
    protected NodeProperties _nodeProperties = null;
    protected InstrumentPort _instrumentPort = null;
    protected InputStream _fromDevice;
    protected OutputStream _toDevice;
    protected byte[] _serviceXMLPath;
    protected byte[] _serviceCachePath;
    protected byte[] _servicePropertiesPath;
    private long _deviceID = 0L;
    private RemoteSerialPortServer _serialPortServer = null;
    private int _serviceStatus = 2;

    public DeviceService() throws RemoteException {
        this._serviceName = this.getClass().getName();
        this.setStatusInitial();
    }

    public void setServiceXMLPath(byte[] path) {
        this._serviceXMLPath = path;
    }

    public void setServicePropertiesPath(byte[] path) {
        this._servicePropertiesPath = path;
    }

    public void setServiceCachePath(byte[] path) {
        this._serviceCachePath = path;
    }

    public void loadProperties(InputStream input) throws IOException, MissingPropertyException, InvalidPropertyException {
        this._serviceProperties.load(input);
        try {
            this._deviceID = this._serviceProperties.getDeviceID();
            DebugMessage.println("DeviceService: deviceID=" + this._deviceID);
        }
        catch (MissingPropertyException e) {
            System.err.println("MissingPropertyException: " + e.getMessage());
            throw e;
        }
        catch (InvalidPropertyException e) {
            System.err.println("InvalidPropertyException: " + e.getMessage());
            throw e;
        }
        String serviceName = this._serviceProperties.getProperty("serviceName");
        if (serviceName != null) {
            this._serviceName = serviceName;
        }
        if ((serviceName = this._serviceProperties.getProperty("registryName")) != null) {
            this._registryName = serviceName;
        }
    }

    public void initialize() throws InitializeException {
    }

    public long getId() {
        return this._deviceID;
    }

    public void setParent(Parent parent) {
        this._parentNode = parent;
    }

    public final byte[] getName() {
        return this._serviceName.getBytes();
    }

    public final byte[] getRegistryName() {
        return this._registryName.getBytes();
    }

    public byte[] getCommPortName() {
        return this._instrumentPort.getCommPortName().getBytes();
    }

    public RemoteSerialPort getRemoteSerialPort() throws IOException, UnknownHostException {
        RemoteSerialPort rs = null;
        try {
            rs = this.getRemoteSerialPort(60000);
        }
        catch (RangeException e) {
            System.err.println(e);
        }
        return rs;
    }

    public RemoteSerialPort getRemoteSerialPort(int timeout) throws IOException, RangeException, UnknownHostException {
        if (this.getStatus() != 4) {
            throw new IOException("service on port " + new String(this.getCommPortName()) + " not suspended");
        }
        if (this._serialPortServer != null) {
            throw new IOException("remote serial port already active on " + new String(this.getCommPortName()));
        }
        this._serialPortServer = new RemoteSerialPortServer(this.getInstrumentPort(), this);
        this._serialPortServer.setTimeout(timeout);
        this._serialPortServer.start();
        return new RemoteSerialPort(this._serialPortServer.getServerInetAddress(), this._serialPortServer.getServerPort());
    }

    public InstrumentPort getInstrumentPort() {
        return this._instrumentPort;
    }

    public byte[] getServiceXMLPath() {
        return this._serviceXMLPath;
    }

    public InetAddress host() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public void start(InstrumentPort port, String[] args) {
        DebugMessage.println(this.getClass().getName() + ".start()");
        this.setInstrumentPort(port);
        try {
            this._fromDevice = this._instrumentPort.getInputStream();
            this._toDevice = this._instrumentPort.getOutputStream();
            if (port instanceof SerialInstrumentPort || port instanceof PuckSerialInstrumentPort) {
                DebugMessage.println("DevcieService.start(): InstrumentPort instanceof " + port.getClass().getName());
                SerialInstrumentPort sip = (SerialInstrumentPort)this._instrumentPort;
                sip.setSerialPortParams(this.getSerialPortParameters());
            }
        }
        catch (Exception e) {
            System.err.println("start() failed: " + e);
        }
    }

    public synchronized void shutdown() {
        DebugMessage.setLevel(0L);
        DebugMessage.println("DeviceService.shutdown() - disconnect power");
        this._instrumentPort.shutDown();
        this.setStatusShutdown();
        DebugMessage.setLevel(0L);
    }

    public void setSerialPort() throws IOException, UnsupportedCommOperationException {
        if (!(this._instrumentPort instanceof SerialInstrumentPort)) {
            throw new IOException("setSerialPort() failed: InstrumentPort is not SerialInstrumentPort");
        }
        SerialInstrumentPort sip = (SerialInstrumentPort)this._instrumentPort;
        sip.setSerialPortParams(this.getSerialPortParameters());
        this._fromDevice = this._instrumentPort.getInputStream();
        this._toDevice = this._instrumentPort.getOutputStream();
    }

    public void setInstrumentPort(InstrumentPort port) {
        this._instrumentPort = port;
    }

    void instrumentPowerOff() {
        this._instrumentPort.disconnectPower();
    }

    void instrumentPowerOn() {
        this._instrumentPort.connectPower();
    }

    void commPowerOff() {
        this._instrumentPort.disableCommunications();
    }

    void commPowerOn() {
        this._instrumentPort.disableCommunications();
    }

    public synchronized void suspend() {
        this.setStatusSuspend();
        this._instrumentPort.suspend();
        this._instrumentPort.enableCommunications();
        System.out.println("Now in DeviceService.suspend()");
    }

    public synchronized void resume() {
        System.out.println("Now in DeviceService.resume()");
        if (this._serialPortServer != null) {
            this._serialPortServer.shutdown();
            this._serialPortServer = null;
        }
        try {
            this._instrumentPort.resume();
            this.setSerialPort();
            this.setStatusOk();
            System.out.println("Done with DeviceService.resume()");
        }
        catch (UnsupportedCommOperationException e) {
            System.err.println("DeviceService.resume(): caught UnsupportedCommOperationException");
        }
        catch (IOException e) {
            System.err.println("DeviceService.resume(): caught IOException");
        }
        catch (Exception e) {
            System.err.println("DeviceService.resume(): caught Exception");
        }
    }

    protected void write(OutputStream ostream, byte[] src) throws IOException {
        this.write(ostream, src, src.length);
    }

    protected void write(OutputStream ostream, byte[] src, int valid) throws IOException {
        ostream.write(src, 0, valid);
    }

    public int getStatus() {
        return this._serviceStatus;
    }

    protected final void setStatusError() {
        this._serviceStatus = 1;
    }

    protected final void setStatusShutdown() {
        this._serviceStatus = 3;
    }

    protected final void setStatusInitial() {
        this._serviceStatus = 2;
    }

    protected final void setStatusOk() {
        this._serviceStatus = 0;
    }

    protected final void setStatusSampling() {
        this._serviceStatus = 5;
    }

    protected final void setStatusSuspend() {
        this._serviceStatus = 4;
    }

    public abstract SerialPortParameters getSerialPortParameters() throws UnsupportedCommOperationException;

    public void initializePropertyDefaults() throws InitializeException {
    }

    public void setNodeProperties(NodeProperties nodeProperties) throws MissingPropertyException, InvalidPropertyException {
        this._nodeProperties = nodeProperties;
    }

    public byte[] getServiceStateMetadata() {
        String mdString = "";
        mdString = mdString + "name=\"";
        try {
            mdString = mdString + new String(this.getName());
        }
        catch (NullPointerException e) {
            mdString = mdString + "N/A";
        }
        mdString = mdString + "\"\n";
        mdString = mdString + "deviceID=\"" + this.getId() + "\"\n";
        mdString = mdString + "registryName=\"";
        try {
            mdString = mdString + new String(this.getRegistryName());
        }
        catch (NullPointerException e) {
            mdString = mdString + "N/A";
        }
        mdString = mdString + "\"\n";
        return mdString.getBytes();
    }

    public abstract MetadataPacket createMetadataPacket(String var1, int var2, boolean var3) throws RemoteException;

    public abstract byte[] getMetadata() throws RemoteException;

    public abstract Location getLocation() throws RemoteException, UnknownLocationException;

    public abstract Device[] getChildren() throws NoChildrenException, RemoteException;

    public abstract Device getParent() throws NoParentException, RemoteException;

    public abstract int test() throws RemoteException;

    public abstract int powerOn() throws RemoteException;

    public abstract int powerOff() throws RemoteException;
}

