/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

public class DeviceLogJournalEntry {
    public static final int LOG_JOURNAL_ENTRY_SIZE = 40;
    protected int numEntries;
    protected int lastEntryAccessed;
    protected long minKey;
    protected long maxKey;
    protected long _lastSequenceNumber;
    protected long _lastMetadataRef;

    public DeviceLogJournalEntry() {
    }

    public DeviceLogJournalEntry(int numEntries, int lastEntryAccessed, long minKey, long maxKey, long lastSequenceNumber, long lastMetadataRef) {
        this.numEntries = numEntries;
        this.lastEntryAccessed = lastEntryAccessed;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this._lastSequenceNumber = lastSequenceNumber;
        this._lastMetadataRef = lastMetadataRef;
    }

    public long getMinKey() {
        return this.minKey;
    }

    public long getMaxKey() {
        return this.maxKey;
    }

    public int getLastEntryAccessed() {
        return this.lastEntryAccessed;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public long getLastSequenceNumber() {
        return this._lastSequenceNumber;
    }

    public long getLastMetadataRef() {
        return this._lastMetadataRef;
    }

    public synchronized void toFile(RandomAccessFile file) {
        try {
            file.writeInt(this.numEntries);
            file.writeInt(this.lastEntryAccessed);
            file.writeLong(this.minKey);
            file.writeLong(this.maxKey);
            file.writeLong(this._lastSequenceNumber);
            file.writeLong(this._lastMetadataRef);
        }
        catch (IOException ioe) {
            System.out.println("! IOException on journal entry write");
        }
        try {
            FileDescriptor fd = file.getFD();
            try {
                fd.sync();
            }
            catch (SyncFailedException sfe) {
                System.err.println("DeviceLogJournalEntry:toFile: sync fail");
            }
        }
        catch (IOException ioe) {
            System.err.println("DeviceLogJournalEntry:toFile: getFD fail");
        }
    }

    public synchronized void fromFile(RandomAccessFile file) {
        try {
            this.numEntries = file.readInt();
            this.lastEntryAccessed = file.readInt();
            this.minKey = file.readLong();
            this.maxKey = file.readLong();
            this._lastSequenceNumber = file.readLong();
            this._lastMetadataRef = file.readLong();
        }
        catch (IOException ioe) {
            System.out.println("! IOException on journal entry read");
        }
    }
}

