/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

public class DeviceLogIndexEntry {
    public static final int LOG_INDEX_ENTRY_SIZE = 32;
    protected int entryIndex;
    protected int dataSize;
    protected long dataOffset;
    protected long key;
    protected long _sequenceNumber;

    public DeviceLogIndexEntry(long key, int dataSize, long dataOffset, long sequenceNumber) {
        this.dataSize = dataSize;
        this.dataOffset = dataOffset;
        this.key = key;
        this._sequenceNumber = sequenceNumber;
    }

    public DeviceLogIndexEntry() {
    }

    public void setEntryIndex(int index) {
        this.entryIndex = index;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public long getKey() {
        return this.key;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public void setDataOffset(long dataOffset) {
        this.dataOffset = dataOffset;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this._sequenceNumber = sequenceNumber;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public synchronized void toFile(RandomAccessFile file) {
        try {
            file.writeInt(this.entryIndex);
            file.writeInt(this.dataSize);
            file.writeLong(this.dataOffset);
            file.writeLong(this.key);
            file.writeLong(this._sequenceNumber);
        }
        catch (IOException ioe) {
            System.err.println("DeviceLogIndexEntry:toFile: ! IOException on index file entry write");
        }
        try {
            FileDescriptor fd = file.getFD();
            try {
                fd.sync();
            }
            catch (SyncFailedException sfe) {
                System.err.println("DeviceLogIndexEntry:toFile: sync failed");
            }
        }
        catch (IOException ioe) {
            System.err.println("DeviceLogIndexEntry:toFile: getFD exception");
        }
    }

    public synchronized void fromFile(RandomAccessFile file) {
        try {
            this.entryIndex = file.readInt();
            this.dataSize = file.readInt();
            this.dataOffset = file.readLong();
            this.key = file.readLong();
            this._sequenceNumber = file.readLong();
        }
        catch (IOException ioe) {
            System.err.println("DeviceLogIndexEntry:fromFile: ! IOException on index file entry read");
        }
    }
}

