/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceLogIndexEntry;
import moos.deployed.DeviceLogJournalEntry;

public class DeviceLogIndex {
    protected RandomAccessFile idxFile = null;
    protected long currentIdxFileExtent = 0L;
    protected int currentIdxEntry = 0;
    protected int currentGetEntry = 0;
    protected long minKey = Long.MAX_VALUE;
    protected long maxKey = Long.MIN_VALUE;
    protected long _lastSequenceNumber = 0L;
    protected long _lastMetadataRef = 0L;
    protected long deviceId;
    public static final int JOURNAL_ENTRY_OFFSET = 0;

    public DeviceLogIndex(long deviceId, int seqNum, String directory) {
        this.deviceId = deviceId;
        String indexFileName = this.getIdxFileName(seqNum, directory);
        File openAttempt = new File(indexFileName);
        if (openAttempt.exists()) {
            try {
                this.idxFile = new RandomAccessFile(indexFileName, "rw");
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("DeviceLogIndex.ctor: #1: file \"" + indexFileName + "\" not found");
            }
            try {
                this.currentIdxFileExtent = this.idxFile.length();
            }
            catch (IOException ioe) {
                System.err.println("DeviceLogIndex ctor: IOException: " + ioe);
            }
            this.restoreJournalInfo();
        } else {
            try {
                this.idxFile = new RandomAccessFile(indexFileName, "rw");
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("DeviceLogIndex.ctor: #2: file \"" + indexFileName + "\" not found");
            }
            this.initJournalEntry();
        }
    }

    protected String getIdxFileName(int seqNum, String directory) {
        return new String(directory + File.separator + this.deviceId + "_" + seqNum + ".idx");
    }

    private void initJournalEntry() {
        ++this.currentIdxEntry;
        ++this.currentGetEntry;
        this.currentIdxFileExtent += 40L;
        this.updateJournalEntry();
    }

    private void updateJournalEntry() {
        DeviceLogJournalEntry journalEntry = new DeviceLogJournalEntry(this.currentIdxEntry, this.currentGetEntry, this.minKey, this.maxKey, this._lastSequenceNumber, this._lastMetadataRef);
        try {
            this.idxFile.seek(0L);
        }
        catch (IOException ioe) {
            System.err.println("DeviceLogIndex:updateJournalEntry: seek fail");
        }
        journalEntry.toFile(this.idxFile);
    }

    private void restoreJournalInfo() {
        try {
            this.idxFile.seek(0L);
        }
        catch (IOException ioe) {
            System.err.println("DeviceLogIndex:restoreJournalInfo: seek error");
        }
        DeviceLogJournalEntry journalEntry = new DeviceLogJournalEntry();
        journalEntry.fromFile(this.idxFile);
        this.currentIdxEntry = journalEntry.getNumEntries();
        this.currentGetEntry = journalEntry.getLastEntryAccessed();
        this.minKey = journalEntry.getMinKey();
        this.maxKey = journalEntry.getMaxKey();
        this._lastSequenceNumber = journalEntry.getLastSequenceNumber() + 1L;
        this._lastMetadataRef = journalEntry.getLastMetadataRef();
    }

    public synchronized void addDeviceLogIndex(DeviceLogIndexEntry slie) {
        if (this.currentIdxEntry == Integer.MAX_VALUE) {
            return;
        }
        if (slie == null) {
            return;
        }
        long key = slie.getKey();
        if (key < this.minKey) {
            this.minKey = key;
        }
        if (key > this.maxKey) {
            this.maxKey = key;
        }
        slie.setEntryIndex(this.currentIdxEntry);
        try {
            this.idxFile.seek(this.currentIdxFileExtent);
        }
        catch (IOException ioe) {
            System.err.println("addDeviceLogIndex: IOException while seeking " + ioe);
        }
        slie.toFile(this.idxFile);
        this.currentIdxFileExtent += 32L;
        ++this.currentIdxEntry;
        this._lastSequenceNumber = slie.getSequenceNumber();
        this.updateJournalEntry();
    }

    protected synchronized DeviceLogIndexEntry getDeviceLogIndexEntry(int entryIndex, DeviceLogIndexEntry slie) {
        if (entryIndex >= this.currentIdxEntry || slie == null) {
            return null;
        }
        if (entryIndex < 1) {
            return null;
        }
        long entryOffset = (entryIndex - 1) * 32 + 40;
        if (entryOffset < this.currentIdxFileExtent) {
            try {
                this.idxFile.seek(entryOffset);
            }
            catch (IOException ioe) {
                System.err.println("getDeviceLogIndexEntry: IOException: seek" + ioe.getMessage());
            }
            slie.fromFile(this.idxFile);
        }
        return slie;
    }

    protected synchronized DeviceLogJournalEntry getDeviceLogJournalEntry(DeviceLogJournalEntry slje) {
        int entryIndex = 0;
        if (entryIndex >= this.currentIdxEntry || slje == null) {
            return null;
        }
        long entryOffset = 0L;
        if (entryOffset < this.currentIdxFileExtent) {
            try {
                this.idxFile.seek(entryOffset);
            }
            catch (IOException ioe) {
                System.err.println("getDeviceLogIndexEntry: seek" + ioe.getMessage());
            }
        }
        slje.fromFile(this.idxFile);
        return slje;
    }

    protected DeviceLogJournalEntry getDeviceLogJournalEntry() {
        return this.getDeviceLogJournalEntry(new DeviceLogJournalEntry());
    }

    protected DeviceLogIndexEntry getDeviceLogIndexEntry(int entryIndex) {
        return this.getDeviceLogIndexEntry(entryIndex, new DeviceLogIndexEntry());
    }

    public long getMinDeviceLogIndexKey() {
        return this.minKey;
    }

    public long getMaxDeviceLogIndexKey() {
        return this.maxKey;
    }

    public long getLastSequenceNumber() {
        return this._lastSequenceNumber;
    }

    public long getLastMetadataRef() {
        return this._lastMetadataRef;
    }

    public void updateMetadataRef(long mdref) {
        this._lastMetadataRef = mdref;
        this.updateJournalEntry();
    }

    public int numberOfEntries(long beginKey, long endKey) {
        DebugMessage.println("numberOfEntries, deviceId=" + this.deviceId);
        DebugMessage.println("beginKey=" + beginKey + ", minKey=" + this.minKey);
        DebugMessage.println("endKey=" + endKey + ", maxKey=" + this.maxKey);
        if (beginKey > endKey) {
            System.err.println("numberOfEntries(): invalid key range for " + this.deviceId);
            return 0;
        }
        if (beginKey > this.maxKey) {
            DebugMessage.println("numberOfEntries(): beginKey out of range for device " + this.deviceId);
            return 0;
        }
        if (endKey < this.minKey) {
            System.err.println("numberOfEntries(): endKey out of range for device " + this.deviceId);
            return 0;
        }
        int curIndex = 1;
        DeviceLogIndexEntry curEntry = new DeviceLogIndexEntry();
        int resultSetSize = 0;
        while (curIndex < this.currentIdxEntry) {
            long key = (curEntry = this.getDeviceLogIndexEntry(curIndex, curEntry)).getKey();
            if (key >= beginKey && key <= endKey) {
                ++resultSetSize;
            }
            ++curIndex;
        }
        return resultSetSize;
    }

    public Vector getEntriesByTimeRange(long beginKey, long endKey) {
        if (beginKey > endKey) {
            DebugMessage.println("queryKeyRange: invalid key range!");
            return null;
        }
        if (beginKey > this.maxKey) {
            DebugMessage.println("queryKeyRange: begin key out of range:");
            DebugMessage.println("queryKeyRange: beginKey=" + beginKey);
            DebugMessage.println("queryKeyRange: maxKey=" + this.maxKey);
            return null;
        }
        if (endKey < this.minKey) {
            DebugMessage.println("queryKeyRange: end key out of range:");
            DebugMessage.println("queryKeyRange: endKey=" + endKey);
            DebugMessage.println("queryKeyRange: minKey=" + this.minKey);
            return null;
        }
        int curIndex = 1;
        DeviceLogIndexEntry curEntry = new DeviceLogIndexEntry();
        Vector<DeviceLogIndexEntry> resultSet = null;
        while (curIndex < this.currentIdxEntry) {
            long key = (curEntry = this.getDeviceLogIndexEntry(curIndex, curEntry)).getKey();
            if (key >= beginKey && key <= endKey) {
                if (resultSet == null) {
                    resultSet = new Vector<DeviceLogIndexEntry>();
                }
                resultSet.add(curEntry);
                curEntry = new DeviceLogIndexEntry();
            }
            ++curIndex;
        }
        return resultSet;
    }

    public Vector getEntries(long beginKey, long nEntries) {
        DebugMessage.println("getEntries(), deviceId=" + this.deviceId + ", beginKey=" + beginKey + ", nEntries=" + nEntries);
        if (beginKey > this.maxKey) {
            DebugMessage.println("getEntries: beginKey out of range for device " + this.deviceId);
            DebugMessage.println("getEntries: beginKey=" + beginKey);
            DebugMessage.println("getEntries: maxKey=" + this.maxKey);
            return null;
        }
        int curIndex = 1;
        DeviceLogIndexEntry curEntry = new DeviceLogIndexEntry();
        Vector<DeviceLogIndexEntry> resultSet = null;
        int nRead = 0;
        while (curIndex < this.currentIdxEntry && (long)nRead < nEntries) {
            long key = (curEntry = this.getDeviceLogIndexEntry(curIndex, curEntry)).getKey();
            if (key >= beginKey) {
                if (resultSet == null) {
                    resultSet = new Vector<DeviceLogIndexEntry>();
                }
                resultSet.add(curEntry);
                ++nRead;
                curEntry = new DeviceLogIndexEntry();
            }
            ++curIndex;
        }
        return resultSet;
    }

    public DeviceLogIndexEntry getNextDeviceLogIndexEntry() {
        DeviceLogIndexEntry retEntry = null;
        if (this.getDeviceLogNumUnread() > 0) {
            retEntry = this.getDeviceLogIndexEntry(this.currentGetEntry++);
            this.updateJournalEntry();
        } else {
            System.out.println("getNextDeviceLogIndexEntry: no logs");
        }
        return retEntry;
    }

    public synchronized int getDeviceLogNumUnread() {
        return this.currentIdxEntry - this.currentGetEntry;
    }
}

