/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import moos.deployed.DeviceLogIndexEntry;

public class DeviceLogData {
    protected RandomAccessFile dataFile = null;
    protected long deviceId;
    protected long currentDataFileExtent = 0L;

    public DeviceLogData(long deviceId, int seqNumber, String directory) {
        this.deviceId = deviceId;
        String dataFileName = this.getDataFileName(seqNumber, directory);
        File openAttempt = new File(dataFileName);
        if (openAttempt.exists()) {
            try {
                this.dataFile = new RandomAccessFile(dataFileName, "rw");
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("DeviceLogData.ctor: file not found");
            }
            try {
                this.currentDataFileExtent = this.dataFile.length();
            }
            catch (IOException ioe) {
                System.err.println("DeviceLogData.ctor: data file length exc");
            }
        } else {
            try {
                this.dataFile = new RandomAccessFile(dataFileName, "rw");
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
        }
    }

    private String getDataFileName(int seqNum, String directory) {
        return new String(directory + File.separator + this.deviceId + "_" + seqNum + ".dat");
    }

    public synchronized void appendLogData(byte[] serializedData, DeviceLogIndexEntry indexEntry) {
        long seekOffset = this.currentDataFileExtent;
        if (indexEntry == null || serializedData == null) {
            System.err.println("DeviceLogData:appendLogData: null idx entry");
            return;
        }
        int dataLength = serializedData.length;
        indexEntry.dataOffset = seekOffset;
        indexEntry.dataSize = dataLength;
        try {
            this.dataFile.seek(seekOffset);
            this.dataFile.write(serializedData);
        }
        catch (IOException ioe) {
            System.err.println("appendLogData: seek/write exception");
        }
        try {
            FileDescriptor fd = this.dataFile.getFD();
            try {
                fd.sync();
            }
            catch (SyncFailedException sfe) {
                System.err.println("appendLogData: fd sync failed");
            }
        }
        catch (IOException ioe) {
            System.err.println("appendLogData: seek/write exception");
        }
        this.currentDataFileExtent += (long)dataLength;
    }

    public synchronized byte[] readLogData(DeviceLogIndexEntry indexEntry) {
        byte[] result = null;
        int bytesRead = 0;
        if (indexEntry == null) {
            System.err.println("DeviceLogData:readLogData: null index entry");
            return result;
        }
        if (indexEntry.dataOffset >= this.currentDataFileExtent) {
            System.err.println("DeviceLogData:readLogData: data offset error");
            return result;
        }
        try {
            this.dataFile.seek(indexEntry.dataOffset);
        }
        catch (IOException ioe) {
            System.err.println("readLogData: data file seek exception");
        }
        result = new byte[indexEntry.dataSize];
        try {
            bytesRead = this.dataFile.read(result);
        }
        catch (IOException ioe) {
            System.err.println("readLogData: data file seek exception");
        }
        if (bytesRead != indexEntry.dataSize) {
            System.out.println("readLogData: data size mismatch");
            System.out.println("  bytes read from file: " + bytesRead);
            System.out.println("  dataSize in index entry: " + indexEntry.dataSize);
        }
        return result;
    }
}

