/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Vector;
import moos.deployed.DebugMessage;
import moos.deployed.DeviceLogData;
import moos.deployed.DeviceLogIndex;
import moos.deployed.DeviceLogIndexEntry;
import moos.deployed.DeviceLogJournalEntry;
import moos.deployed.RangeException;
import moos.deployed.SequenceNumber;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.DevicePacket;
import org.mbari.isi.interfaces.DevicePacketSet;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.SensorDataPacket;

public class DeviceLog {
    private static final Object classLock = class$moos$deployed$DeviceLog == null ? (class$moos$deployed$DeviceLog = DeviceLog.class$("moos.deployed.DeviceLog")) : class$moos$deployed$DeviceLog;
    private static int activeCount = 0;
    private int seqNum = 0;
    private long deviceId = 0L;
    private long _metadataRef = 0L;
    private SequenceNumber _sequenceNumber;
    protected DeviceLogIndex index;
    protected DeviceLogData data;
    static /* synthetic */ Class class$moos$deployed$DeviceLog;

    public DeviceLog(long deviceId, int seqNum, String directory) {
        this.deviceId = deviceId;
        this.index = new DeviceLogIndex(deviceId, seqNum, directory);
        this.data = new DeviceLogData(deviceId, seqNum, directory);
        try {
            long startSequence = this.index.getLastSequenceNumber();
            DebugMessage.println("DeviceLog: initializing log sequence number: " + startSequence);
            this._sequenceNumber = new SequenceNumber(Long.MIN_VALUE, Long.MAX_VALUE, startSequence);
        }
        catch (RangeException e) {
            System.err.println("DeviceLog: RangeException creating SequenceNumber");
        }
        this._metadataRef = this.index.getLastMetadataRef();
    }

    public DeviceLog(long deviceId, String directory) {
        this(deviceId, 0, directory);
    }

    public static int getActiveCount() {
        return activeCount;
    }

    private static void incrActiveCount() {
        Object object = classLock;
        synchronized (object) {
            ++activeCount;
        }
    }

    private static void decrActiveCount() {
        Object object = classLock;
        synchronized (object) {
            --activeCount;
        }
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public synchronized void appendPacket(DevicePacket packet) {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        byte[] serializedPacket = null;
        int objectSize = 0;
        DeviceLog.incrActiveCount();
        long key = packet.systemTime();
        long sequenceNumber = this._sequenceNumber.getNext();
        packet.setSequenceNo(sequenceNumber);
        packet.setMetadataRef(this._metadataRef);
        if (packet instanceof MetadataPacket) {
            this._metadataRef = sequenceNumber;
            this.index.updateMetadataRef(this._metadataRef);
        }
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(packet);
            oos.flush();
            serializedPacket = bos.toByteArray();
            objectSize = serializedPacket.length;
        }
        catch (Exception e) {
            System.err.println("appendPacket: serialization exception");
        }
        DeviceLogIndexEntry newIndexEntry = new DeviceLogIndexEntry();
        newIndexEntry.setKey(key);
        newIndexEntry.setDataSize(objectSize);
        newIndexEntry.setSequenceNumber(sequenceNumber);
        this.data.appendLogData(serializedPacket, newIndexEntry);
        this.index.addDeviceLogIndex(newIndexEntry);
        try {
            oos.close();
            bos.close();
        }
        catch (Exception e) {
            System.err.println("appendPacket:append exception on close " + e.getMessage());
            e.printStackTrace();
        }
        DeviceLog.decrActiveCount();
    }

    public DevicePacketSet getPacketKeyRange(long startKey, long endKey, int maxEntries) throws NoDataException {
        Vector indexSet;
        DeviceLog.incrActiveCount();
        int nEntries = this.index.numberOfEntries(startKey, endKey);
        boolean complete = true;
        if (nEntries > maxEntries) {
            complete = false;
            nEntries = maxEntries;
        }
        if ((indexSet = this.index.getEntries(startKey, nEntries)) == null) {
            System.err.println("No data for device " + this.deviceId);
            throw new NoDataException();
        }
        System.err.print("getPacketKeyRange(): Found " + indexSet.size() + " entries for device " + this.deviceId);
        if (complete) {
            System.err.println(" Set is complete");
        } else {
            System.err.println(" Set is INCOMPLETE");
        }
        int i = 0;
        while (i < indexSet.size()) {
            DeviceLogIndexEntry slie = (DeviceLogIndexEntry)indexSet.elementAt(i);
            indexSet.setElementAt(this.getPacket(slie), i);
            ++i;
        }
        DeviceLog.decrActiveCount();
        return new DevicePacketSet(indexSet, complete);
    }

    public DevicePacket getNextPacket() {
        if (this.index.getDeviceLogNumUnread() > 0) {
            DeviceLogIndexEntry slie = this.index.getNextDeviceLogIndexEntry();
            return this.getPacket(slie);
        }
        return null;
    }

    private synchronized DevicePacket getPacket(DeviceLogIndexEntry slie) {
        DevicePacket retPacket = null;
        if (slie == null) {
            return null;
        }
        DeviceLog.incrActiveCount();
        byte[] serializedPacket = this.data.readLogData(slie);
        if (serializedPacket != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(serializedPacket);
                ObjectInputStream ois = new ObjectInputStream(bis);
                retPacket = (DevicePacket)ois.readObject();
                ois.close();
                bis.close();
            }
            catch (StreamCorruptedException sce) {
                System.err.println("getPacket: object deserialize error" + sce.getMessage());
            }
            catch (IOException ioe) {
                System.err.println("getPacket: io error" + ioe.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("getPacket: class not found" + cnfe.getMessage());
            }
        }
        DeviceLog.decrActiveCount();
        return retPacket;
    }

    public Vector getPacketSequenceGaps() {
        int currentIdxEntry = 1;
        boolean numIdxEntriesProcessed = false;
        DeviceLog.incrActiveCount();
        DeviceLogJournalEntry journalEntry = this.index.getDeviceLogJournalEntry();
        if (journalEntry == null) {
            System.err.println("scanMissedEntries: no index entries\n");
            return null;
        }
        int numIdxEntriesTotal = journalEntry.getNumEntries();
        if (numIdxEntriesTotal == 0) {
            return null;
        }
        DeviceLogIndexEntry indexEntry = new DeviceLogIndexEntry();
        DevicePacket prevPacket = null;
        DevicePacket currentPacket = null;
        int i = currentIdxEntry;
        while (i < numIdxEntriesTotal) {
            this.index.getDeviceLogIndexEntry(i, indexEntry);
            System.out.println("Processing index entry: " + i + "\r");
            System.out.flush();
            byte[] tmp = this.data.readLogData(indexEntry);
            if (tmp != null) {
                long curSeqNum;
                long prevSeqNum;
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(tmp);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    currentPacket = (DevicePacket)ois.readObject();
                    ois.close();
                    bis.close();
                }
                catch (StreamCorruptedException sce) {
                    System.err.println("getPacketSequenceGaps: object deserialize error" + sce.getMessage());
                }
                catch (IOException ioe) {
                    System.err.println("getPacketSequenceGaps: io error" + ioe.getMessage());
                }
                catch (ClassNotFoundException cnfe) {
                    System.err.println("getPacketSequenceGaps: class not found" + cnfe.getMessage());
                }
                tmp = null;
                if (prevPacket != null && (prevSeqNum = prevPacket.sequenceNo()) + 1L != (curSeqNum = currentPacket.sequenceNo())) {
                    System.err.println("Sequence gap, current= " + curSeqNum + ", prev= " + prevSeqNum);
                }
                prevPacket = currentPacket;
                currentPacket = null;
            } else {
                System.err.println("getPacketSequenceGaps: null ");
            }
            ++i;
        }
        DeviceLog.decrActiveCount();
        return null;
    }

    public void printAllPackets() {
        int currentIdxEntry = 1;
        boolean numIdxEntriesProcessed = false;
        DeviceLog.incrActiveCount();
        DeviceLogJournalEntry journalEntry = this.index.getDeviceLogJournalEntry();
        if (journalEntry == null) {
            System.err.println("printAllPackets: no index entries\n");
            return;
        }
        int numIdxEntriesTotal = journalEntry.getNumEntries();
        if (numIdxEntriesTotal == 0) {
            return;
        }
        DeviceLogIndexEntry indexEntry = new DeviceLogIndexEntry();
        Object currentPacket = null;
        int i = currentIdxEntry;
        while (i < numIdxEntriesTotal) {
            this.index.getDeviceLogIndexEntry(i, indexEntry);
            System.out.println("Index entry " + (i + 1) + " of " + numIdxEntriesTotal);
            byte[] tmp = this.data.readLogData(indexEntry);
            if (tmp != null) {
                try {
                    DevicePacket packet;
                    ByteArrayInputStream bis = new ByteArrayInputStream(tmp);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    Object untypedPacket = ois.readObject();
                    if (untypedPacket instanceof MetadataPacket) {
                        packet = (MetadataPacket)untypedPacket;
                        DevicePacket dp = (DevicePacket)untypedPacket;
                        System.out.println(dp.toString());
                        System.out.println("Metadata: cause=" + new String(((MetadataPacket)packet).cause()) + "\nData:\n" + new String(((MetadataPacket)packet).getBytes()) + "\n");
                    } else if (untypedPacket instanceof DevicePacket) {
                        packet = (DevicePacket)untypedPacket;
                        System.out.println(packet.toString() + "\n");
                        if (untypedPacket instanceof SensorDataPacket) {
                            PrintUtils.printAscii(((SensorDataPacket)packet).dataBuffer(), 0, 0);
                            System.out.println("");
                        }
                    } else {
                        System.out.println("Object from log is not a DevicePacket!");
                    }
                    tmp = null;
                    ois.close();
                    bis.close();
                }
                catch (StreamCorruptedException sce) {
                    System.err.println("getPacketSequenceGaps: object deserialize error" + sce.getMessage());
                }
                catch (IOException ioe) {
                    System.err.println("getPacketSequenceGaps: io error" + ioe.getMessage());
                }
                catch (ClassNotFoundException cnfe) {
                    System.err.println("getPacketSequenceGaps: class not found" + cnfe.getMessage());
                }
            } else {
                System.err.println("printAllPackets: null data stream");
            }
            ++i;
        }
        DeviceLog.decrActiveCount();
    }

    public int getNumUnreadPackets() {
        return this.index.getDeviceLogNumUnread();
    }

    public long getMinKey() {
        return this.index.getMinDeviceLogIndexKey();
    }

    public long getMaxKey() {
        return this.index.getMaxDeviceLogIndexKey();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

