/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import moos.deployed.LddMaster;
import moos.deployed.NodeManager;
import moos.deployed.NodeProperties;
import moos.deployed.NodeService;
import moos.deployed.SiamTimer;
import moos.deployed.SiamTimerTask;
import moos.deployed.SleepManager;
import moos.deployed.SleepRollCallListener;
import moos.interfaces.leasing.LeaseListener;
import moos.interfaces.leasing.LeaseRefused;

public class CommsLeaseListener
implements LeaseListener {
    protected static final int DFLT_POWER_BIT = 32;
    protected static final long RADIO_ACQUIRE_TIME = 5000L;
    protected static final long PROTOCOL_WAIT_TIME = 20000L;
    protected static final int PORTAL_ON = 1;
    protected static final int PORTAL_OFF = 2;
    protected static final int PORTAL_STATE_UNKNOWN = 3;
    protected int _powerBit = 32;
    protected NodeProperties _nodeProperties = null;
    protected NodeService _nodeService = null;
    protected SiamTimer _commsOnTimer = null;
    protected SiamTimer _commsOffTimer = null;
    protected CommsTimerOnTask _commsTimerOnTask = null;
    protected CommsTimerOffTask _commsTimerOffTask = null;
    protected Object _timerSync = new Object();
    protected long _timeOff = 0L;
    protected boolean _powerIsOn = false;
    protected int _portalNotification = 3;
    protected CommsSleepRollCallListener _listener = null;
    protected long _nextEstablishTime = 0L;
    protected LddMaster _ldd = LddMaster.getInstance();
    protected boolean _commsManagerEnabled = true;
    protected long _radioAcquireTime = 5000L;
    protected long _protocolWaitTime = 20000L;
    protected String _reason = null;
    protected boolean _debug = true;

    CommsLeaseListener(NodeService nodeService) {
        this._nodeService = nodeService;
        this._nodeProperties = NodeManager.getInstance().getNodeProperties();
        this._powerBit = this._nodeProperties.getIntegerProperty("CommsManager.powerBit", 32);
        this._radioAcquireTime = this._nodeProperties.getLongProperty("CommsManager.radioAcquireTime", 5000L);
        this._protocolWaitTime = this._nodeProperties.getLongProperty("CommsManager.protocolWaitTime", 20000L);
        String enblString = this._nodeProperties.getProperty("CommsManager.enabled");
        if (enblString != null) {
            this._commsManagerEnabled = enblString.equalsIgnoreCase("true");
        }
        if (this._commsManagerEnabled) {
            this._listener = new CommsSleepRollCallListener();
            SleepManager.getInstance().addSleepRollCallListener(this._listener);
        }
        this._powerIsOn = (this._ldd.getLevels() & this._powerBit) != 0;
        this.debugPrint("CommsLeaseListener() complete");
    }

    protected void powerOn() {
        if (this._powerBit != 0) {
            this._ldd.setBits(this._powerBit);
        }
    }

    protected void powerOff() {
        if (this._powerBit != 0) {
            this._ldd.clearBits(this._powerBit);
        }
    }

    public void leaseEstablishCallback(int leaseID, long leasePeriod, long nextEstablishTime, int numConnections) throws LeaseRefused {
        this.debugPrint("leaseEstablishCallback, LeaseID " + leaseID);
        try {
            Object object = this._timerSync;
            synchronized (object) {
                if (!this._commsManagerEnabled || numConnections > 1) {
                    return;
                }
                this.powerOn();
                this._powerIsOn = true;
                this.debugPrint("RF Power on for LeaseID " + leaseID);
                this._nextEstablishTime = nextEstablishTime;
                if (this._commsOnTimer != null) {
                    this._commsOnTimer.cancel();
                    this._commsOnTimer = null;
                }
                if (this._commsOffTimer != null) {
                    this._commsOffTimer.cancel();
                    this._commsOffTimer = null;
                }
                this._commsOnTimer = new SiamTimer();
                this._commsTimerOnTask = new CommsTimerOnTask();
                this._commsOnTimer.schedule((SiamTimerTask)this._commsTimerOnTask, this._radioAcquireTime);
            }
        }
        catch (Exception e) {
            System.err.println("Exception in leaseEstablishCallback: " + e);
            e.printStackTrace();
        }
    }

    void checkLeaseDone(int leaseID, long nextEstablishTime, String reason) {
        Object object = this._timerSync;
        synchronized (object) {
            if (!this._powerIsOn || !this._commsManagerEnabled) {
                return;
            }
        }
        this._reason = new String("RF Power Off " + reason + " LeaseID " + leaseID);
        if (nextEstablishTime != 0L) {
            this._nextEstablishTime = nextEstablishTime;
        }
        this.debugPrint("Sending notifyPortalLinkDisconnecting() for LeaseID" + leaseID);
        try {
            this._nodeService.notifyPortalLinkDisconnecting(this._nextEstablishTime);
            this._portalNotification = 2;
        }
        catch (Exception e) {
            System.err.println("Exception in checkLeaseDone: " + e);
            e.printStackTrace();
        }
        Object object2 = this._timerSync;
        synchronized (object2) {
            if (this._commsOnTimer != null) {
                this._commsOnTimer.cancel();
                this._commsOnTimer = null;
            }
            this._commsOffTimer = new SiamTimer();
            this._commsTimerOffTask = new CommsTimerOffTask();
            this._commsOffTimer.schedule((SiamTimerTask)this._commsTimerOffTask, this._protocolWaitTime);
        }
    }

    public void leaseTerminatedCallback(int leaseID, long nextEstablishTime, int numConnections) {
        this.debugPrint("leaseTerminatedCallback, LeaseID " + leaseID);
        if (numConnections <= 0) {
            this.checkLeaseDone(leaseID, nextEstablishTime, "by request");
        }
    }

    public void leaseExpiredCallback(int leaseID, long nextEstablishTime, int numConnections) {
        this.debugPrint("leaseExpiredCallback, LeaseID " + leaseID);
        if (numConnections <= 0) {
            this.checkLeaseDone(leaseID, nextEstablishTime, "due to lease timeout");
        }
    }

    public void leaseRenewalCallback(int leaseID, long leasePeriod, int numConnections) throws LeaseRefused {
    }

    protected void debugPrint(String message) {
        if (this._debug) {
            System.out.println(message);
        }
    }

    class CommsSleepRollCallListener
    implements SleepRollCallListener {
        CommsSleepRollCallListener() {
        }

        public long okToSleep() {
            long retVal = Long.MAX_VALUE;
            Object object = CommsLeaseListener.this._timerSync;
            synchronized (object) {
                long estTime;
                if (CommsLeaseListener.this._powerIsOn) {
                    retVal = 0L;
                } else if (CommsLeaseListener.this._nextEstablishTime != 0L && (estTime = CommsLeaseListener.this._nextEstablishTime - System.currentTimeMillis()) >= 0L) {
                    retVal = estTime;
                }
            }
            if (retVal <= 0L) {
                CommsLeaseListener.this.debugPrint("CommsLeaseListener vetoing sleep");
            }
            return retVal;
        }
    }

    class CommsTimerOffTask
    extends SiamTimerTask {
        CommsTimerOffTask() {
        }

        public void run() {
            Object object = CommsLeaseListener.this._timerSync;
            synchronized (object) {
                CommsLeaseListener.this.powerOff();
                CommsLeaseListener.this._powerIsOn = false;
                CommsLeaseListener.this._commsOffTimer.cancel();
                CommsLeaseListener.this._commsOffTimer = null;
            }
            CommsLeaseListener.this.debugPrint(CommsLeaseListener.this._reason);
        }
    }

    class CommsTimerOnTask
    extends SiamTimerTask {
        CommsTimerOnTask() {
        }

        public void run() {
            CommsLeaseListener.this.debugPrint("Sending notifyPortalLinkConnected()");
            try {
                CommsLeaseListener.this._nodeService.notifyPortalLinkConnected();
            }
            catch (Exception e) {
                System.err.println("Exception in CommsTimerOnTask: " + e);
                e.printStackTrace();
            }
            Object object = CommsLeaseListener.this._timerSync;
            synchronized (object) {
                CommsLeaseListener.this._commsOnTimer.cancel();
                CommsLeaseListener.this._commsOnTimer = null;
                CommsLeaseListener.this._portalNotification = 1;
            }
        }
    }
}

