/*
 * Decompiled with CFR 0.152.
 */
package moos.deployed;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import moos.deployed.DebugMessage;
import moos.deployed.InstrumentService;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.InvalidDataException;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.SensorDataPacket;
import org.mbari.isi.interfaces.TimeoutException;

public abstract class AggregateInstrumentService
extends InstrumentService {
    static final int MAX_SAMPLE_LENGTH = 128;
    private int _sampleCount = 0;
    private int _invalidDataCount = 0;
    private int _timeoutCount = 0;
    private int _retryExceededCount = 0;
    private int _badResponseCount = 0;
    private int _totalSampleCount = 0;
    private int _totalRetryExceededCount = 0;
    private int _totalInvalidDataCount = 0;
    private int _totalTimeoutCount = 0;
    private int _totalBadResponseCount = 0;
    protected int _numSensors;

    public AggregateInstrumentService() throws RemoteException {
        this.resetCommStats();
    }

    protected abstract void setNumSensors(int var1);

    protected abstract void requestSample(int var1) throws TimeoutException, Exception;

    protected void requestSample() throws TimeoutException, Exception {
    }

    public synchronized SensorDataPacket acquireSample(boolean logSample) throws NoDataException {
        int maxTries = this.getMaxSampleTries();
        byte[] sampleBuffer = this.getSampleBuf();
        if (this.getStatus() == 4) {
            throw new NoDataException("service is suspended");
        }
        if (!this._initialized) {
            try {
                this.initialize();
            }
            catch (InitializeException e) {
                this.setStatusError();
                throw new NoDataException("initialize() failed: " + e.getMessage());
            }
        }
        this.setStatusSampling();
        this.managePowerWake();
        this.incSampleCount();
        try {
            this.prepareToSample();
        }
        catch (Exception e) {
            this.setStatusError();
            throw new NoDataException(e.getMessage());
        }
        int offset = 0;
        byte[] tempBuf = new byte[128];
        boolean thisSampleOK = false;
        Arrays.fill(sampleBuffer, (byte)0);
        int sensorRef = 0;
        while (sensorRef < this._numSensors) {
            int tries = 0;
            while (tries < maxTries) {
                try {
                    DebugMessage.println("Base: calling requestSample(" + sensorRef + ")");
                    Arrays.fill(tempBuf, (byte)0);
                    this.requestSample(sensorRef);
                    int nBytes = this.readSample(tempBuf);
                    this.validateSample(tempBuf, nBytes);
                    tempBuf[nBytes] = 13;
                    tempBuf[nBytes + 1] = 10;
                    System.arraycopy(tempBuf, 0, sampleBuffer, offset, nBytes + 2);
                    offset += nBytes + 2;
                    thisSampleOK = true;
                    break;
                }
                catch (TimeoutException e) {
                    System.err.println(new String(this.getName()) + ".acquireSample(): TimeoutException" + e);
                    this.incTimeoutCount();
                }
                catch (IOException e) {
                    System.err.println(new String(this.getName()) + ".acquireSample(): IOException" + e);
                    e.printStackTrace();
                }
                catch (InvalidDataException e) {
                    System.err.println(new String(this.getName()) + ".acquireSample(): InvalidDataException" + e);
                    this.incInvalidDataCount();
                }
                catch (Exception e) {
                    System.err.println(new String(this.getName()) + ".acquireSample(): Exception" + e);
                    e.printStackTrace();
                }
                Thread.yield();
                ++tries;
            }
            if (tries == maxTries) {
                this.incRetryExceededCount();
            }
            ++sensorRef;
        }
        if (thisSampleOK) {
            try {
                SensorDataPacket dataPacket = this.processSample(sampleBuffer, offset);
                if (logSample) {
                    this._packetLog.appendPacket(dataPacket);
                }
                this.postSample();
                this.managePowerSleep();
                this.setStatusOk();
                return dataPacket;
            }
            catch (Exception e) {
                System.err.println("acquireSample(): postAmble" + e);
            }
        }
        this.setStatusError();
        throw new NoDataException();
    }

    protected void resetCommStats() {
        this._totalSampleCount = 0;
        this._sampleCount = 0;
        this._totalRetryExceededCount = 0;
        this._retryExceededCount = 0;
        this._totalInvalidDataCount = 0;
        this._invalidDataCount = 0;
        this._totalTimeoutCount = 0;
        this._timeoutCount = 0;
        this._totalBadResponseCount = 0;
        this._badResponseCount = 0;
    }

    protected void incSampleCount() {
        ++this._sampleCount;
    }

    protected void incRetryExceededCount() {
        ++this._retryExceededCount;
    }

    protected void incInvalidDataCount() {
        ++this._invalidDataCount;
    }

    protected void incTimeoutCount() {
        ++this._timeoutCount;
    }

    protected void incBadResponseCount() {
        ++this._badResponseCount;
    }

    public int test() {
        this._totalSampleCount += this._sampleCount;
        this._totalInvalidDataCount += this._invalidDataCount;
        this._totalTimeoutCount += this._timeoutCount;
        this._totalBadResponseCount += this._badResponseCount;
        this._totalRetryExceededCount += this._retryExceededCount;
        System.out.println("[ Samples:\t\t" + this._totalSampleCount + " : " + this._sampleCount + " ]");
        System.out.println("[ Invalid data:\t\t" + this._totalInvalidDataCount + " : " + this._invalidDataCount + " ]");
        System.out.println("[ Timeouts:\t\t" + this._totalTimeoutCount + " : " + this._timeoutCount + " ]");
        System.out.println("[ Bad responses:\t" + this._totalBadResponseCount + " : " + this._badResponseCount + " ]");
        System.out.println("[ Retries exceeded:\t" + this._totalRetryExceededCount + " : " + this._retryExceededCount + " ]");
        this._sampleCount = 0;
        this._invalidDataCount = 0;
        this._timeoutCount = 0;
        this._badResponseCount = 0;
        this._retryExceededCount = 0;
        return 0;
    }
}

