/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.rendezvous;

import com.strangeberry.rendezvous.DNSCache;
import com.strangeberry.rendezvous.DNSConstants;
import com.strangeberry.rendezvous.DNSIncoming;
import com.strangeberry.rendezvous.DNSOutgoing;
import com.strangeberry.rendezvous.DNSQuestion;
import com.strangeberry.rendezvous.DNSRecord;
import com.strangeberry.rendezvous.ServiceInfo;
import com.strangeberry.rendezvous.ServiceListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class Rendezvous
extends DNSConstants {
    public static String VERSION = "0.1.1";
    static int debug = Integer.parseInt(System.getProperty("rendezvous.debug", "0"));
    InetAddress group;
    MulticastSocket socket;
    Vector listeners;
    Vector browsers;
    DNSCache cache;
    Hashtable services;
    Thread shutdown;
    boolean done;
    boolean linklocal;
    boolean loopback;

    public Rendezvous() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        this.init(Rendezvous.isLoopback(addr) ? null : addr);
    }

    public Rendezvous(InetAddress addr) throws IOException {
        this.init(addr);
    }

    void init(InetAddress intf) throws IOException {
        this.group = InetAddress.getByName("224.0.0.251");
        this.socket = new MulticastSocket(5353);
        if (intf != null) {
            this.socket.setInterface(intf);
        }
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
        this.loopback = Rendezvous.isLoopback(intf);
        this.linklocal = Rendezvous.isLinkLocal(intf);
        this.cache = new DNSCache(100);
        this.listeners = new Vector();
        this.browsers = new Vector();
        this.services = new Hashtable(20);
        new Thread((Runnable)new SocketListener(), "Rendezvous.SocketListener").start();
        new Thread((Runnable)new RecordReaper(), "Rendezvous.RecordReaper").start();
        this.shutdown = new Thread((Runnable)new Shutdown(), "Rendezvous.Shutdown");
        Runtime.getRuntime().addShutdownHook(this.shutdown);
    }

    static boolean isLoopback(InetAddress addr) {
        return addr != null && addr.getHostAddress().startsWith("127.0.0.1");
    }

    static boolean isLinkLocal(InetAddress addr) {
        return addr != null && addr.getHostAddress().startsWith("169.254.");
    }

    public InetAddress getInterface() throws IOException {
        return this.socket.getInterface();
    }

    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, 3000);
    }

    public ServiceInfo getServiceInfo(String type, String name, int timeout) {
        ServiceInfo info = new ServiceInfo(type, name);
        return info.request(this, timeout) ? info : null;
    }

    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, 3000);
    }

    public void requestServiceInfo(String type, String name, int timeout) {
        new Thread((Runnable)new ServiceResolver(new ServiceInfo(type, name), timeout), "Rendezvous.ServiceResolver").start();
    }

    public synchronized void addServiceListener(String type, ServiceListener listener) {
        this.removeServiceListener(listener);
        this.browsers.addElement(new ServiceBrowser(type, listener));
    }

    public synchronized void removeServiceListener(ServiceListener listener) {
        int i = this.browsers.size();
        while (i-- > 0) {
            ServiceBrowser browser = (ServiceBrowser)this.browsers.elementAt(i);
            if (browser.listener != listener) continue;
            this.browsers.removeElementAt(i);
            browser.close();
            return;
        }
    }

    public void registerService(ServiceInfo info) throws IOException {
        try {
            long now;
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                this.checkService(info);
                this.services.put(info.name.toLowerCase(), info);
            }
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                System.out.println("registerService() - announce service");
                DNSOutgoing out = new DNSOutgoing(33792);
                out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 60, info.name), 0L);
                out.addAnswer(new DNSRecord.Service(info.name, 33, 1, 60, info.priority, info.weight, info.port, info.name), 0L);
                out.addAnswer(new DNSRecord.Text(info.name, 16, 1, 60, info.text), 0L);
                out.addAnswer(new DNSRecord.Address(info.name, 1, 1, 60, info.getIPAddress()), 0L);
                this.send(out);
                ++i;
                nextTime += 225L;
            }
        }
        catch (InterruptedException e) {
            throw new IOException("interrupted I/O");
        }
        System.out.println("Leaving registerService()");
    }

    public void unregisterService(ServiceInfo info) {
        try {
            long now;
            this.services.remove(info.name.toLowerCase());
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing out = new DNSOutgoing(33792);
                out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 0, info.name), 0L);
                out.addAnswer(new DNSRecord.Service(info.name, 33, 1, 0, info.priority, info.weight, info.port, info.name), 0L);
                out.addAnswer(new DNSRecord.Text(info.name, 16, 1, 0, info.text), 0L);
                out.addAnswer(new DNSRecord.Address(info.name, 1, 1, 0, info.getIPAddress()), 0L);
                this.send(out);
                ++i;
                nextTime += 125L;
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void unregisterAllServices() {
        if (this.services.size() == 0) {
            return;
        }
        try {
            long now;
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing out = new DNSOutgoing(33792);
                Enumeration e = this.services.elements();
                while (e.hasMoreElements()) {
                    ServiceInfo info = (ServiceInfo)e.nextElement();
                    out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 0, info.name), 0L);
                    out.addAnswer(new DNSRecord.Service(info.name, 33, 1, 0, info.priority, info.weight, info.port, info.name), 0L);
                    out.addAnswer(new DNSRecord.Text(info.name, 16, 1, 0, info.text), 0L);
                    out.addAnswer(new DNSRecord.Address(info.name, 1, 1, 0, info.getIPAddress()), 0L);
                }
                this.send(out);
                ++i;
                nextTime += 125L;
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void checkService(ServiceInfo info) throws IOException, InterruptedException {
        long now;
        long nextTime = now = System.currentTimeMillis();
        int i = 0;
        while (i < 3) {
            Iterator j = this.cache.find(info.type);
            while (j.hasNext()) {
                DNSRecord a = (DNSRecord)j.next();
                if (a.type != 12 || a.isExpired(now) || !info.name.equals(((DNSRecord.Pointer)a).alias)) continue;
                String name = info.getName();
                try {
                    int l = name.lastIndexOf(91);
                    int r = name.lastIndexOf(93);
                    name = l >= 0 && l < r ? name.substring(0, l) + "[" + (Integer.parseInt(name.substring(l + 1, r)) + 1) + "]" : name + " [1]";
                }
                catch (NumberFormatException e) {
                    name = name + " [1]";
                }
                info.name = name + "." + info.type;
                this.checkService(info);
                return;
            }
            if (now < nextTime) {
                this.wait(nextTime - now);
                now = System.currentTimeMillis();
                continue;
            }
            DNSOutgoing out = new DNSOutgoing(1024);
            out.addQuestion(new DNSQuestion(info.type, 12, 1));
            out.addAuthorativeAnswer(new DNSRecord.Pointer(info.type, 12, 1, 60, info.name));
            this.send(out);
            ++i;
            nextTime += 175L;
        }
    }

    synchronized void addListener(Listener listener, DNSQuestion question) {
        long now = System.currentTimeMillis();
        this.listeners.addElement(listener);
        if (question != null) {
            Iterator i = this.cache.find(question.name);
            while (i.hasNext()) {
                DNSRecord c = (DNSRecord)i.next();
                if (!question.answeredBy(c) || c.isExpired(now)) continue;
                listener.updateRecord(this, now, c);
            }
        }
        this.notifyAll();
    }

    synchronized void removeListener(Listener listener) {
        this.listeners.removeElement(listener);
        this.notifyAll();
    }

    synchronized void updateRecord(long now, DNSRecord rec) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            Listener listener = (Listener)e.nextElement();
            listener.updateRecord(this, now, rec);
        }
        this.notifyAll();
    }

    synchronized void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        Enumeration e = msg.answers.elements();
        while (e.hasMoreElements()) {
            DNSRecord rec = (DNSRecord)e.nextElement();
            boolean expired = rec.isExpired(now);
            DNSRecord c = (DNSRecord)this.cache.get(rec);
            if (c != null) {
                if (expired) {
                    this.cache.remove(c);
                } else {
                    c.resetTTL(rec);
                    rec = c;
                }
            } else if (!expired) {
                this.cache.add(rec);
            }
            this.updateRecord(now, rec);
        }
    }

    synchronized void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        Enumeration e;
        DNSOutgoing out = null;
        if (port != 5353) {
            out = new DNSOutgoing(33792, false);
            e = in.questions.elements();
            while (e.hasMoreElements()) {
                out.addQuestion((DNSQuestion)e.nextElement());
            }
        }
        e = in.questions.elements();
        block4: while (e.hasMoreElements()) {
            DNSQuestion q = (DNSQuestion)e.nextElement();
            switch (q.type) {
                case 12: {
                    ServiceInfo info;
                    Enumeration s = this.services.elements();
                    while (s.hasMoreElements()) {
                        info = (ServiceInfo)s.nextElement();
                        if (!q.name.equals(info.type)) continue;
                        if (out == null) {
                            out = new DNSOutgoing(33792);
                        }
                        out.addAnswer(in, new DNSRecord.Pointer(info.type, 12, 1, 60, info.name));
                    }
                    continue block4;
                }
                default: {
                    ServiceInfo info = (ServiceInfo)this.services.get(q.name.toLowerCase());
                    if (info == null) continue block4;
                    if (out == null) {
                        out = new DNSOutgoing(33792);
                    }
                    if (q.type == 33 || q.type == 255) {
                        out.addAnswer(in, new DNSRecord.Service(q.name, 33, 32769, 60, info.priority, info.weight, info.port, info.name));
                    }
                    if (q.type == 16 || q.type == 255) {
                        out.addAnswer(in, new DNSRecord.Text(q.name, 16, 32769, 60, info.text));
                    }
                    if (q.type != 1 && q.type != 255) continue block4;
                    out.addAnswer(in, new DNSRecord.Address(q.name, 1, 32769, 60, info.getIPAddress()));
                }
            }
        }
        if (out != null && out.numAnswers > 0) {
            out.id = in.id;
            out.finish();
            this.socket.send(new DatagramPacket(out.data, out.off, addr, port));
        }
    }

    synchronized void send(DNSOutgoing out) throws IOException {
        out.finish();
        this.socket.send(new DatagramPacket(out.data, out.off, this.group, 5353));
    }

    public synchronized void close() {
        System.out.println("*** Rendezvous.close()");
        if (!this.done) {
            this.done = true;
            this.notifyAll();
            if (this.shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdown);
            }
            this.unregisterAllServices();
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void print() {
        if (this.cache.count > 0) {
            System.out.println("---- cache ----");
            this.cache.print();
            System.out.println();
        }
    }

    class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            Rendezvous.this.shutdown = null;
            Rendezvous.this.close();
        }
    }

    class ServiceResolver
    implements Runnable {
        ServiceInfo info;
        int timeout;

        ServiceResolver(ServiceInfo info, int timeout) {
            this.info = info;
            this.timeout = timeout;
        }

        public void run() {
            ServiceInfo result = this.info;
            if (!this.info.request(Rendezvous.this, this.timeout)) {
                result = null;
            }
            Enumeration e = Rendezvous.this.browsers.elements();
            while (e.hasMoreElements()) {
                ServiceBrowser browser = (ServiceBrowser)e.nextElement();
                if (!browser.type.equalsIgnoreCase(this.info.type)) continue;
                browser.listener.resolveService(Rendezvous.this, this.info.type, this.info.name, result);
            }
        }
    }

    class ServiceBrowser
    extends Listener
    implements Runnable {
        String type;
        ServiceListener listener;
        Hashtable services;
        long nextTime;
        int delay;
        boolean done;
        LinkedList list;

        ServiceBrowser(String type, ServiceListener listener) {
            this.type = type;
            this.listener = listener;
            this.services = new Hashtable();
            this.nextTime = System.currentTimeMillis();
            this.delay = 500;
            this.list = new LinkedList();
            Rendezvous.this.addListener(this, new DNSQuestion(type, 12, 1));
            new Thread((Runnable)this, "Rendezvous.ServiceBrowser: " + type).start();
        }

        void updateRecord(Rendezvous rendezvous, long now, DNSRecord rec) {
            if (rec.type == 12 && rec.name.equals(this.type)) {
                boolean expired = rec.isExpired(now);
                String name = ((DNSRecord.Pointer)rec).alias;
                DNSRecord old = (DNSRecord)this.services.get(name.toLowerCase());
                if (old == null && !expired) {
                    this.services.put(name.toLowerCase(), rec);
                    this.list.addLast(new Event(this, name){
                        private final /* synthetic */ ServiceBrowser this$1;
                        {
                            this.this$1 = this$1;
                        }

                        void send() {
                            this.this$1.listener.addService(ServiceBrowser.access$000(this.this$1), this.this$1.type, this.name);
                        }
                    });
                } else if (old != null && !expired) {
                    old.resetTTL(rec);
                } else if (old != null && expired) {
                    this.services.remove(name.toLowerCase());
                    this.list.addLast(new Event(this, name){
                        private final /* synthetic */ ServiceBrowser this$1;
                        {
                            this.this$1 = this$1;
                        }

                        void send() {
                            this.this$1.listener.removeService(ServiceBrowser.access$000(this.this$1), this.this$1.type, this.name);
                        }
                    });
                    return;
                }
                long expires = rec.getExpirationTime(75);
                if (expires < this.nextTime) {
                    this.nextTime = rec.getExpirationTime(75);
                }
            }
        }

        public void run() {
            try {
                while (true) {
                    Event evt = null;
                    Rendezvous rendezvous = Rendezvous.this;
                    synchronized (rendezvous) {
                        long now = System.currentTimeMillis();
                        if (this.list.size() == 0 && this.nextTime > now) {
                            Rendezvous.this.wait(this.nextTime - now);
                        }
                        if (this.done) {
                            return;
                        }
                        now = System.currentTimeMillis();
                        if (this.nextTime <= now) {
                            DNSOutgoing out = new DNSOutgoing(0);
                            out.addQuestion(new DNSQuestion(this.type, 12, 1));
                            Enumeration e = this.services.elements();
                            while (e.hasMoreElements()) {
                                DNSRecord rec = (DNSRecord)e.nextElement();
                                if (rec.isExpired(now)) continue;
                                out.addAnswer(rec, now);
                            }
                            Rendezvous.this.send(out);
                            this.nextTime = now + (long)this.delay;
                            this.delay = Math.min(20000, this.delay * 2);
                        }
                        if (this.list.size() > 0) {
                            evt = (Event)this.list.removeFirst();
                        }
                    }
                    if (evt == null) continue;
                    evt.send();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void close() {
            Rendezvous rendezvous = Rendezvous.this;
            synchronized (rendezvous) {
                if (!this.done) {
                    this.done = true;
                    Rendezvous.this.removeListener(this);
                }
            }
        }

        static /* synthetic */ Rendezvous access$000(ServiceBrowser x0) {
            return x0.Rendezvous.this;
        }

        abstract class Event {
            String name;

            Event(String name) {
                this.name = name;
            }

            abstract void send();
        }
    }

    class RecordReaper
    implements Runnable {
        RecordReaper() {
        }

        public void run() {
            try {
                Rendezvous rendezvous = Rendezvous.this;
                synchronized (rendezvous) {
                    block5: while (true) {
                        Rendezvous.this.wait(10000L);
                        if (Rendezvous.this.done) {
                            return;
                        }
                        long now = System.currentTimeMillis();
                        Iterator i = Rendezvous.this.cache.all();
                        while (true) {
                            if (!i.hasNext()) continue block5;
                            DNSRecord c = (DNSRecord)i.next();
                            if (!c.isExpired(now)) continue;
                            Rendezvous.this.updateRecord(now, c);
                            i.remove();
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class SocketListener
    implements Runnable {
        SocketListener() {
        }

        public void run() {
            block9: {
                try {
                    byte[] buf = new byte[8972];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    while (!Rendezvous.this.done) {
                        packet.setLength(buf.length);
                        Rendezvous.this.socket.receive(packet);
                        if (!Rendezvous.this.done) {
                            try {
                                InetAddress from = packet.getAddress();
                                if (Rendezvous.this.linklocal != Rendezvous.isLinkLocal(from) || Rendezvous.this.loopback != Rendezvous.isLoopback(from)) continue;
                                DNSIncoming msg = new DNSIncoming(packet);
                                if (debug > 0) {
                                    msg.print(debug > 1);
                                    System.out.println();
                                }
                                if (msg.isQuery()) {
                                    if (packet.getPort() != 5353) {
                                        Rendezvous.this.handleQuery(msg, packet.getAddress(), packet.getPort());
                                    }
                                    Rendezvous.this.handleQuery(msg, Rendezvous.this.group, 5353);
                                    continue;
                                }
                                Rendezvous.this.handleResponse(msg);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    if (Rendezvous.this.done) break block9;
                    e.printStackTrace();
                }
            }
        }
    }

    static abstract class Listener
    extends DNSConstants {
        Listener() {
        }

        abstract void updateRecord(Rendezvous var1, long var2, DNSRecord var4);
    }
}

