/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.rendezvous;

import com.strangeberry.rendezvous.DNSConstants;
import com.strangeberry.rendezvous.DNSIncoming;
import com.strangeberry.rendezvous.DNSQuestion;
import com.strangeberry.rendezvous.DNSRecord;
import java.io.IOException;
import java.util.Hashtable;

final class DNSOutgoing
extends DNSConstants {
    int flags;
    boolean multicast;
    int id;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;
    Hashtable names;
    byte[] data;
    int off;
    int len;

    DNSOutgoing(int flags) {
        this(flags, true);
    }

    DNSOutgoing(int flags, boolean multicast) {
        this.flags = flags;
        this.multicast = multicast;
        this.names = new Hashtable();
        this.data = new byte[1460];
        this.off = 12;
    }

    void addQuestion(DNSQuestion rec) throws IOException {
        ++this.numQuestions;
        this.writeQuestion(rec);
    }

    void addAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (!rec.suppressedBy(in)) {
            this.addAnswer(rec, 0L);
        }
    }

    void addAnswer(DNSRecord rec, long now) throws IOException {
        if (!(rec == null || now != 0L && rec.isExpired(now))) {
            ++this.numAnswers;
            this.writeRecord(rec, now);
        }
    }

    void addAuthorativeAnswer(DNSRecord rec) throws IOException {
        ++this.numAuthorities;
        this.writeRecord(rec, 0L);
    }

    void writeByte(int value) throws IOException {
        if (this.off >= this.data.length) {
            throw new IOException("buffer full");
        }
        this.data[this.off++] = (byte)value;
    }

    void writeBytes(String str, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeByte(str.charAt(off + i));
            ++i;
        }
    }

    void writeBytes(byte[] data, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.writeByte(data[off + i]);
            ++i;
        }
    }

    void writeShort(int value) throws IOException {
        this.writeByte(value >> 8);
        this.writeByte(value);
    }

    void writeInt(int value) throws IOException {
        this.writeShort(value >> 16);
        this.writeShort(value);
    }

    void writeUTF(String str, int off, int len) throws IOException {
        int utflen = 0;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(off + i);
            utflen = ch >= '\u0001' && ch <= '\u007f' ? ++utflen : (ch > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        this.writeByte(utflen);
        int i2 = 0;
        while (i2 < len) {
            char ch = str.charAt(off + i2);
            if (ch >= '\u0001' && ch <= '\u007f') {
                this.writeByte(ch);
            } else if (ch > '\u07ff') {
                this.writeByte(0xE0 | ch >> 12 & 0xF);
                this.writeByte(0x80 | ch >> 6 & 0x3F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
            } else {
                this.writeByte(0xC0 | ch >> 6 & 0x1F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
            }
            ++i2;
        }
    }

    void writeName(String name) throws IOException {
        while (true) {
            int n;
            if ((n = name.indexOf(46)) < 0) {
                n = name.length();
            }
            if (n <= 0) {
                this.writeByte(0);
                return;
            }
            Integer offset = (Integer)this.names.get(name);
            if (offset != null) {
                int val = offset;
                this.writeByte(val >> 8 | 0xC0);
                this.writeByte(val);
                return;
            }
            this.names.put(name, new Integer(this.off));
            this.writeUTF(name, 0, n);
            if (!(name = name.substring(n)).startsWith(".")) continue;
            name = name.substring(1);
        }
    }

    void writeQuestion(DNSQuestion question) throws IOException {
        this.writeName(question.name);
        this.writeShort(question.type);
        this.writeShort(question.clazz);
    }

    void writeRecord(DNSRecord rec, long now) throws IOException {
        this.writeName(rec.name);
        this.writeShort(rec.type);
        this.writeShort(rec.clazz | (rec.unique && this.multicast ? 32768 : 0));
        this.writeInt(now == 0L ? rec.ttl : rec.getRemainingTTL(now));
        this.writeShort(0);
        int start = this.off;
        rec.write(this);
        int len = this.off - start;
        this.data[start - 2] = (byte)(len >> 8);
        this.data[start - 1] = (byte)(len & 0xFF);
    }

    void finish() throws IOException {
        int save = this.off;
        this.off = 0;
        this.writeShort(this.multicast ? 0 : this.id);
        this.writeShort(this.flags);
        this.writeShort(this.numQuestions);
        this.writeShort(this.numAnswers);
        this.writeShort(this.numAuthorities);
        this.writeShort(this.numAdditionals);
        this.off = save;
    }
}

