/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class XmlDateFormat {
    Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    NumberFormat numberFormat = new DecimalFormat("0000");

    public XmlDateFormat() {
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public String format(Date date) {
        StringBuffer toAppendTo = new StringBuffer();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2) + 1;
        int day = this.calendar.get(5);
        int hour = this.calendar.get(11);
        int minute = this.calendar.get(12);
        int second = this.calendar.get(13);
        this.numberFormat.setMinimumIntegerDigits(4);
        toAppendTo.append(this.numberFormat.format(year));
        this.numberFormat.setMinimumIntegerDigits(2);
        toAppendTo.append("-" + this.numberFormat.format(month));
        toAppendTo.append("-" + this.numberFormat.format(day));
        toAppendTo.append("T" + this.numberFormat.format(hour));
        toAppendTo.append(":" + this.numberFormat.format(minute));
        toAppendTo.append(":" + this.numberFormat.format(second) + "Z");
        return toAppendTo.toString();
    }

    public String formatCompact(Date date) {
        StringBuffer toAppendTo = new StringBuffer();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2) + 1;
        int day = this.calendar.get(5);
        int hour = this.calendar.get(11);
        int minute = this.calendar.get(12);
        int second = this.calendar.get(13);
        this.numberFormat.setMinimumIntegerDigits(4);
        toAppendTo.append(this.numberFormat.format(year));
        this.numberFormat.setMinimumIntegerDigits(2);
        toAppendTo.append(this.numberFormat.format(month));
        toAppendTo.append(this.numberFormat.format(day));
        toAppendTo.append("T" + this.numberFormat.format(hour));
        toAppendTo.append(this.numberFormat.format(minute));
        toAppendTo.append(this.numberFormat.format(second));
        return toAppendTo.toString();
    }

    public Date parse(String source) {
        int index = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            year = Integer.parseInt(source.substring(index, index + 4));
            month = Integer.parseInt(source.substring(index + 5, index + 7)) - 1;
            day = Integer.parseInt(source.substring(index + 8, index + 10));
            hour = Integer.parseInt(source.substring(index + 11, index + 13));
            minute = Integer.parseInt(source.substring(index + 14, index + 16));
            second = Integer.parseInt(source.substring(index + 17, index + 19));
            String zoneFlag = source.substring(index + 19, index + 20);
            if (!zoneFlag.equals("Z")) {
                int zoneHour = Integer.parseInt(source.substring(index + 20, index + 22));
                int zoneMinute = Integer.parseInt(source.substring(index + 23, index + 25));
                if (zoneFlag.equals("+")) {
                    hour += zoneHour;
                    minute += zoneMinute;
                } else if (zoneFlag.equals("-")) {
                    hour -= zoneHour;
                    minute -= zoneMinute;
                }
            }
        }
        catch (NumberFormatException e) {
            System.err.println(this.getClass().getName() + ": Unable to parse '" + source + "'. Format should be YYYY-MM-DD HH:MM:SSZ");
        }
        this.calendar.set(year, month, day, hour, minute, second);
        return this.calendar.getTime();
    }
}

