/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import moos.ssds.model.DataProducer;
import moos.ssds.model.Deployment;
import moos.ssds.model.Device;
import moos.ssds.model.HumanIntervention;
import moos.ssds.model.ProcessRun;
import moos.ssds.model.XmlDateFormat;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;

public class XmlBuilder {
    private Document document;
    private Collection rootElements = new ArrayList();
    private Package p;
    private XmlDateFormat dateFormat = new XmlDateFormat();
    static /* synthetic */ Class class$java$lang$String;

    public XmlBuilder() {
        Element root = new Element("Metadata");
        this.document = new Document(root);
        this.p = this.getClass().getPackage();
    }

    public void build() {
        this.marshal();
    }

    public void marshal() {
        this.document.getRootElement().removeChildren();
        Iterator i = this.rootElements.iterator();
        Element element = null;
        Object obj = null;
        while (i.hasNext()) {
            obj = i.next();
            try {
                element = this.objectToElement(obj);
                if (element == null || this.isEmptyElement(element)) continue;
                this.document.getRootElement().appendChild((Node)element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Element objectToElement(Object parentObject) {
        Element parentElement = null;
        Class<?> parentClass = parentObject.getClass();
        if (this.isPackageLocal(parentClass)) {
            parentElement = this.makeEmptyElement(parentObject);
            Method[] methods = parentClass.getMethods();
            Method method = null;
            Class<?> methodClass = null;
            Object paramName = null;
            Object childObject = null;
            boolean ok = false;
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                methodClass = method.getDeclaringClass();
                if (!this.isPackageLocal(methodClass)) continue;
                if (this.isListMethod(method)) {
                    this.appendCollection(parentObject, method, parentElement);
                    continue;
                }
                if (!this.isGetMethod(method)) continue;
                this.appendElement(parentObject, method, parentElement);
            }
        }
        return parentElement;
    }

    private Element makeEmptyElement(Object object) {
        Class<?> c = object.getClass();
        String name = c.getName();
        int idx = name.lastIndexOf(".");
        name = name.substring(idx + 1);
        return new Element(name);
    }

    private boolean isListMethod(Method method) {
        boolean ok = false;
        String methodName = method.getName();
        if (methodName.startsWith("list") && (methodName.equals("listRecordVariables") || methodName.equals("listCommentTags") || methodName.equals("listChildDeployments") || methodName.equals("listResources") || methodName.equals("listOutputs") || methodName.equals("listDirectConsumers") || methodName.equals("listEvents"))) {
            ok = true;
        }
        return ok;
    }

    private boolean isGetMethod(Method method) {
        boolean ok = false;
        String methodName = method.getName();
        if (methodName.startsWith("get") || methodName.startsWith("is")) {
            ok = true;
            if (methodName.equals("getCreator") || methodName.equals("getParentDeployment") || methodName.equals("getResourceOwner") || methodName.equals("getOjbConcreteClass") || methodName.equals("getDateRange") || methodName.equals("getDataFile") || methodName.equals("isWebAccessible")) {
                ok = false;
            }
        }
        return ok;
    }

    private String getParameterName(Method method) {
        String methodName = method.getName();
        String parameterName = null;
        if (methodName.startsWith("list")) {
            parameterName = methodName.substring(4);
        } else if (methodName.startsWith("get")) {
            parameterName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            parameterName = methodName.substring(2);
        }
        return parameterName;
    }

    private Object getChildObject(Object parentObject, Method method) {
        Object childObject = null;
        try {
            childObject = method.invoke(parentObject, new Object[0]);
        }
        catch (IllegalAccessException e) {
            System.err.println(this.getClass().getName() + ": Illegal access, " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            System.err.println(this.getClass().getName() + ": Invocation target, " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println(this.getClass().getName() + ": Attempted to call \"" + method + "\", an access method that requires an argument, SKIPPING");
        }
        return childObject;
    }

    private void appendCollection(Object parentObject, Method method, Element parentElement) {
        Object childObject = this.getChildObject(parentObject, method);
        Collection c = (Collection)childObject;
        String methodName = method.getName();
        if (methodName.equals("listInputs") || methodName.equals("listOutputs")) {
            if (!c.isEmpty()) {
                StringBuffer sb = new StringBuffer(this.getParameterName(method));
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                String paramName = sb.substring(0, sb.length() - 1);
                Element ioElement = new Element(paramName);
                parentElement.appendChild((Node)ioElement);
                parentElement = ioElement;
            }
        } else if (methodName.equals("listDirectConsumers")) {
            if (!c.isEmpty()) {
                Element ioElement = new Element("consumer");
                parentElement.appendChild((Node)ioElement);
                parentElement = ioElement;
            }
        } else if (methodName.equals("listCommentTags")) {
            this.appendCommentTags(parentObject, method, parentElement);
            return;
        }
        Element childElement = null;
        if (c != null && !c.isEmpty()) {
            Iterator it = c.iterator();
            Object lo = null;
            while (it.hasNext()) {
                lo = it.next();
                if (lo == null || this.isEmptyElement(childElement = this.objectToElement(lo))) continue;
                parentElement.appendChild((Node)childElement);
            }
        }
    }

    private void appendCommentTags(Object parentObject, Method method, Element parentElement) {
        Object childObject = this.getChildObject(parentObject, method);
        Collection c = (Collection)childObject;
        Element childElement = null;
        if (c != null) {
            Iterator it = c.iterator();
            Object lo = null;
            while (it.hasNext()) {
                lo = it.next();
                if (lo == null) continue;
                childElement = new Element("commentTag");
                childElement.appendChild((String)lo);
                parentElement.appendChild((Node)childElement);
            }
        }
    }

    private void appendElement(Object parentObject, Method method, Element parentElement) {
        Class<?> methodReturnType = method.getReturnType();
        if (methodReturnType.isPrimitive() || methodReturnType.equals(class$java$lang$String == null ? (class$java$lang$String = XmlBuilder.class$("java.lang.String")) : class$java$lang$String)) {
            this.appendPrimitiveType(parentObject, method, parentElement);
        } else if (this.isSpecialMethod(method)) {
            this.appendSpecial(parentObject, method, parentElement);
        } else {
            this.appendObject(parentObject, method, parentElement);
        }
    }

    private boolean isSpecialMethod(Method method) {
        boolean ok = false;
        String methodName = method.getName();
        if (methodName.equals("getStartDate") || methodName.equals("getEndDate") || methodName.equals("getUrl") || methodName.endsWith("Id") || methodName.equalsIgnoreCase("id")) {
            ok = true;
        }
        return ok;
    }

    private void appendSpecial(Object parentObject, Method method, Element parentElement) {
        String methodName = method.getName();
        Object childObject = this.getChildObject(parentObject, method);
        if (childObject != null) {
            StringBuffer sb = new StringBuffer(this.getParameterName(method));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String paramName = sb.toString();
            String paramValue = null;
            Attribute attribute = null;
            if (methodName.equals("getStartDate") || methodName.equals("getEndDate")) {
                paramValue = this.dateFormat.format((Date)childObject);
            } else if (methodName.equals("getUrl")) {
                paramValue = ((URL)childObject).toString();
            } else if (methodName.endsWith("Id") || methodName.equalsIgnoreCase("id")) {
                paramValue = ((Long)childObject).toString();
            }
            attribute = new Attribute(paramName, paramValue);
            parentElement.addAttribute(attribute);
        }
    }

    private void appendPrimitiveType(Object parentObject, Method method, Element parentElement) {
        Object childObject = this.getChildObject(parentObject, method);
        if (childObject != null) {
            StringBuffer sb = new StringBuffer(this.getParameterName(method));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String paramName = sb.toString();
            String paramValue = String.valueOf(childObject);
            if (!paramValue.equals("") && !paramValue.equals("NaN")) {
                if (paramName.equals("description")) {
                    Element childElement = new Element("description");
                    childElement.appendChild(paramValue);
                    parentElement.appendChild((Node)childElement);
                } else {
                    Attribute childAttribute = new Attribute(paramName, paramValue);
                    parentElement.addAttribute(childAttribute);
                }
            }
        }
    }

    private void appendObject(Object parentObject, Method method, Element parentElement) {
        Element childElement;
        Object childObject = this.getChildObject(parentObject, method);
        if (childObject != null && (childElement = this.objectToElement(childObject)) != null && !this.isEmptyElement(childElement)) {
            parentElement.appendChild((Node)childElement);
        }
    }

    private boolean isEmptyElement(Element element) {
        boolean ok = true;
        if (element.hasChildren() || element.getAttributeCount() > 0) {
            ok = false;
        }
        return ok;
    }

    public String toXML() {
        return this.document.toXML();
    }

    public String toString() {
        return this.document.toString();
    }

    public Document getDocument() {
        return this.document;
    }

    private boolean isPackageLocal(Class c) {
        return c.getPackage().equals(this.p);
    }

    public void toFile(File file) throws IOException, UnsupportedEncodingException {
        this.toFile(file, "ISO-8859-1");
    }

    public void toFile(File file, String encoding) throws IOException, UnsupportedEncodingException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        this.print(out, encoding);
        ((OutputStream)out).close();
    }

    public void print(OutputStream out, String encoding) throws IOException, UnsupportedEncodingException {
        Serializer serializer = new Serializer(out, encoding);
        serializer.setIndent(4);
        serializer.setMaxLength(65536);
        serializer.write(this.document);
    }

    public void print(OutputStream out) throws IOException, UnsupportedEncodingException {
        this.print(out, "ISO-8859-1");
    }

    public void print() throws IOException, UnsupportedEncodingException {
        this.print(System.out);
    }

    public void addDevice(Device device) {
        this.rootElements.add(device);
    }

    public void addDeployment(Deployment deployment) {
        this.rootElements.add(deployment);
    }

    public void addDataProducer(DataProducer dataProducer) {
        this.rootElements.add(dataProducer);
    }

    public void addHumanIntervention(HumanIntervention humanIntervention) {
        this.rootElements.add(humanIntervention);
    }

    public void addProcessRun(ProcessRun processRun) {
        this.rootElements.add(processRun);
    }

    public void removeDevice(Device device) {
        this.rootElements.remove(device);
    }

    public void removeDeployment(Deployment deployment) {
        this.rootElements.remove(deployment);
    }

    public void removeDataProducer(DataProducer dataProducer) {
        this.rootElements.remove(dataProducer);
    }

    public void removeHumanIntervention(HumanIntervention humanIntervention) {
        this.rootElements.remove(humanIntervention);
    }

    public void removeProcessRun(ProcessRun processRun) {
        this.rootElements.remove(processRun);
    }

    public void add(Object obj) {
        this.rootElements.add(obj);
    }

    public void remove(Object obj) {
        this.rootElements.remove(obj);
    }

    public void addAll(Collection c) {
        this.rootElements.addAll(c);
    }

    public void removeAll(Collection c) {
        this.rootElements.removeAll(c);
    }

    public Collection getRootElements() {
        return this.rootElements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

