/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import moos.ssds.model.DateRange;
import moos.ssds.model.IDateRange;
import moos.ssds.model.IDescription;
import moos.ssds.model.IUrlAccess;
import moos.ssds.model.Person;
import moos.ssds.model.ResourceOwner;

public class Resource
implements Serializable,
IDateRange,
IDescription,
IUrlAccess {
    private ResourceOwner resourceOwner;
    private URL url;
    private DateRange dateRange = new DateRange(this);
    private String description;
    private Date startDate;
    private Date endDate;
    private String name;
    private Long id;
    private String resourceType;
    public static final String UNDEFINED = "undefined";
    public static final String DOCUMENT_CALIBRATION_FILE = "calibration file";
    public static final String DOCUMENT_SSDS_XML_METADATA = "ssds xml metadata";
    public static final String DOCUMENT_DOCUMENTATION = "documentation";
    public static final String SOFTWARE_SOURCECODE = "software sourcecode";
    public static final String SOFTWARE_EXECUTABLE = "software executable";
    public static final String SOFTWARE_SCRIPT = "software script";
    private Long personId;
    private Collection devices;
    private Collection dataContainers;
    private Collection dataProducers;
    private Person person;
    private Collection softwares;

    public Resource() {
        this.setResourceType(UNDEFINED);
    }

    public Resource(URL url) {
        this();
        this.url = url;
    }

    public Resource(Resource rs) {
        this(rs.getUrl());
        this.setDescription(rs.getDescription());
        this.setEndDate(new Date(rs.getEndDate().getTime()));
        this.setName(rs.getName());
        this.setPerson(rs.getPerson());
        this.setResourceOwner(rs.getResourceOwner());
        this.setResourceType(rs.getResourceType());
        this.setStartDate(rs.getStartDate());
    }

    public ResourceOwner getResourceOwner() {
        return this.resourceOwner;
    }

    public void setResourceOwner(ResourceOwner owner) {
        this.resourceOwner = owner;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUrl(String url) {
        try {
            this.setUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDateTime) {
        this.startDate = startDateTime;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDateTime) {
        this.endDate = endDateTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWebAccessible() {
        boolean webAccessible = false;
        String protocol = this.url.getProtocol();
        if (protocol.equals("http") || protocol.equals("ftp")) {
            webAccessible = true;
        }
        return webAccessible;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    Long getPersonId() {
        return this.personId;
    }

    void setPersonId(Long personId) {
        this.personId = personId;
    }

    Collection getDevices() {
        return this.devices;
    }

    void setDevices(Collection devices) {
        this.devices = devices;
    }

    Collection getDataContainers() {
        return this.dataContainers;
    }

    void setDataContainers(Collection dataContainers) {
        this.dataContainers = dataContainers;
    }

    Collection getDataProducers() {
        return this.dataProducers;
    }

    void setDataProducers(Collection dataProducers) {
        this.dataProducers = dataProducers;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
        if (person != null) {
            this.personId = person.getId();
        }
    }

    public String toString() {
        return this.name;
    }

    public Collection getSoftwares() {
        return this.softwares;
    }

    public void setSoftwares(Collection property) {
        this.softwares = property;
    }
}

