/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import moos.ssds.model.Deployment;
import moos.ssds.model.XmlDateFormat;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParseException;
import nu.xom.ValidityException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ObjectBuilder {
    Builder parser;
    private static String modelPackage;
    private Map objects = new HashMap();
    private URL url;
    private XmlDateFormat dateFormat = new XmlDateFormat();
    static Logger logger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$moos$ssds$model$DataContainer;
    static /* synthetic */ Class class$moos$ssds$model$DataProducer;
    static /* synthetic */ Class class$moos$ssds$model$ObjectBuilder;

    public ObjectBuilder(URL url) {
        BasicConfigurator.configure();
        logger.setLevel(Level.OFF);
        modelPackage = this.getClass().getPackage().getName();
        this.url = url;
    }

    public void unmarshal() {
        try {
            this.parser = new Builder(false);
            this.xmlToObjects(this.url.toExternalForm());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void xmlToObjects(String xml) throws Exception {
        Document doc = null;
        try {
            doc = this.parser.build(xml);
        }
        catch (ValidityException e) {
            System.err.println(this.getClass().getName() + ": " + xml + " is not a valid XML document.");
        }
        catch (ParseException e) {
            System.err.println(this.getClass().getName() + ": Unable to parse" + xml + ".");
        }
        catch (IOException e) {
            System.err.println(this.getClass().getName() + ": Unable to open" + xml + ". Exception cause is" + e.getMessage());
        }
        Element root = doc.getRootElement();
        Elements children = root.getChildElements();
        int size = children.size();
        Object obj = null;
        Class<?> c = null;
        boolean hasClass = false;
        Collection<Object> list = null;
        for (int i = 0; i < size; ++i) {
            obj = this.elementToObject(children.get(i));
            c = obj.getClass();
            hasClass = this.objects.keySet().contains(c);
            if (!hasClass) {
                list = new ArrayList();
                this.objects.put(c, list);
            }
            list = (Collection)this.objects.get(c);
            list.add(obj);
        }
    }

    private Object elementToObject(Element element) throws Exception, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String name = element.getLocalName();
        Class<?> c = null;
        Object obj = null;
        boolean isObject = Character.isUpperCase(name.charAt(0));
        if (isObject) {
            c = Class.forName(modelPackage + "." + name);
            obj = c.newInstance();
            this.buildObject(obj, element);
        }
        return obj;
    }

    private void buildObject(Object parentObject, Element parentElement) throws Exception {
        this.buildFromElements(parentObject, parentElement);
        this.buildFromAttributes(parentObject, parentElement);
    }

    private void buildFromElements(Object parentObject, Element parentElement) throws Exception {
        String name = null;
        Element childElement = null;
        Object childObject = null;
        boolean isObject = false;
        boolean isProperty = false;
        Object field = null;
        Class<?> c = parentObject.getClass();
        Elements childElements = parentElement.getChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            isProperty = false;
            childObject = null;
            childElement = childElements.get(i);
            name = childElement.getLocalName();
            isObject = Character.isUpperCase(name.charAt(0));
            if (isObject) {
                childObject = this.elementToObject(childElement);
                if (name.equalsIgnoreCase("Resource")) {
                    this.add(parentObject, "addResource", childElement);
                } else if (name.equalsIgnoreCase("Deployment")) {
                    this.add(parentObject, "addChildDeployment", childElement);
                } else if (name.equalsIgnoreCase("RecordVariable")) {
                    this.add(parentObject, "addRecordVariable", childElement);
                } else if (name.equalsIgnoreCase("RecordDescription")) {
                    this.add(parentObject, "addRecordDescription", childElement);
                } else if (name.equalsIgnoreCase("Event")) {
                    this.add(parentObject, "addEvent", childElement);
                } else if (name.equalsIgnoreCase("Person")) {
                    this.add(parentObject, "setContact", childElement);
                } else {
                    isProperty = true;
                }
            } else if (name.equalsIgnoreCase("input")) {
                this.addInput(parentObject, childElement);
            } else if (name.equalsIgnoreCase("output")) {
                this.addOutput(parentObject, childElement);
            } else if (name.equalsIgnoreCase("consumer")) {
                this.addConsumer(parentObject, childElement);
            } else if (name.equalsIgnoreCase("commentTag")) {
                this.add(parentObject, "addCommentTag", childElement.getValue());
            } else if (name.equalsIgnoreCase("endDate")) {
                childObject = this.dateFormat.parse(childElement.getValue());
                isProperty = true;
            } else if (name.equalsIgnoreCase("startDate")) {
                childObject = this.dateFormat.parse(childElement.getValue());
                isProperty = true;
            } else {
                childObject = childElement.getValue();
                isProperty = true;
            }
            if (!isProperty || childObject == null) continue;
            String methodName = this.toSetMethodName(childElement);
            this.invokeSetMethod(parentObject, methodName, childObject);
        }
    }

    private void buildFromAttributes(Object obj, Element element) throws Exception {
        Attribute attribute = null;
        int numAttributes = element.getAttributeCount();
        for (int i = 0; i < numAttributes; ++i) {
            attribute = element.getAttribute(i);
            if (this.isSpecialAttribute(attribute)) {
                this.processSpecialAttribute(obj, attribute);
                continue;
            }
            this.processAttribute(obj, attribute);
        }
    }

    private void invokeSetMethod(Object parentObj, String methodName, Object childObj) {
        Class[] parameterTypes = new Class[]{childObj.getClass()};
        Object[] arguments = new Object[]{childObj};
        try {
            Method method = parentObj.getClass().getMethod(methodName.toString(), parameterTypes);
            method.invoke(parentObj, arguments);
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    private void processAttribute(Object parentObj, Attribute attribute) {
        String methodName = this.toSetMethodName(attribute);
        Method[] methods = parentObj.getClass().getMethods();
        Method method = null;
        Object tmpName = null;
        Object value = null;
        Class<?>[] parameterTypes = null;
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!methodName.equals(method.getName())) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes[0].equals(Byte.TYPE)) {
                value = Byte.valueOf(attribute.getValue());
            } else if (parameterTypes[0].equals(Integer.TYPE)) {
                value = Integer.valueOf(attribute.getValue());
            } else if (parameterTypes[0].equals(Long.TYPE)) {
                value = Long.valueOf(attribute.getValue());
            } else if (parameterTypes[0].equals(Float.TYPE)) {
                value = Float.valueOf(attribute.getValue());
            } else if (parameterTypes[0].equals(Double.TYPE)) {
                value = Double.valueOf(attribute.getValue());
            } else if (parameterTypes[0].equals(Character.TYPE)) {
                value = new Character(attribute.getValue().charAt(0));
            } else if (parameterTypes[0].equals(Boolean.TYPE)) {
                value = Boolean.valueOf(attribute.getValue());
            } else if (parameterTypes[0].equals(class$java$lang$String == null ? (class$java$lang$String = ObjectBuilder.class$("java.lang.String")) : class$java$lang$String)) {
                value = attribute.getValue();
            }
            if (value == null) break;
            try {
                method.invoke(parentObj, value);
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private String toSetMethodName(Attribute attribute) {
        return this.toSetMethodName(attribute.getLocalName());
    }

    private String toSetMethodName(Element element) {
        return this.toSetMethodName(element.getLocalName());
    }

    private String toSetMethodName(String paramName) {
        StringBuffer methodName = new StringBuffer();
        String firstLetter = paramName.substring(0, 1);
        methodName.append("set" + firstLetter.toUpperCase() + paramName.substring(1, paramName.length()));
        return methodName.toString();
    }

    private void processSpecialAttribute(Object parentObj, Attribute attribute) {
        Serializable childObject = null;
        String attributeName = attribute.getLocalName();
        if (attributeName.equalsIgnoreCase("endDate")) {
            childObject = this.dateFormat.parse(attribute.getValue());
        } else if (attributeName.equalsIgnoreCase("startDate")) {
            childObject = this.dateFormat.parse(attribute.getValue());
        } else if (attributeName.equalsIgnoreCase("url")) {
            try {
                childObject = new URL(attribute.getValue());
            }
            catch (MalformedURLException e) {
                System.err.println(this.getClass().getName() + ": Unable to convert " + attribute.getValue() + " to a URL.");
                return;
            }
        } else if (attributeName.endsWith("Id") || attributeName.equalsIgnoreCase("id")) {
            childObject = new Long(attribute.getValue());
        }
        this.invokeSetMethod(parentObj, this.toSetMethodName(attribute), childObject);
    }

    private boolean isSpecialAttribute(Attribute attribute) {
        boolean isSpecial = false;
        String attributeName = attribute.getLocalName();
        if (attributeName.equalsIgnoreCase("endDate") || attributeName.equalsIgnoreCase("startDate") || attributeName.equalsIgnoreCase("url") || attributeName.endsWith("Id") || attributeName.equalsIgnoreCase("id")) {
            isSpecial = true;
        }
        return isSpecial;
    }

    private void add(Object parentObject, String methodName, Element element) {
        try {
            Object childObject = this.elementToObject(element);
            this.add(parentObject, methodName, childObject);
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + ": Unable to add the contents of " + element + " to " + parentObject + " using " + methodName);
        }
    }

    private void add(Object parentObject, String methodName, Object childObject) {
        try {
            this.add(parentObject, methodName, childObject, childObject.getClass());
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + ": Unable to add " + childObject + " to " + parentObject + " using " + methodName + ". The reason is " + e.getMessage());
        }
    }

    private void add(Object parentObject, String methodName, Object childObject, Class childClass) {
        try {
            Class[] c = new Class[]{childClass};
            Method m = parentObject.getClass().getMethod(methodName, c);
            m.invoke(parentObject, childObject);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addInput(Object parentObject, Element element) throws Exception {
        Object childObject = null;
        Elements children = element.getChildElements();
        Element child = null;
        Class[] c = new Class[]{parentObject.getClass()};
        for (int i = 0; i < children.size(); ++i) {
            child = children.get(i);
            childObject = this.elementToObject(child);
            this.add(parentObject, "addInput", childObject, class$moos$ssds$model$DataContainer == null ? ObjectBuilder.class$("moos.ssds.model.DataContainer") : class$moos$ssds$model$DataContainer);
        }
    }

    private void addOutput(Object parentObject, Element element) throws Exception {
        Object childObject = null;
        Elements children = element.getChildElements();
        Element child = null;
        Class[] c = new Class[]{parentObject.getClass()};
        for (int i = 0; i < children.size(); ++i) {
            child = children.get(i);
            childObject = this.elementToObject(child);
            this.add(parentObject, "addOutput", childObject, class$moos$ssds$model$DataContainer == null ? ObjectBuilder.class$("moos.ssds.model.DataContainer") : class$moos$ssds$model$DataContainer);
        }
    }

    private void addConsumer(Object parentObject, Element element) throws Exception {
        Object childObject = null;
        Elements children = element.getChildElements();
        Element child = null;
        Class[] c = new Class[]{parentObject.getClass()};
        for (int i = 0; i < children.size(); ++i) {
            child = children.get(i);
            childObject = this.elementToObject(child);
            this.add(parentObject, "addConsumer", childObject, class$moos$ssds$model$DataProducer == null ? ObjectBuilder.class$("moos.ssds.model.DataProducer") : class$moos$ssds$model$DataProducer);
        }
    }

    private Date parseDate(String value) {
        return this.dateFormat.parse(value);
    }

    private Collection retrieveObjects(String className) {
        ArrayList out = null;
        try {
            out = (ArrayList)this.objects.get(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            System.err.println(this.getClass().getName() + ": Unable to load class " + className);
        }
        if (out == null) {
            out = new ArrayList();
        }
        return out;
    }

    public Collection listAll() {
        ArrayList out = new ArrayList();
        Collection cs = this.objects.values();
        Iterator i = cs.iterator();
        Object c = null;
        while (i.hasNext()) {
            out.addAll((Collection)i.next());
        }
        return out;
    }

    public Collection listHumanInterventions() {
        return this.retrieveObjects(modelPackage + ".HumanIntervention");
    }

    public Collection listProcessRuns() {
        return this.retrieveObjects(modelPackage + ".ProcessRun");
    }

    public Collection listDataProducers() {
        return this.retrieveObjects(modelPackage + ".DataProducer");
    }

    public Collection listDevices() {
        return this.retrieveObjects(modelPackage + ".Device");
    }

    public Collection listDeployments() {
        return this.retrieveObjects(modelPackage + ".Deployment");
    }

    public Collection listDeployments(String role) {
        ArrayList<Deployment> out = new ArrayList<Deployment>();
        Deployment d = null;
        Collection deployments = this.retrieveObjects(modelPackage + ".Deployment");
        Iterator i = deployments.iterator();
        while (i.hasNext()) {
            d = (Deployment)i.next();
            if (!d.getRole().equalsIgnoreCase(role)) continue;
            out.add(d);
        }
        return out;
    }

    public Collection listResourceOwners() {
        Collection resourceOwners = this.listDeployments();
        resourceOwners.addAll(this.listDataProducers());
        resourceOwners.addAll(this.listDevices());
        return resourceOwners;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLogger((Class)(class$moos$ssds$model$ObjectBuilder == null ? (class$moos$ssds$model$ObjectBuilder = ObjectBuilder.class$("moos.ssds.model.ObjectBuilder")) : class$moos$ssds$model$ObjectBuilder));
    }
}

