/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import moos.ssds.model.CommentTag;
import moos.ssds.model.DataFile;

public class HeaderDescription
implements Serializable {
    private Collection commentTags = new ArrayList();
    private int numHeaderLines;
    private long byteOffset;
    private Long id;
    private String description;
    private DataFile dataFile;

    public int getNumHeaderLines() {
        return this.numHeaderLines;
    }

    public void setNumHeaderLines(int numHeaderLines) {
        this.numHeaderLines = numHeaderLines;
    }

    public void setNumHeaderLines(String numHeaderLines) {
        this.setNumHeaderLines(Integer.parseInt(numHeaderLines));
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(long byteOffset) {
        this.byteOffset = byteOffset;
    }

    public void setByteOffset(String byteOffset) {
        this.setByteOffset(Long.parseLong(byteOffset));
    }

    public boolean hasCommentTags() {
        return this.commentTags.size() > 0;
    }

    public boolean hasHeaderLines() {
        return this.numHeaderLines != 0;
    }

    public boolean hasByteOffset() {
        return this.byteOffset > 0L;
    }

    public void addCommentTag(String tag) {
        CommentTag ct = new CommentTag(tag);
        ct.setHeaderDescription(this);
        this.commentTags.add(ct);
    }

    public void addCommentTag(CommentTag tag) {
        tag.setHeaderDescription(this);
        this.commentTags.add(tag);
    }

    public void removeCommentTag(CommentTag tag) {
        if (this.commentTags.contains(tag)) {
            this.commentTags.remove(tag);
            tag.setHeaderDescription(null);
        }
    }

    public void removeCommentTag(String tag) {
        CommentTag newTag = new CommentTag(tag);
        this.removeCommentTag(newTag);
    }

    public Collection listCommentTags() {
        return this.commentTagsAsStrings();
    }

    public Collection commentTagsAsStrings() {
        Iterator i = this.commentTags.iterator();
        ArrayList<String> al = new ArrayList<String>();
        CommentTag ct = null;
        while (i.hasNext()) {
            ct = (CommentTag)i.next();
            al.add(ct.getTagString());
        }
        return al;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    void setDataFile(DataFile file) {
        this.dataFile = file;
    }
}

