/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import moos.ssds.model.Deployment;
import moos.ssds.model.IDescription;
import moos.ssds.model.Person;
import moos.ssds.model.Resource;
import moos.ssds.model.ResourceOwner;
import moos.ssds.model.ValueObject;

public class Device
implements ResourceOwner,
Serializable,
IDescription,
ValueObject {
    private Collection deployments;
    private Person contact;
    private String description;
    private Long id;
    private String mfgModel;
    private String mfgName;
    private String mfgSerialNumber;
    private String name;
    private Person person;
    private Long personId;
    private String preferredDeploymentRole;
    private Collection resources = new ArrayList();
    private String type;

    public Device() {
        this.description = "";
        this.contact = new Person();
    }

    public Device(long ID) {
        this(new Long(ID));
    }

    public Device(Long ID) {
        this.setId(ID);
    }

    public synchronized void addDeployment(Deployment d) {
        if (this.deployments == null) {
            this.deployments = new ArrayList();
        }
        this.deployments.add(d);
    }

    public void addResource(Resource dr) {
        this.resources.add(dr);
        dr.setResourceOwner(this);
    }

    public Collection getDeployments() {
        return this.deployments;
    }

    public Person getContact() {
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getMfgModel() {
        return this.mfgModel;
    }

    public String getMfgName() {
        return this.mfgName;
    }

    public String getMfgSerialNumber() {
        return this.mfgSerialNumber;
    }

    public String getName() {
        return this.name;
    }

    public Person getPerson() {
        return this.person;
    }

    public Long getPersonId() {
        return this.personId;
    }

    public String getPreferredDeploymentRole() {
        return this.preferredDeploymentRole;
    }

    public String getType() {
        return this.type;
    }

    public Collection listDeployments() {
        return new ArrayList(this.deployments);
    }

    public Collection listResources() {
        return new ArrayList(this.resources);
    }

    public void removeResource(Resource dr) {
        this.resources.remove(dr);
        dr.setResourceOwner(null);
    }

    public void removeDeployment(Deployment d) {
        this.deployments.remove(d);
    }

    public void setDeployments(Collection deployments) {
        this.deployments = deployments;
    }

    public void setContact(Person contact) {
        this.contact = contact;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setId(long id) {
        this.id = new Long(id);
    }

    public void setMfgModel(String mfgModel) {
        this.mfgModel = mfgModel;
    }

    public void setMfgName(String mfgName) {
        this.mfgName = mfgName;
    }

    public void setMfgSerialNumber(String mfgSerialNumber) {
        this.mfgSerialNumber = mfgSerialNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPerson(Person property) {
        this.person = property;
    }

    public void setPersonId(Long property) {
        this.personId = property;
    }

    public Collection getResources() {
        return this.resources;
    }

    public void setResources(Collection resources) {
        this.resources = resources;
    }

    public void setPreferredDeploymentRole(String preferredDeploymentRole) {
        this.preferredDeploymentRole = preferredDeploymentRole;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" (Device #" + this.id + ")");
        sb.append(": " + this.mfgName + " " + this.mfgModel + " " + this.mfgSerialNumber);
        return sb.toString();
    }
}

