/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import moos.ssds.model.DataProducer;
import moos.ssds.model.Device;
import moos.ssds.model.X3DLocation;
import moos.ssds.model.XmlDateFormat;

public class Deployment
extends DataProducer {
    private Collection childDeployments;
    private Device device = null;
    private Long deviceId = null;
    private Long metadataId;
    private Float nominalDepth = null;
    private Double nominalLatitude = null;
    private Double nominalLongitude = null;
    private String ojbConcreteClass;
    private Deployment parentDeployment = null;
    private Long parentId = null;
    private String role;
    private X3DLocation x3DLocation;
    public static final String INSTRUMENT_ROLE = "instrument";
    public static final String OBSERVATORY_ROLE = "observatory";
    public static final String PLATFORM_ROLE = "platform";
    public static final String SENSOR_ROLE = "sensor";
    private static final XmlDateFormat xmlDateFormat = new XmlDateFormat();

    public Deployment(Device device) {
        this(device, null);
    }

    public Deployment(Device d, Deployment p) {
        this.setParentDeployment(p);
        this.setDevice(d);
        this.x3DLocation = new X3DLocation();
        this.ojbConcreteClass = this.getClass().getName();
    }

    public Deployment() {
        this(null, null);
    }

    public void addChildDeployment(Deployment deployment) {
        if (this.childDeployments == null) {
            this.childDeployments = new ArrayList();
        }
        this.childDeployments.add(deployment);
        deployment.setParentDeployment(this);
    }

    public Collection getChildDeployments() {
        return this.childDeployments;
    }

    public Device getDevice() {
        return this.device;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public Long getMetadataId() {
        return this.metadataId;
    }

    public String getOjbConcreteClass() {
        return this.ojbConcreteClass;
    }

    public void setParentDeployment(Deployment parent) {
        this.parentDeployment = parent;
    }

    public Deployment getParentDeployment() {
        return this.parentDeployment;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public String getRole() {
        return this.role;
    }

    public X3DLocation getX3DLocation() {
        return this.x3DLocation;
    }

    public Collection listAllOutputsInclChildren() {
        Collection outputs = this.listOutputsInclChildren();
        if (outputs != null) {
            outputs.addAll(this.listDerivedOutputsInclChildren());
        }
        return outputs;
    }

    public Collection listChildDeployments() {
        if (this.childDeployments == null) {
            this.childDeployments = new ArrayList();
        }
        return new ArrayList(this.childDeployments);
    }

    public Collection listChildDeployments(String role) {
        ArrayList<Deployment> deploys = new ArrayList<Deployment>();
        Iterator i = this.childDeployments.iterator();
        Deployment d = null;
        while (i.hasNext()) {
            d = (Deployment)i.next();
            if (!d.getRole().equalsIgnoreCase(role)) continue;
            deploys.add(d);
        }
        return deploys;
    }

    public Collection listDerivedOutputsInclChildren() {
        Collection out = this.listDerivedOutputs();
        if (this.childDeployments != null) {
            Iterator i = this.childDeployments.iterator();
            Deployment d = null;
            while (i.hasNext()) {
                d = (Deployment)i.next();
                if (d.listDerivedOutputsInclChildren() == null) continue;
                out.addAll(d.listDerivedOutputsInclChildren());
            }
        }
        return out;
    }

    public Collection listOutputsInclChildren() {
        Collection out = this.listOutputs();
        if (this.childDeployments != null) {
            Iterator i = this.childDeployments.iterator();
            Deployment d = null;
            while (i.hasNext()) {
                d = (Deployment)i.next();
                out.addAll(d.listOutputsInclChildren());
            }
        }
        return out;
    }

    public void removeChildDeployment(Deployment deployment) {
        if (this.childDeployments == null) {
            this.childDeployments = new ArrayList();
        }
        this.childDeployments.remove(deployment);
    }

    public void setChildDeployments(Collection children) {
        this.childDeployments = children;
    }

    public void setDevice(Device newDevice) {
        if (this.device != null) {
            this.device.removeDeployment(this);
        }
        this.device = newDevice;
        if (newDevice != null) {
            this.deviceId = newDevice.getId();
            if (this.role == null) {
                this.setRole(newDevice.getPreferredDeploymentRole());
            }
            this.device.addDeployment(this);
        }
    }

    public void setDeviceId(Long device_id) {
        this.deviceId = device_id;
    }

    public void setMetadataId(Long metadataId) {
        this.metadataId = metadataId;
    }

    public void setOjbConcreteClass(String ojbConcreteClass) {
        this.ojbConcreteClass = ojbConcreteClass;
    }

    public void setParentId(Long parent_id) {
        this.parentId = parent_id;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setX3DLocation(X3DLocation x3DLocation) {
        this.x3DLocation = x3DLocation;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String deploymentName = this.getName();
        if (deploymentName != null) {
            sb.append("Unnamed Deployment of device #");
        } else {
            sb.append("Deployment, ");
            sb.append(deploymentName);
            sb.append(", of device #");
        }
        sb.append(this.device.getId().toString());
        Date start = this.getStartDate();
        if (start != null) {
            XmlDateFormat xdf = new XmlDateFormat();
            sb.append(" beginning on ");
            sb.append(xdf.format(start));
        }
        return sb.toString();
    }

    public Double getNominalLatitude() {
        return this.nominalLatitude;
    }

    public void setNominalLatitude(Double nominalLatitude) {
        this.nominalLatitude = nominalLatitude;
    }

    public Double getNominalLongitude() {
        return this.nominalLongitude;
    }

    public void setNominalLongitude(Double nominalLongitude) {
        this.nominalLongitude = nominalLongitude;
    }

    public Float getNominalDepth() {
        return this.nominalDepth;
    }

    public void setNominalDepth(Float nominalDepth) {
        this.nominalDepth = nominalDepth;
    }
}

