/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.Serializable;
import java.util.Date;
import moos.ssds.model.IDateRange;

public class DateRange
implements Serializable {
    private Date endDate;
    private Date startDate;
    private IDateRange iDateRange;
    private boolean proxy;
    public static final int BEFORE = -1;
    public static final int AFTER = 1;
    public static final int DURING = 0;

    public DateRange() {
        this.proxy = false;
    }

    public DateRange(IDateRange iDateRange) {
        this.iDateRange = iDateRange;
        this.proxy = true;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int relation(Date date) {
        int r = 0;
        if (this.after(date)) {
            r = -1;
        } else if (this.before(date)) {
            r = 1;
        }
        return r;
    }

    public boolean before(Date date) {
        return date.after(this.endDate);
    }

    public boolean during(Date date) {
        boolean ok = false;
        if (date.after(this.startDate) && date.before(this.endDate)) {
            ok = true;
        }
        return ok;
    }

    public boolean after(Date date) {
        return date.before(this.startDate);
    }

    public int durationDays() {
        return (int)this.duration() / 1000 / 60 / 60 / 24;
    }

    public long duration() {
        return this.endDate.getTime() - this.startDate.getTime();
    }
}

