/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import moos.ssds.model.DataContainer;
import moos.ssds.model.DateRange;
import moos.ssds.model.Event;
import moos.ssds.model.IDateRange;
import moos.ssds.model.IDescription;
import moos.ssds.model.Person;
import moos.ssds.model.Resource;
import moos.ssds.model.ResourceOwner;

public class DataProducer
implements ResourceOwner,
Serializable,
IDateRange,
IDescription {
    protected String ojbConcreteClass;
    DateRange dateRange = new DateRange(this);
    String description = "";
    private Person contact;
    Date endDate;
    private Collection events = new ArrayList();
    private Long id;
    private Collection inputs = new ArrayList();
    String name;
    private Collection outputs = new ArrayList();
    private Collection resources = new ArrayList();
    Date startDate;

    public DataProducer() {
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.contact = new Person();
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void addInput(DataContainer dataContainer) {
        this.inputs.add(dataContainer);
        dataContainer.addConsumer(this);
    }

    public void addOutput(DataContainer dataContainer) {
        this.outputs.add(dataContainer);
        dataContainer.setCreator(this);
    }

    public void addResource(Resource dr) {
        this.resources.add(dr);
        dr.setResourceOwner(this);
    }

    public Person getContact() {
        return this.contact;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOjbConcreteClass() {
        return this.ojbConcreteClass;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Collection listAllOutputs() {
        Collection outputs = this.listOutputs();
        outputs.addAll(this.listDerivedOutputs());
        return outputs;
    }

    public Collection listDerivedOutputs() {
        Iterator i = this.outputs.iterator();
        DataContainer dataContainer = null;
        ArrayList out = new ArrayList();
        while (i.hasNext()) {
            dataContainer = (DataContainer)i.next();
            if (dataContainer == null) continue;
            out.addAll(dataContainer.listDerivedOutputs());
        }
        return out;
    }

    public Collection listEvents() {
        return new ArrayList(this.events);
    }

    public Collection listInputs() {
        return new ArrayList(this.inputs);
    }

    public Collection listOutputs() {
        return new ArrayList(this.outputs);
    }

    public Collection listResources() {
        return new ArrayList(this.resources);
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
    }

    public void removeInput(DataContainer dataContainer) {
        this.inputs.remove(dataContainer);
        dataContainer.removeConsumer(this);
    }

    public void removeOutput(DataContainer dataContainer) {
        this.outputs.remove(dataContainer);
        dataContainer.setCreator(null);
    }

    public void removeResource(Resource dr) {
        this.resources.remove(dr);
        dr.setResourceOwner(null);
    }

    public void setContact(Person contact) {
        this.contact = contact;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOjbConcreteClass(String ojbConcreteClass) {
        this.ojbConcreteClass = ojbConcreteClass;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
}

