/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import org.mbari.isi.interfaces.DeviceMessagePacket;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.SensorDataPacket;

public class DataPacket
extends SensorDataPacket {
    private long metadataId;
    private long platformId;
    private long recordType;
    public static final int VERSION_ID = 1;
    private static final long serialVersionUID = 680021341142244258L;

    public DataPacket(long ID, int size) {
        super(ID, size);
    }

    public DataPacket(SensorDataPacket packet) {
        this(packet.sourceID(), packet.dataBuffer().length);
        this.setMetadataId(-1L);
        this.setPlatformId(-1L);
        this.setRecordType(-1L);
        this.setDataBuffer(packet.dataBuffer());
        this.setSequenceNo(packet.sequenceNo());
        this.setSystemTime(packet.systemTime());
    }

    public DataPacket(MetadataPacket packet) {
        this(packet.sourceID(), packet.getBytes().length);
        this.setMetadataId(-1L);
        this.setPlatformId(-1L);
        this.setRecordType(0L);
        this.setDataBuffer(packet.getBytes());
        this.setSequenceNo(packet.sequenceNo());
        this.setSystemTime(packet.systemTime());
    }

    public DataPacket(DeviceMessagePacket packet) {
        this(packet.sourceID(), packet.getMessage().length);
        this.setMetadataId(-1L);
        this.setPlatformId(-1L);
        this.setRecordType(-1L);
        this.setDataBuffer(packet.getMessage());
        this.setSequenceNo(packet.sequenceNo());
        this.setSystemTime(packet.systemTime());
    }

    public DataPacket(DataPacket packet) {
        this(packet.sourceID(), packet.dataBuffer().length);
        this.setMetadataId(packet.getMetadataId());
        this.setPlatformId(packet.getPlatformId());
        this.setRecordType(packet.getRecordType());
        this.setDataBuffer(packet.dataBuffer());
        this.setSequenceNo(packet.sequenceNo());
        this.setSystemTime(packet.systemTime());
    }

    public long getMetadataId() {
        return this.metadataId;
    }

    public void setMetadataId(long metadataId) {
        this.metadataId = metadataId;
    }

    public long getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(long platformId) {
        this.platformId = platformId;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public void setRecordType(long variableID) {
        this.recordType = variableID;
    }
}

