/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import moos.ssds.model.DataProducer;
import moos.ssds.model.DateRange;
import moos.ssds.model.IDateRange;
import moos.ssds.model.IDescription;
import moos.ssds.model.Person;
import moos.ssds.model.RecordDescription;
import moos.ssds.model.Resource;
import moos.ssds.model.ResourceOwner;

public class DataContainer
implements ResourceOwner,
Serializable,
IDateRange,
IDescription {
    protected String ojbConcreteClass;
    Person contact;
    DataProducer creator;
    DateRange dateRange = new DateRange(this);
    String description = "No Description";
    boolean original;
    private Collection consumers = new ArrayList();
    private Long dataProducerId;
    private Date endDate;
    private Long id;
    private String name;
    private Person person;
    private Long personId;
    private Collection resources = new ArrayList();
    private Date startDate;
    private Collection recordDescriptions = new ArrayList();

    public DataContainer() {
        this.dateRange = new DateRange(this);
        this.creator = new DataProducer();
        this.ojbConcreteClass = this.getClass().getName();
    }

    public void addResource(Resource dr) {
        if (!this.resources.contains(dr)) {
            this.resources.add(dr);
            dr.setResourceOwner(this);
        }
    }

    public void addConsumer(DataProducer producer) {
        if (!this.consumers.contains(producer)) {
            this.consumers.add(producer);
        }
    }

    public Person getContact() {
        return this.contact;
    }

    public DataProducer getCreator() {
        return this.creator;
    }

    public Long getDataProducerId() {
        return this.dataProducerId;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Person getPerson() {
        return this.person;
    }

    public Long getPersonId() {
        return this.personId;
    }

    public RecordDescription getRecordDescription() {
        Iterator i = this.recordDescriptions.iterator();
        RecordDescription rd = null;
        if (i.hasNext()) {
            rd = (RecordDescription)i.next();
        }
        return rd;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public Collection listAllInputs() {
        ArrayList ancestors = new ArrayList();
        DataContainer.listAllInputs(this.creator, ancestors);
        return ancestors;
    }

    public Collection listDerivedOutputs() {
        ArrayList descendants = new ArrayList();
        this.listDerivedOutputs(this, descendants);
        return descendants;
    }

    public Collection listAllConsumers() {
        ArrayList destinyBuffer = new ArrayList();
        DataContainer.listAllConsumers(this, destinyBuffer);
        return destinyBuffer;
    }

    public Collection listDirectConsumers() {
        return new ArrayList(this.consumers);
    }

    public Collection listAllProducers() {
        ArrayList history = new ArrayList();
        DataContainer.listAllProducers(this.creator, history);
        return history;
    }

    public Collection listIndirectConsumers() {
        Iterator i = this.consumers.iterator();
        DataProducer dp = null;
        ArrayList ic = new ArrayList();
        while (i.hasNext()) {
            dp = (DataProducer)i.next();
            dp.listDerivedOutputs();
        }
        return null;
    }

    public Collection listResources() {
        return new ArrayList(this.resources);
    }

    public void removeResource(Resource dr) {
        this.resources.remove(dr);
        dr.setResourceOwner(null);
    }

    public void setContact(Person contact) {
        this.contact = contact;
    }

    public void setDataProducerId(Long dataProducerId) {
        this.dataProducerId = dataProducerId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginal(boolean original) {
        this.original = original;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public void setRecordDescription(RecordDescription recordDescription) {
        this.recordDescriptions.clear();
        this.recordDescriptions.add(recordDescription);
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String toString() {
        return this.ojbConcreteClass + " " + this.name;
    }

    void removeConsumer(DataProducer producer) {
        this.consumers.remove(producer);
    }

    void setCreator(DataProducer creator) {
        this.creator = creator;
    }

    private void listDerivedOutputs(DataContainer dataContainer, Collection descendants) {
        if (dataContainer != this) {
            descendants.add(dataContainer);
        }
        Iterator iterator = dataContainer.listDirectConsumers().iterator();
        DataProducer producer = null;
        while (iterator.hasNext()) {
            producer = (DataProducer)iterator.next();
            this.listDerivedOutputs(producer, descendants);
        }
    }

    private void listDerivedOutputs(DataProducer producer, Collection descendants) {
        Collection outputs = producer.listOutputs();
        Iterator iterator = outputs.iterator();
        DataContainer dataContainer = null;
        while (iterator.hasNext()) {
            dataContainer = (DataContainer)iterator.next();
            this.listDerivedOutputs(dataContainer, descendants);
        }
    }

    private static void listAllInputs(DataProducer producer, Collection ancestors) {
        Collection inputs = producer.listInputs();
        Iterator iterator = inputs.iterator();
        DataContainer dataContainer = null;
        while (iterator.hasNext()) {
            dataContainer = (DataContainer)iterator.next();
            ancestors.add(dataContainer);
            DataContainer.listAllInputs(dataContainer.getCreator(), ancestors);
        }
    }

    private static void listAllConsumers(DataContainer dataContainer, Collection destinyBuffer) {
        Iterator iterator = dataContainer.listDirectConsumers().iterator();
        DataProducer producer = null;
        while (iterator.hasNext()) {
            producer = (DataProducer)iterator.next();
            DataContainer.listAllConsumers(producer, destinyBuffer);
        }
    }

    private static void listAllConsumers(DataProducer producer, Collection destinyBuffer) {
        destinyBuffer.add(producer);
        Collection outputs = producer.listOutputs();
        Iterator iterator = outputs.iterator();
        DataContainer dataContainer = null;
        while (iterator.hasNext()) {
            dataContainer = (DataContainer)iterator.next();
            DataContainer.listAllConsumers(dataContainer, destinyBuffer);
        }
    }

    private static void listAllProducers(DataProducer producer, Collection history) {
        history.add(producer);
        Collection inputs = producer.listInputs();
        Iterator iterator = inputs.iterator();
        DataContainer dataContainer = null;
        while (iterator.hasNext()) {
            dataContainer = (DataContainer)iterator.next();
            DataContainer.listAllProducers(dataContainer.getCreator(), history);
        }
    }

    public Collection listIndirectCreators() {
        return null;
    }

    public Collection getRecordDescriptions() {
        return this.recordDescriptions;
    }

    public void setRecordDescriptions(Collection recordDescriptions) {
        this.recordDescriptions = recordDescriptions;
    }

    public synchronized void addRecordDescription(RecordDescription rd) {
        rd.setDataContainer(this);
        this.recordDescriptions.add(rd);
    }

    public synchronized void removeRecordDescription(RecordDescription rd) {
        rd.setDataContainer(null);
        this.recordDescriptions.remove(rd);
    }

    public Collection listDirectInputs() {
        return null;
    }

    public Collection listIndirectInputs() {
        return null;
    }

    public Collection listRecordDescriptions() {
        return new ArrayList(this.recordDescriptions);
    }

    public Collection listAllOutputs() {
        ArrayList out = new ArrayList();
        Iterator i = this.listDirectConsumers().iterator();
        DataProducer dp = null;
        while (i.hasNext()) {
            dp = (DataProducer)i.next();
            out.addAll(dp.listAllOutputs());
        }
        return out;
    }
}

