/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SubscriberComponent {
    protected String topicname;
    protected Context jndiContext;
    protected TopicConnectionFactory topicConnectionFactory;
    protected TopicSession topicSession;
    protected TopicConnection topicConnection;
    protected Message message;
    private Topic topic;
    protected TopicSubscriber topicSubscriber;
    private MessageListener messageListener;
    private Logger subscriberLogger = Logger.getLogger((Class)(class$moos$ssds$jms$SubscriberComponent == null ? (class$moos$ssds$jms$SubscriberComponent = SubscriberComponent.class$("moos.ssds.jms.SubscriberComponent")) : class$moos$ssds$jms$SubscriberComponent));
    static /* synthetic */ Class class$moos$ssds$jms$SubscriberComponent;

    public SubscriberComponent(String topicName, MessageListener messageListener) {
        this.subscriberLogger.setLevel(Level.DEBUG);
        this.subscribe(topicName, messageListener);
    }

    private void subscribe(String topicName, MessageListener messageListener) {
        boolean connected = false;
        this.subscriberLogger.debug((Object)("SubscriberComponent is subscribing to " + topicName));
        try {
            this.topicname = topicName;
            this.messageListener = messageListener;
            this.subscriberLogger.debug((Object)"Starting JNDI and JMS in SubscriberComponent");
            this.jndiContext = new InitialContext();
            this.subscriberLogger.debug((Object)"Should have initial context");
            while (!connected) {
                try {
                    this.topicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup("ConnectionFactory");
                }
                catch (NamingException ne) {
                    this.subscriberLogger.debug((Object)("Could not get to initial context due to naming exception, will wait and try again. Message = " + ne.getMessage()));
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception te) {
                        this.subscriberLogger.debug((Object)"Could not put thread to sleep");
                    }
                    continue;
                }
                catch (Exception ex) {
                    this.subscriberLogger.debug((Object)("Could not get to initial context due to unknown exception, will wait and try again. Message = " + ex.getMessage()));
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception te) {
                        this.subscriberLogger.debug((Object)"Could not put thread to sleep");
                    }
                    continue;
                }
                connected = true;
            }
            this.subscriberLogger.debug((Object)"should have topicConnectionFactory");
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.subscriberLogger.debug((Object)"Should have topicConnection");
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.subscriberLogger.debug((Object)"should have topicSession");
            this.message = this.topicSession.createObjectMessage();
            this.subscriberLogger.debug((Object)"should have create message");
            this.topic = (Topic)this.jndiContext.lookup(topicName);
            this.subscriberLogger.debug((Object)"should have topic");
            this.topicSubscriber = this.topicSession.createSubscriber(this.topic);
            this.subscriberLogger.debug((Object)"should have topicSubscriber");
            this.topicSubscriber.setMessageListener(messageListener);
            this.subscriberLogger.debug((Object)"should have set message listener");
            this.topicConnection.start();
            this.subscriberLogger.debug((Object)"should have started");
        }
        catch (NamingException e) {
            this.subscriberLogger.debug((Object)("Error publishing to JMS. JNDI API lookup failed: " + e.toString()));
            e.printStackTrace();
        }
        catch (JMSException e) {
            this.subscriberLogger.debug((Object)("Error connecting to JMS: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public String getTopicname() {
        return this.topicname;
    }

    public void close() {
        this.subscriberLogger.debug((Object)"close called");
        try {
            this.message = null;
            this.topic = null;
            if (this.topicSubscriber != null) {
                this.topicSubscriber.close();
                this.topicSubscriber = null;
            }
            if (this.topicSession != null) {
                this.topicSession.close();
                this.topicSession = null;
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
                this.topicConnection = null;
            }
            this.topicConnectionFactory = null;
            if (this.jndiContext != null) {
                this.jndiContext.close();
                this.jndiContext = null;
            }
        }
        catch (JMSException e) {
            this.subscriberLogger.debug((Object)("Error with JMS connection on cleanup: " + e.getMessage()));
        }
        catch (NamingException e) {
            this.subscriberLogger.debug((Object)("Error with JNDI API on cleanup: " + e.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

