/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.util.Logger;

public class Subscriber {
    protected String topicname;
    protected Context jndiContext;
    protected TopicConnectionFactory topicConnectionFactory;
    protected TopicSession topicSession;
    protected TopicConnection topicConnection;
    protected Message message;
    private Topic topic;
    protected TopicSubscriber topicSubscriber;
    private MessageListener messageListener;
    private Logger subscriberLogger;
    private boolean connected;

    public Subscriber(String topicName, MessageListener messageListener) {
        this.subscribe(topicName, messageListener);
    }

    private void subscribe(String topicName, MessageListener messageListener) {
        if (this.isConnected()) {
            this.close();
        }
        this.topicname = topicName;
        this.messageListener = messageListener;
        try {
            this.jndiContext = new InitialContext();
            this.topicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup("ConnectionFactory");
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.message = this.topicSession.createObjectMessage();
            this.topic = (Topic)this.jndiContext.lookup(topicName);
            this.topicSubscriber = this.topicSession.createSubscriber(this.topic);
            this.topicSubscriber.setMessageListener(messageListener);
            this.topicConnection.start();
            this.connected = true;
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public String getTopicname() {
        return this.topicname;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect() {
        this.subscribe(this.topicname, this.messageListener);
    }

    public void close() {
        this.connected = false;
        try {
            this.message = null;
            this.topic = null;
            if (this.topicSubscriber != null) {
                this.topicSubscriber.close();
                this.topicSubscriber = null;
            }
            if (this.topicSession != null) {
                this.topicSession.close();
                this.topicSession = null;
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
                this.topicConnection = null;
            }
            this.topicConnectionFactory = null;
            if (this.jndiContext != null) {
                this.jndiContext.close();
                this.jndiContext = null;
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

