/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.jms;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class PublisherComponent {
    private String topicname;
    private Topic topic;
    private Context jndiContext;
    private TopicConnectionFactory topicConnectionFactory;
    private TopicSession topicSession;
    private TopicConnection topicConnection;
    private TopicPublisher topicPublisher;
    private ObjectMessage message;
    private boolean connected = false;
    static Logger publisherLogger = Logger.getLogger((Class)(class$moos$ssds$jms$PublisherComponent == null ? (class$moos$ssds$jms$PublisherComponent = PublisherComponent.class$("moos.ssds.jms.PublisherComponent")) : class$moos$ssds$jms$PublisherComponent));
    static /* synthetic */ Class class$moos$ssds$jms$PublisherComponent;

    public PublisherComponent(String topicName) {
        this();
        this.setTopicname(topicName);
    }

    public PublisherComponent() {
        Properties jmsProps = new Properties();
        publisherLogger.debug((Object)"Default constructor called");
        try {
            jmsProps.load(this.getClass().getResourceAsStream("/moos/ssds/jms/jms.properties"));
        }
        catch (Exception e) {
            publisherLogger.debug((Object)"Could not get jms properties file");
        }
        if (jmsProps != null) {
            this.setTopicname(jmsProps.getProperty("ssds.jms.topic"));
            publisherLogger.debug((Object)("Should have set the topicName to " + jmsProps.getProperty("ssds.jms.topic")));
        } else {
            publisherLogger.debug((Object)"The jmsProps object came back null");
        }
    }

    private void start() {
        publisherLogger.debug((Object)"start called, setting connected to true");
        this.connected = true;
        try {
            this.jndiContext = new InitialContext();
        }
        catch (NamingException ne) {
            publisherLogger.debug((Object)("Could not start--> A naming exception was caught while trying to get an initial context: " + ne.getMessage()));
            this.connected = false;
            return;
        }
        catch (Exception e) {
            publisherLogger.debug((Object)("Could not start--> An unknown exception was caught while trying to get an initial context: " + e.getMessage()));
            this.connected = false;
            return;
        }
        try {
            this.topicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup("ConnectionFactory");
        }
        catch (NamingException ne) {
            publisherLogger.debug((Object)("Could not start--> A naming exception was caught while trying to get the topicConnectionFactory: " + ne.getMessage()));
            this.connected = false;
            return;
        }
        catch (Exception e) {
            publisherLogger.debug((Object)("Could not start--> An unknown exception was caught while trying to get the topicConnectionFactory: " + e.getMessage()));
            this.connected = false;
            return;
        }
        try {
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
        }
        catch (JMSException jmse) {
            publisherLogger.debug((Object)("Could not start--> A JMS exception was caught while trying to get the topicConnection: " + jmse.getMessage()));
            this.connected = false;
            return;
        }
        catch (Exception e) {
            publisherLogger.debug((Object)("Could not start--> An unknown exception was caught while trying to get the topicConnection: " + e.getMessage()));
            this.connected = false;
            return;
        }
        try {
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
        }
        catch (JMSException jmse) {
            publisherLogger.debug((Object)("Could not start--> A JMS exception was caught while trying to get the topicSession: " + jmse.getMessage()));
            this.connected = false;
            return;
        }
        catch (Exception e) {
            publisherLogger.debug((Object)("Could not start--> An unknown exception was caught while trying to get the topicSession: " + e.getMessage()));
            try {
                if (this.topicConnection != null) {
                    this.topicConnection.close();
                }
            }
            catch (JMSException jmse) {
                // empty catch block
            }
            this.connected = false;
            return;
        }
        try {
            this.message = this.topicSession.createObjectMessage();
        }
        catch (JMSException jmse) {
            publisherLogger.debug((Object)("Could not start--> A JMS exception was caught while trying to create a message: " + jmse.getMessage()));
            this.connected = false;
            return;
        }
        catch (Exception e) {
            publisherLogger.debug((Object)("Could not start--> An unknown exception was caught while trying to create a message: " + e.getMessage()));
            try {
                if (this.topicSession != null) {
                    this.topicSession.close();
                }
                if (this.topicConnection != null) {
                    this.topicConnection.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.connected = false;
            return;
        }
    }

    private void stop() {
        publisherLogger.debug((Object)"PublisherComponent stop called");
        try {
            this.message = null;
            this.topic = null;
            if (this.topicPublisher != null) {
                this.topicPublisher.close();
                this.topicPublisher = null;
            }
            if (this.topicSession != null) {
                this.topicSession.close();
                this.topicSession = null;
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
                this.topicConnection = null;
            }
            this.topicConnectionFactory = null;
            if (this.jndiContext != null) {
                this.jndiContext.close();
                this.jndiContext = null;
            }
        }
        catch (JMSException e) {
            publisherLogger.debug((Object)("Error with JMS connection on cleanup: " + e.getMessage()));
        }
        catch (NamingException e) {
            publisherLogger.debug((Object)("Error with JNDI API on cleanup: " + e.getMessage()));
        }
        this.connected = false;
    }

    public boolean publish(Serializable obj) {
        publisherLogger.debug((Object)"Publish called");
        boolean success = false;
        if (!this.connected) {
            this.setTopicname(this.topicname);
            publisherLogger.debug((Object)"Not connected, so a reconnect was done");
        }
        if (this.connected) {
            publisherLogger.debug((Object)"Connected, so going to send message");
            try {
                this.message.setObject(obj);
                this.topicPublisher.publish((Message)this.message);
                success = true;
            }
            catch (JMSException e) {
                publisherLogger.debug((Object)("Error with JMS: " + e.getMessage()));
                this.connected = false;
            }
            catch (Exception e) {
                publisherLogger.debug((Object)("Error with JMS: " + e.getMessage()));
                this.connected = false;
            }
        }
        publisherLogger.debug((Object)("Tried to send message ... success? " + success));
        return success;
    }

    public void setTopicname(String topicName) {
        if (topicName == null) {
            return;
        }
        publisherLogger.debug((Object)("setTopicname called with name " + this.topicname));
        this.topicname = topicName;
        if (this.topicPublisher != null) {
            publisherLogger.debug((Object)"topicPublisher not null, so will try to close it");
            try {
                this.topicPublisher.close();
            }
            catch (JMSException jmse) {
                publisherLogger.debug((Object)("Could not close the topicPublisher: " + jmse.getMessage()));
            }
        }
        if (!this.connected) {
            publisherLogger.debug((Object)"Not connected so calling start");
            this.start();
        }
        if (this.connected) {
            publisherLogger.debug((Object)("Connected, so will get topic " + topicName));
            try {
                this.topic = (Topic)this.jndiContext.lookup(topicName);
            }
            catch (NamingException ne) {
                publisherLogger.debug((Object)("Could not get topic in setTopicName and a NamingException was caught: " + ne.getMessage()));
                this.connected = false;
            }
            catch (Exception e) {
                publisherLogger.debug((Object)("Could not get topic in setTopicName and an unknown exception was caught: " + e.getMessage()));
                this.connected = false;
            }
            publisherLogger.debug((Object)("Connected after getting topic? " + this.connected));
        }
        if (this.connected) {
            publisherLogger.debug((Object)"Still connected, so will try get publisher");
            try {
                this.topicPublisher = this.topicSession.createPublisher(this.topic);
            }
            catch (JMSException jmse) {
                publisherLogger.debug((Object)("Could not get topicPublisher in setTopicName and a JMSException was caught: " + jmse.getMessage()));
                this.connected = false;
            }
            catch (Exception e) {
                publisherLogger.debug((Object)("Could not get topicPublisher in setTopicName and an unknown exception was caught: " + e.getMessage()));
                this.connected = false;
            }
            publisherLogger.debug((Object)("Connected after getting publisher? " + this.connected));
        }
        if (!this.connected) {
            publisherLogger.debug((Object)"Could not setTopicName because connection was not established");
        }
    }

    public String getTopicname() {
        return this.topicname;
    }

    public void finalize() {
        try {
            publisherLogger.debug((Object)"finalize method called ...");
            super.finalize();
            this.stop();
            publisherLogger.debug((Object)"finalize finished.");
        }
        catch (Throwable t) {
            publisherLogger.debug((Object)"Could not complete finalize correctly ...");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

