/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Publisher {
    String topicname;
    Topic topic;
    Context jndiContext;
    TopicConnectionFactory topicConnectionFactory;
    TopicSession topicSession;
    TopicConnection topicConnection;
    TopicPublisher topicPublisher;
    ObjectMessage message;
    private boolean connected = false;

    public Publisher(String topicName) {
        this.setTopicname(topicName);
    }

    public Publisher() {
        this(null);
    }

    private void start() {
        this.connected = false;
        try {
            this.jndiContext = new InitialContext();
            this.topicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup("ConnectionFactory");
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.message = this.topicSession.createObjectMessage();
            this.connected = true;
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stop() {
        try {
            this.message = null;
            this.topic = null;
            if (this.topicPublisher != null) {
                this.topicPublisher.close();
                this.topicPublisher = null;
            }
            if (this.topicSession != null) {
                this.topicSession.close();
                this.topicSession = null;
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
                this.topicConnection = null;
            }
            this.topicConnectionFactory = null;
            if (this.jndiContext != null) {
                this.jndiContext.close();
                this.jndiContext = null;
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        this.connected = false;
    }

    public boolean publish(Serializable obj) {
        boolean success = false;
        if (this.connected) {
            try {
                this.message.setObject(obj);
                this.topicPublisher.publish((Message)this.message);
                success = true;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    public boolean setTopicname(String topicName) {
        boolean success = false;
        this.stop();
        if (topicName == null) {
            return success;
        }
        this.start();
        if (this.connected) {
            try {
                this.topic = (Topic)this.jndiContext.lookup(topicName);
                this.topicPublisher = this.topicSession.createPublisher(this.topic);
                success = true;
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getTopicname() {
        return this.topicname;
    }

    public void finalize() {
        try {
            super.finalize();
            this.stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

