/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.portal.auvctd;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import moos.operations.portal.ssds.IXMLFactory;
import moos.ssds.model.DataContainer;
import moos.ssds.model.DataFile;
import moos.ssds.model.Deployment;
import moos.ssds.model.Device;
import moos.ssds.model.HeaderDescription;
import moos.ssds.model.Person;
import moos.ssds.model.RecordDescription;
import moos.ssds.model.RecordVariable;
import moos.ssds.model.Resource;
import moos.ssds.model.XmlBuilder;

public class AUVXMLFactory
implements IXMLFactory {
    private File localDir;
    private Properties properties = new Properties();
    private URL remoteUrl;
    private XmlBuilder xmlBuilder = new XmlBuilder();
    private File devicesCfg;
    private Long platformId;
    private Collection resources = new HashSet();

    public AUVXMLFactory(File localDir, URL remoteUrl) {
        this.localDir = localDir;
        this.remoteUrl = remoteUrl;
        this.devicesCfg = new File(localDir, "devices.cfg");
        try {
            int i;
            this.properties.load(new FileInputStream(new File(localDir, "vehicle.cfg")));
            Deployment dp = this.makePlatformDeployment();
            this.xmlBuilder.addDeployment(dp);
            File[] logs = this.getLogs();
            File[] resrc = this.getResources();
            for (i = 0; i < resrc.length; ++i) {
                this.resources.add(resrc[i]);
            }
            for (i = 0; i < logs.length; ++i) {
                File log = logs[i];
                Deployment di = this.makeInstrumentDeployment(log);
                Device dvi = di.getDevice();
                if (dvi == null || dvi.getId() == null) continue;
                dp.addChildDeployment(di);
            }
            Iterator i2 = this.resources.iterator();
            while (i2.hasNext()) {
                File f = (File)i2.next();
                Resource r = new Resource();
                r.setName(f.getName());
                r.setDescription("Undescribed resource");
                r.setUrl(this.makeURL(f));
                dp.addResource(r);
            }
            this.xmlBuilder.marshal();
            System.out.println("Marshalled the AUV mission in " + localDir.getAbsolutePath() + " into XML");
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void print() {
        try {
            this.xmlBuilder.print();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getXML() {
        return this.xmlBuilder.toXML();
    }

    public byte[] getXMLAsByteArray() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            this.xmlBuilder.print((OutputStream)buf);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getClass().getName() + ": Encoding is not supported");
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + ": Unable to write to non-file system byte array");
        }
        return buf.toByteArray();
    }

    public long getDeviceId() {
        long id = -1L;
        try {
            id = this.getPlatformId();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return id;
    }

    public Collection getDeviceIds(File log) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String line = this.findString(this.devicesCfg, "deviceID: " + log.getName());
            if (line != null) {
                int i = line.indexOf(61);
                StringTokenizer st = new StringTokenizer(line.substring(i + 1).trim(), ",");
                while (st.hasMoreTokens()) {
                    ids.add(Long.valueOf(st.nextToken()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ids;
    }

    private Long getInstrumentId(File log) {
        Collection ids = this.getDeviceIds(log);
        Iterator iterator = ids.iterator();
        return (Long)iterator.next();
    }

    private Long getPlatformId() throws IOException {
        String line;
        if (this.platformId == null && (line = this.findString(this.devicesCfg, "platformid:")) != null) {
            int i = line.indexOf(58);
            this.platformId = Long.valueOf(line.substring(i + 1).trim());
        }
        return this.platformId;
    }

    private String findString(File file, String searchString) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        String lcLine = null;
        String out = null;
        int i = -1;
        searchString = searchString.toLowerCase();
        while ((line = in.readLine()) != null) {
            lcLine = line.toLowerCase();
            i = lcLine.indexOf(searchString);
            if (i <= -1) continue;
            out = line;
            break;
        }
        in.close();
        return out;
    }

    private File[] getLogs() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File someDir, String someName) {
                return someName.endsWith(".log");
            }
        };
        return this.localDir.listFiles(filter);
    }

    private File[] getResources() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File someDir, String someName) {
                return !someName.endsWith(".log") && !someName.endsWith(".m");
            }
        };
        return this.localDir.listFiles(filter);
    }

    private Deployment makeInstrumentDeployment(File log) throws MalformedURLException, FileNotFoundException, IOException {
        String logName = log.getName();
        int ext = log.getName().indexOf(46);
        String logShortName = logName.substring(0, ext);
        Deployment d = new Deployment();
        d.setRole("instrument");
        d.setName(logShortName);
        d.setDescription("Deployment information for " + log.getName());
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            String fName = f.getName();
            if (!fName.startsWith(logShortName)) continue;
            Resource r = new Resource();
            r.setName(f.getName());
            r.setDescription("Undescribed resource");
            r.setUrl(this.makeURL(f));
            d.addResource(r);
            i.remove();
        }
        Collection ids = this.getDeviceIds(log);
        Iterator iterator = ids.iterator();
        try {
            Device inst = new Device((Long)iterator.next());
            inst.setName(logShortName);
            d.setDevice(inst);
            Deployment sensorDeployment = null;
            Device sensor = null;
            while (iterator.hasNext()) {
                sensor = new Device((Long)iterator.next());
                sensorDeployment = new Deployment(sensor);
                sensorDeployment.setRole("sensor");
                d.addChildDeployment(sensorDeployment);
            }
        }
        catch (Exception e) {
            System.out.println("WARNING!! Device information is missing from " + log);
            return d;
        }
        DataFile out = new DataFile();
        out.setName(log.getName());
        out.setDescription("AUV data");
        out.setUrl(this.makeURL(log));
        out.setOriginal(true);
        d.addOutput((DataContainer)out);
        HeaderDescription hd = new HeaderDescription();
        hd.addCommentTag("#");
        out.setHeaderDescription(hd);
        RecordDescription rd = new RecordDescription();
        rd.setBufferStyle("binary");
        rd.setBufferLengthType("fixed");
        rd.setEndian("little");
        rd.setParseable(true);
        out.setRecordDescription(rd);
        BufferedReader in = new BufferedReader(new FileReader(log));
        String line = null;
        line = in.readLine();
        int i2 = 0;
        RecordVariable v = null;
        StringTokenizer st = null;
        String format = null;
        String units = null;
        String longName = null;
        String name = null;
        String cFmt = null;
        line = in.readLine();
        while (line != null && !line.startsWith("# begin")) {
            ++i2;
            st = new StringTokenizer(line);
            st.nextToken();
            format = st.nextToken().trim();
            name = st.nextToken().trim();
            cFmt = st.nextToken(",").trim();
            try {
                longName = st.nextToken(",").trim();
            }
            catch (Exception e) {
                longName = name;
            }
            try {
                units = st.nextToken().trim();
            }
            catch (Exception e1) {
                units = "UNKNOWN";
            }
            if (format.equals("timeTag")) {
                format = "double";
                units = "seconds since 1970-01-01 00:00:00";
                longName = "Time (GMT)";
            } else if (format.equals("angle")) {
                format = "double";
            }
            v = new RecordVariable();
            v.setFormat(format);
            v.setName(name);
            v.setLongName(longName);
            v.setUnits(units);
            v.setColumnIndex((long)i2);
            rd.addRecordVariable(v);
            line = in.readLine();
        }
        in.close();
        return d;
    }

    private Person makeMissionContact() {
        ResourceBundle rb = ResourceBundle.getBundle("auvportal");
        Person person = new Person();
        person.setFirstname(rb.getString("contact.firstname"));
        person.setSurname(rb.getString("contact.surname"));
        person.setEmail(rb.getString("contact.email"));
        return person;
    }

    private Deployment makePlatformDeployment() throws IOException {
        Deployment d = new Deployment();
        d.setRole("platform");
        d.setName(this.localDir.getName());
        d.setDescription("AUV mission generated from information in the directory " + this.localDir.getName() + ". WARNING!!! Metadata in missing from he mission directory.");
        d.setStartDate(new Date(0L));
        d.setEndDate(new Date());
        d.setContact(this.makeMissionContact());
        Long auvId = this.getPlatformId();
        if (auvId == null) {
            throw new IOException(this.devicesCfg.getAbsolutePath() + " does not contain a platform ID" + " (Searched for a line starting with '# platformID:')");
        }
        Device auv = new Device(this.getPlatformId());
        auv.setDescription("Dorado AUV");
        auv.setName(this.properties.getProperty("vehicleName"));
        auv.setMfgName("MBARI");
        d.setDevice(auv);
        return d;
    }

    private URL makeURL(File file) throws MalformedURLException {
        String path = this.remoteUrl.getFile();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + file.getName();
        return new URL(this.remoteUrl.getProtocol(), this.remoteUrl.getHost(), path);
    }

    public static void main(String[] args) throws Exception {
        AUVXMLFactory f = new AUVXMLFactory(new File(args[0]), new URL(args[1]));
        f.print();
    }
}

