/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.portal;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.ice.tar.TarArchive;
import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import moos.operations.portal.auvctd.AUVXMLFactory;
import moos.operations.portal.ssds.XMLPublisher;

public class AUVPortalService {
    protected ServerSocket _serverSocket;
    private String jmsTopic;
    private File localDir;
    private File remoteDir;
    private URL remoteUrl;
    private XMLPublisher xmlPublisher;

    public AUVPortalService(int port) throws IOException {
        this._serverSocket = new ServerSocket(port);
        this.initPortal();
    }

    public AUVPortalService(String survey, String file) throws IOException {
        this.initPortal();
        WorkerThread2 workerThread = new WorkerThread2(survey + ";" + file);
        workerThread.start();
    }

    public void run() {
        Socket clientSocket = null;
        if (this._serverSocket != null) {
            while (true) {
                try {
                    while (true) {
                        System.out.println("Wait for client...");
                        clientSocket = this._serverSocket.accept();
                        System.out.println("accepted connection");
                        this.processConnection(clientSocket);
                    }
                }
                catch (IOException e) {
                    System.err.println("IOException: " + e.getMessage());
                    continue;
                }
                break;
            }
        }
    }

    protected void processConnection(Socket clientSocket) throws IOException {
        byte[] buf = new byte[1024];
        InputStream in = clientSocket.getInputStream();
        int nBytes = 0;
        while (true) {
            int c;
            if ((c = in.read()) == -1) break;
            buf[nBytes++] = (byte)c;
        }
        System.err.println("processConnection() - end-of-stream");
        String message = new String(buf);
        WorkerThread workerThread = new WorkerThread(message);
        workerThread.start();
    }

    private void initPortal() throws IOException {
        ResourceBundle rb = ResourceBundle.getBundle("auvportal");
        this.localDir = new File(System.getProperty("user.dir"));
        this.remoteDir = new File(rb.getString("remote.path"));
        this.remoteUrl = new URL(rb.getString("remote.url"));
        this.jmsTopic = rb.getString("jms.topic");
        this.xmlPublisher = new XMLPublisher(this.jmsTopic);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                AUVPortalService service = new AUVPortalService(4444);
                service.run();
            } else if (args.length == 1) {
                AUVPortalService service = new AUVPortalService(Integer.parseInt(args[0]));
                service.run();
            } else if (args.length == 2) {
                AUVPortalService service = new AUVPortalService(args[0], args[1]);
            }
        }
        catch (IOException e) {
            System.err.println("Caught IOException: " + e.getMessage());
        }
    }

    class WorkerThread
    extends Thread {
        protected String _message;

        public WorkerThread(String message) {
            this._message = message;
        }

        public void run() {
            System.out.println("processConnection() got message:\n" + this._message);
            StringTokenizer tokenizer = new StringTokenizer(this._message, ";");
            if (tokenizer.countTokens() < 5) {
                System.err.println("Not enough tokens in message:\n" + this._message);
                return;
            }
            String auvHost = null;
            String login = null;
            String passwd = null;
            String survey = null;
            String file = null;
            int nToken = 0;
            block8: while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                switch (nToken++) {
                    case 0: {
                        auvHost = token;
                        continue block8;
                    }
                    case 1: {
                        login = token;
                        continue block8;
                    }
                    case 2: {
                        passwd = token;
                        continue block8;
                    }
                    case 3: {
                        survey = token;
                        continue block8;
                    }
                }
                file = token.trim();
                try {
                    this.retrieveFromAUV(auvHost, login, passwd, file);
                    File remoteFile = new File(file);
                    String fileName = remoteFile.getName();
                    this.unpackTarball(survey, fileName);
                    String missionName = this.getMissionName(fileName);
                    this.copyToArchive(survey, missionName);
                    this.notifySSDS(survey, missionName);
                }
                catch (Exception e) {
                    System.out.println(e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }

        void copy(File src, File dst) throws IOException {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
            int b = 0;
            while ((b = in.read()) > -1) {
                out.write(b);
            }
            in.close();
            out.close();
        }

        void copyToArchive(String survey, String mission) throws IOException {
            File localMissionDir = new File(new File(AUVPortalService.this.localDir, survey), mission);
            File remoteMissionDir = new File(new File(AUVPortalService.this.remoteDir, survey), mission);
            if (!remoteMissionDir.exists() && !remoteMissionDir.mkdirs()) {
                throw new IOException("Unable to create the archive directory, " + remoteMissionDir.getAbsolutePath());
            }
            File[] files = localMissionDir.listFiles();
            File dst = null;
            File src = null;
            for (int i = 0; i < files.length; ++i) {
                src = files[i];
                dst = new File(remoteMissionDir, src.getName());
                System.out.print("Copying " + src + " to " + dst);
                if (dst.exists()) {
                    System.out.println(" [WARNING!! Overwriting existing file]");
                } else {
                    System.out.println();
                }
                this.copy(src, dst);
            }
        }

        String getMissionName(String tarballName) throws IOException {
            File tarFile = new File(AUVPortalService.this.localDir, tarballName);
            InputStream in = new FileInputStream(tarFile);
            if (tarballName.endsWith(".gz") || tarballName.endsWith(".tgz")) {
                in = new GZIPInputStream(in);
            }
            TarInputStream tis = new TarInputStream(in);
            TarEntry te = tis.getNextEntry();
            while (te != null && !te.isDirectory()) {
                te = tis.getNextEntry();
            }
            tis.close();
            String missionName = null;
            if (te == null) {
                throw new IOException("The file, " + tarFile.getAbsolutePath() + "does not contain a mission directory.");
            }
            missionName = te.getName();
            return missionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifySSDS(String survey, String mission) throws Exception {
            if (AUVPortalService.this.xmlPublisher.isConnected()) {
                File missionDir = new File(new File(AUVPortalService.this.remoteDir, survey), mission);
                URL missionUrl = new URL(AUVPortalService.this.remoteUrl.getProtocol(), AUVPortalService.this.remoteUrl.getHost(), AUVPortalService.this.remoteUrl.getPort(), AUVPortalService.this.remoteUrl.getPath() + "/" + survey + "/" + mission);
                System.out.println(missionUrl);
                AUVXMLFactory xmlFactory = new AUVXMLFactory(missionDir, missionUrl);
                XMLPublisher xMLPublisher = AUVPortalService.this.xmlPublisher;
                synchronized (xMLPublisher) {
                    AUVPortalService.this.xmlPublisher.setXmlFactory(xmlFactory);
                    System.out.println("Attempting to publish " + missionDir.getAbsolutePath() + " to SSDS.");
                    AUVPortalService.this.xmlPublisher.publish();
                    System.out.println(" SUCCESS!! published " + missionDir.getAbsolutePath() + " to SSDS");
                }
            } else {
                throw new Exception("FAILED!! Unable to contact SSDS.");
            }
        }

        void retrieveFromAUV(String auvHost, String login, String passwd, String fileName) throws IOException, FTPException {
            System.out.println("Retrieve mission files from AUV host:");
            System.out.println(auvHost + ": " + fileName);
            File remoteFile = new File(fileName);
            File file = new File(AUVPortalService.this.localDir, remoteFile.getName());
            FTPClient ftpClient = new FTPClient(auvHost);
            ftpClient.user(login);
            ftpClient.password(passwd);
            ftpClient.setType(FTPTransferType.BINARY);
            if (file.exists()) {
                System.out.println("Retrieving " + fileName + " [WARNING!! Overwriting existing file]");
            } else {
                System.out.println("Retrieving " + fileName);
            }
            ftpClient.get(file.getName(), fileName.trim());
            System.out.println("All done");
            ftpClient.quit();
        }

        void unpackTarball(String survey, String tarballName) throws IOException {
            File dstDir = new File(AUVPortalService.this.localDir, survey);
            if (!dstDir.exists() && !dstDir.mkdirs()) {
                throw new IOException("Unable to create the directory " + dstDir.getAbsolutePath());
            }
            File tarFile = new File(AUVPortalService.this.localDir, tarballName);
            InputStream in = new FileInputStream(tarFile);
            if (tarballName.endsWith(".gz") || tarballName.endsWith(".tgz")) {
                in = new GZIPInputStream(in);
            }
            System.out.println("Unpacking " + tarFile.getAbsolutePath());
            TarArchive archive = new TarArchive(in);
            archive.setKeepOldFiles(false);
            archive.extractContents(dstDir);
            archive.closeArchive();
        }
    }

    public class WorkerThread2
    extends WorkerThread {
        public WorkerThread2(String message) {
            super(message);
        }

        public void run() {
            System.out.println("processConnection() got message:\n" + this._message);
            StringTokenizer tokenizer = new StringTokenizer(this._message, ";");
            if (tokenizer.countTokens() < 2) {
                System.err.println("Not enough tokens in message:\n" + this._message);
                return;
            }
            String survey = null;
            String file = null;
            int nToken = 0;
            block5: while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                switch (nToken++) {
                    case 0: {
                        survey = token;
                        continue block5;
                    }
                }
                file = token;
                try {
                    this.unpackTarball(survey, file);
                    String missionName = this.getMissionName(file);
                    this.copyToArchive(survey, missionName);
                    this.notifySSDS(survey, missionName);
                }
                catch (Exception e) {
                    System.out.println(e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

