/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.portal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import moos.operations.portal.auvctd.AUVXMLFactory;
import moos.operations.portal.ssds.XMLPublisher;

public class AUVLoader {
    private final FilenameFilter filter;
    XMLPublisher publisher;
    File archiveRoot;
    String httpRoot;
    String httpSSDS;

    public AUVLoader(String archiveRoot) throws IOException {
        this.archiveRoot = new File(archiveRoot);
        this.filter = new FilenameFilter(){

            public boolean accept(File someDir, String someName) {
                return someName.equalsIgnoreCase("vehicle.cfg");
            }
        };
        ResourceBundle rb = ResourceBundle.getBundle("auvportal");
        this.httpRoot = rb.getString("remote.url");
        this.httpSSDS = rb.getString("ssds.data.url");
        String topic = rb.getString("jms.topic");
        this.publisher = new XMLPublisher(topic);
    }

    public void start() throws MalformedURLException, InterruptedException {
        this.processDir(this.archiveRoot);
    }

    private void processDir(File dir) throws MalformedURLException, InterruptedException {
        System.out.println("Peeking into " + dir);
        File[] fs = dir.listFiles();
        if (fs != null) {
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i].isHidden() || !fs[i].isDirectory()) continue;
                File[] ls = fs[i].listFiles(this.filter);
                if (ls.length > 0) {
                    System.out.println("Found " + ls[0]);
                    this.processMission(fs[i]);
                }
                this.processDir(fs[i]);
            }
        } else {
            System.out.println("Nothing found in " + dir);
        }
    }

    private synchronized void processMission(File missionDir) throws MalformedURLException, InterruptedException {
        System.out.print("Processing " + missionDir);
        String md = missionDir.getAbsolutePath();
        int idx = this.archiveRoot.getAbsolutePath().length();
        URL missionURL = new URL(this.httpRoot + md.substring(idx));
        System.out.println(" using " + missionURL);
        System.out.println("Calling AUVXMLFactory(" + missionDir.getAbsolutePath() + ", " + missionURL + ")");
        AUVXMLFactory factory = new AUVXMLFactory(missionDir, missionURL);
        this.publisher.setXmlFactory(factory);
        System.out.print("Attempting to publish....");
        this.publisher.publish();
        System.out.println("published");
    }

    public static void main(String[] args) throws IOException, MalformedURLException, InterruptedException {
        AUVLoader loader = new AUVLoader(args[0]);
        loader.start();
    }
}

