/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import moos.ssds.model.DataContainer;
import moos.ssds.model.DataFile;
import moos.ssds.model.Deployment;
import moos.ssds.model.Device;
import moos.ssds.model.HeaderDescription;
import moos.ssds.model.Person;
import moos.ssds.model.RecordDescription;
import moos.ssds.model.RecordVariable;
import moos.ssds.model.Resource;
import moos.ssds.model.XmlBuilder;

public class XMLMockup {
    int id;
    File dir;
    URL baseURL;
    XmlBuilder xmlBuilder = new XmlBuilder();
    Properties auvProps = new Properties();

    public XMLMockup(File dir) throws MalformedURLException {
        this(dir, dir.toURL());
    }

    public XMLMockup(File dir, URL url) throws MalformedURLException {
        this.dir = dir;
        this.baseURL = url;
        this.id = (int)Math.round(Math.random() * 100000.0);
        try {
            this.auvProps.load(new FileInputStream(new File(dir, "vehicle.cfg")));
            Deployment dp = this.makeDeployment();
            this.xmlBuilder.addDeployment(dp);
            File[] logs = this.getLogs();
            File log = null;
            Deployment di = null;
            for (int i = 0; i < logs.length; ++i) {
                log = logs[i];
                di = this.makeDeployment(log);
                dp.addChildDeployment(di);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XmlBuilder getXmlBuilder() {
        return this.xmlBuilder;
    }

    private Deployment makeDeployment(File log) throws MalformedURLException, FileNotFoundException, IOException {
        Deployment d = new Deployment();
        d.setRole("instrument");
        d.setDescription("**** Mockup deployment information for " + log.getName() + " ****");
        Device inst = new Device(this.getDeviceId());
        int ext = log.getName().indexOf(46);
        inst.setName(log.getName().substring(0, ext));
        inst.setDescription("**** Mockup instrument ****");
        d.setDevice(inst);
        DataFile out = new DataFile();
        out.setName(log.getName());
        out.setDescription("**** Mockup instrument information for " + log.getName() + " ****");
        out.setUrl(this.makeURL(log));
        out.setOriginal(true);
        d.addOutput((DataContainer)out);
        HeaderDescription hd = new HeaderDescription();
        hd.addCommentTag("#");
        out.setHeaderDescription(hd);
        RecordDescription rd = new RecordDescription();
        rd.setBufferStyle("binary");
        rd.setBufferLengthType("fixed");
        rd.setEndian("little");
        rd.setParseable(true);
        out.setRecordDescription(rd);
        BufferedReader in = new BufferedReader(new FileReader(log));
        String line = null;
        line = in.readLine();
        int i = 0;
        RecordVariable v = null;
        StringTokenizer st = null;
        String format = null;
        String units = null;
        String longName = null;
        String name = null;
        line = in.readLine();
        while (line != null && !line.startsWith("# begin")) {
            ++i;
            st = new StringTokenizer(line);
            st.nextToken();
            format = st.nextToken();
            name = st.nextToken();
            if (format.equals("timeTag")) {
                format = "double";
                units = "seconds since 1970-01-01 00:00:00";
                longName = "Time (GMT)";
            } else if (format.equals("angle")) {
                format = "double";
                units = "**** degrees ****";
                longName = name;
            } else {
                units = "**** UNKNOWN ****";
                longName = name;
            }
            v = new RecordVariable();
            v.setFormat(format);
            v.setName(name);
            v.setLongName(longName);
            v.setUnits(units);
            v.setColumnIndex((long)i);
            rd.addRecordVariable(v);
            line = in.readLine();
        }
        in.close();
        return d;
    }

    private URL makeURL(File file) throws MalformedURLException {
        String path = this.baseURL.getFile();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + file.getName();
        return new URL(this.baseURL.getProtocol(), this.baseURL.getHost(), path);
    }

    private Deployment makeDeployment() throws MalformedURLException {
        Deployment d = new Deployment();
        d.setRole("platform");
        d.setName(this.dir.getName());
        d.setDescription("**** Mockup of an AUV mission generated from " + this.dir.getName() + " ****");
        d.setStartDate(new Date(0L));
        d.setEndDate(new Date());
        d.setContact(this.makeMissionContact());
        Device auv = new Device(this.getDeviceId());
        auv.setDescription("**** Mockup AUV ****");
        auv.setName(this.auvProps.getProperty("vehicleName"));
        auv.setMfgName("**** MBARI ****");
        d.setDevice(auv);
        File[] resrcs = this.getResources();
        Resource r = null;
        for (int i = 0; i < resrcs.length; ++i) {
            r = new Resource();
            r.setName(resrcs[i].getName());
            r.setDescription("**** A resource in search of a description ****");
            r.setUrl(this.makeURL(resrcs[i]));
            d.addResource(r);
        }
        return d;
    }

    private Person makeMissionContact() {
        Person person = new Person();
        person.setFirstname("Brian");
        person.setSurname("Schlining");
        person.setEmail("brian@mbari.org");
        return person;
    }

    private File[] getResources() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File someDir, String someName) {
                return !someName.endsWith(".log") && !someName.endsWith(".m");
            }
        };
        return this.dir.listFiles(filter);
    }

    private File[] getLogs() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File someDir, String someName) {
                return someName.endsWith(".log");
            }
        };
        return this.dir.listFiles(filter);
    }

    private Long getDeviceId() {
        return new Long(this.id++);
    }

    public static void main(String[] args) {
        try {
            XMLMockup mockup = args.length == 1 ? new XMLMockup(new File(args[0])) : new XMLMockup(new File(args[0]), new URL(args[1]));
            XmlBuilder xb = mockup.getXmlBuilder();
            xb.marshal();
            xb.print();
        }
        catch (Exception e) {
            System.out.println("Usage: java example.XMLMockup someAuvDataDir");
        }
    }
}

