/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.XMLMockup;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import moos.ssds.jms.Publisher;
import moos.ssds.model.DataPacket;
import moos.ssds.model.Deployment;
import moos.ssds.model.XmlBuilder;

public class AUVPortal {
    XmlBuilder xmlBuilder;
    Publisher publisher = new Publisher("topic/testTopic");

    public AUVPortal(File dir) throws MalformedURLException {
        this(dir, dir.toURL());
    }

    public AUVPortal(File dir, URL url) throws MalformedURLException {
        XMLMockup xmlMockup = new XMLMockup(dir, url);
        this.xmlBuilder = xmlMockup.getXmlBuilder();
    }

    public void contactSSDS() throws IOException {
        this.xmlBuilder.marshal();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.xmlBuilder.print();
        this.xmlBuilder.print((OutputStream)buf);
        Collection rootElements = this.xmlBuilder.getRootElements();
        Iterator iterator = rootElements.iterator();
        Deployment deployment = (Deployment)iterator.next();
        long id = deployment.getDevice().getId();
        DataPacket packet = new DataPacket(0L, buf.size());
        packet.setSequenceNo(0L);
        packet.setMetadataId(0L);
        packet.setPlatformId(id);
        packet.setRecordType(0L);
        packet.setSystemTime(new Date().getTime());
        packet.setDataBuffer(buf.toByteArray());
        this.publisher.publish((Serializable)packet);
    }

    public static void main(String[] args) {
        try {
            AUVPortal portal = args.length == 1 ? new AUVPortal(new File(args[0])) : new AUVPortal(new File(args[0]), new URL(args[1]));
            portal.contactSSDS();
        }
        catch (Exception e) {
            System.out.println("Usage: java example.AUVPortal missionDirectory webRoot");
        }
    }
}

