/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPDataSocket {
    private ServerSocket activeSocket = null;
    private Socket passiveSocket = null;

    FTPDataSocket(ServerSocket serverSocket) {
        this.activeSocket = serverSocket;
    }

    FTPDataSocket(Socket socket) {
        this.passiveSocket = socket;
    }

    void close() throws IOException {
        if (this.passiveSocket != null) {
            this.passiveSocket.close();
        }
        if (this.activeSocket != null) {
            this.activeSocket.close();
        }
    }

    InputStream getInputStream() throws IOException {
        if (this.passiveSocket != null) {
            return this.passiveSocket.getInputStream();
        }
        this.passiveSocket = this.activeSocket.accept();
        return this.passiveSocket.getInputStream();
    }

    OutputStream getOutputStream() throws IOException {
        if (this.passiveSocket != null) {
            return this.passiveSocket.getOutputStream();
        }
        this.passiveSocket = this.activeSocket.accept();
        return this.passiveSocket.getOutputStream();
    }

    void setTimeout(int n) throws IOException {
        if (this.passiveSocket != null) {
            this.passiveSocket.setSoTimeout(n);
        } else if (this.activeSocket != null) {
            this.activeSocket.setSoTimeout(n);
        }
    }
}

