/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FTPClient {
    private static String cvsId = "$Id: FTPClient.java,v 1.3 2001/10/09 20:53:46 bruceb Exp $";
    private FTPControlSocket control = null;
    private FTPDataSocket data = null;
    private int timeout = 0;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;

    public FTPClient(String string) throws IOException, FTPException {
        this.control = new FTPControlSocket(string);
    }

    public FTPClient(String string, int n) throws IOException, FTPException {
        this.control = new FTPControlSocket(string, n);
    }

    public FTPClient(InetAddress inetAddress) throws IOException, FTPException {
        this.control = new FTPControlSocket(inetAddress);
    }

    public FTPClient(InetAddress inetAddress, int n) throws IOException, FTPException {
        this.control = new FTPControlSocket(inetAddress, n);
    }

    public void chdir(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("CWD " + string);
        this.control.validateReply(string2, "250");
    }

    public void debugResponses(boolean bl) {
        this.control.debugResponses(bl);
    }

    public void delete(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("DELE " + string);
        this.control.validateReply(string2, "250");
    }

    public String[] dir(String string) throws IOException, FTPException {
        return this.dir(string, false);
    }

    public String[] dir(String string, boolean bl) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string2 = bl ? "LIST " : "NLST ";
        string2 = String.valueOf(string2) + string;
        string2 = string2.trim();
        String string3 = this.control.sendCommand(string2);
        String[] stringArray = new String[]{"125", "150"};
        this.control.validateReply(string3, stringArray);
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        Vector<String> vector = new Vector<String>();
        String string4 = null;
        while ((string4 = lineNumberReader.readLine()) != null) {
            vector.add(string4);
        }
        try {
            lineNumberReader.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        String[] stringArray2 = new String[]{"226", "250"};
        string3 = this.control.readReply();
        this.control.validateReply(string3, stringArray2);
        return vector.toArray(new String[0]);
    }

    public byte[] get(String string) throws IOException, FTPException {
        int n;
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string2 = this.control.sendCommand("RETR " + string);
        String[] stringArray = new String[]{"125", "150"};
        this.control.validateReply(string2, stringArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = null;
        int n3 = 0;
        while ((n = bufferedInputStream.read(byArray, 0, n2)) >= 0) {
            byArray3 = new byte[n3 + n];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            System.arraycopy(byArray, 0, byArray3, n3, n);
            byArray2 = byArray3;
            n3 += n;
        }
        try {
            bufferedInputStream.close();
            this.data.close();
        }
        catch (IOException iOException) {}
        String[] stringArray2 = new String[]{"226", "250"};
        string2 = this.control.readReply();
        this.control.validateReply(string2, stringArray2);
        return byArray2;
    }

    public void get(String string, String string2) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.getASCII(string, string2);
        } else {
            this.getBinary(string, string2);
        }
        String[] stringArray = new String[]{"226", "250"};
        String string3 = this.control.readReply();
        this.control.validateReply(string3, stringArray);
    }

    private void getASCII(String string, String string2) throws IOException, FTPException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        this.initGet(string2);
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
        String string3 = null;
        while ((string3 = lineNumberReader.readLine()) != null) {
            bufferedWriter.write(string3, 0, string3.length());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        try {
            lineNumberReader.close();
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    private void getBinary(String string, String string2) throws IOException, FTPException {
        int n;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string, false));
        this.initGet(string2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        while ((n = bufferedInputStream.read(byArray, 0, n2)) >= 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        try {
            bufferedInputStream.close();
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    private void initGet(String string) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string2 = this.control.sendCommand("RETR " + string);
        String[] stringArray = new String[]{"125", "150"};
        this.control.validateReply(string2, stringArray);
    }

    private void initPut(String string, boolean bl) throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
        String string2 = bl ? "APPE " : "STOR ";
        String string3 = this.control.sendCommand(String.valueOf(string2) + string);
        String[] stringArray = new String[]{"125", "150"};
        this.control.validateReply(string3, stringArray);
    }

    public void initSOCKS(String string, String string2) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("socksProxyPort", string);
        ((Hashtable)properties).put("socksProxyHost", string2);
        System.setProperties(properties);
    }

    public String list(String string) throws IOException, FTPException {
        return this.list(string, false);
    }

    public String list(String string, boolean bl) throws IOException, FTPException {
        String[] stringArray = this.dir(string, bl);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void login(String string, String string2) throws IOException, FTPException {
        String string3 = this.control.sendCommand("USER " + string);
        this.control.validateReply(string3, "331");
        string3 = this.control.sendCommand("PASS " + string2);
        this.control.validateReply(string3, "230");
    }

    public void mkdir(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("MKD " + string);
        this.control.validateReply(string2, "257");
    }

    public void password(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("PASS " + string);
        String[] stringArray = new String[]{"230", "202"};
        this.control.validateReply(string2, stringArray);
    }

    public void put(String string, String string2) throws IOException, FTPException {
        this.put(string, string2, false);
    }

    public void put(String string, String string2, boolean bl) throws IOException, FTPException {
        if (this.getType() == FTPTransferType.ASCII) {
            this.putASCII(string, string2, bl);
        } else {
            this.putBinary(string, string2, bl);
        }
        String[] stringArray = new String[]{"226", "250"};
        String string3 = this.control.readReply();
        this.control.validateReply(string3, stringArray);
    }

    public void put(byte[] byArray, String string) throws IOException, FTPException {
        this.put(byArray, string, false);
    }

    public void put(byte[] byArray, String string, boolean bl) throws IOException, FTPException {
        this.initPut(string, bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
        String[] stringArray = new String[]{"226", "250"};
        String string2 = this.control.readReply();
        this.control.validateReply(string2, stringArray);
    }

    private void putASCII(String string, String string2, boolean bl) throws IOException, FTPException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        this.initPut(string2, bl);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.data.getOutputStream()));
        String string3 = null;
        while ((string3 = lineNumberReader.readLine()) != null) {
            bufferedWriter.write(string3, 0, string3.length());
            bufferedWriter.write("\r\n", 0, "\r\n".length());
        }
        lineNumberReader.close();
        bufferedWriter.flush();
        bufferedWriter.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    private void putBinary(String string, String string2, boolean bl) throws IOException, FTPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        this.initPut(string2, bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()));
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        try {
            this.data.close();
        }
        catch (IOException iOException) {}
    }

    public String pwd() throws IOException, FTPException {
        String string = this.control.sendCommand("PWD");
        this.control.validateReply(string, "257");
        return string.substring(4);
    }

    public void quit() throws IOException, FTPException {
        String string = this.control.sendCommand("QUIT\r\n");
        this.control.validateReply(string, "221");
        this.control.logout();
        this.control = null;
    }

    public void quote(String string, String[] stringArray) throws IOException, FTPException {
        String string2 = this.control.sendCommand(string);
        if (stringArray != null && stringArray.length > 0) {
            this.control.validateReply(string2, stringArray);
        }
    }

    public void rename(String string, String string2) throws IOException, FTPException {
        String string3 = this.control.sendCommand("RNFR " + string);
        this.control.validateReply(string3, "350");
        string3 = this.control.sendCommand("RNTO " + string2);
        this.control.validateReply(string3, "250");
    }

    public void rmdir(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("RMD " + string);
        this.control.validateReply(string2, "250");
    }

    public void setConnectMode(FTPConnectMode fTPConnectMode) {
        this.connectMode = fTPConnectMode;
    }

    public void setTimeout(int n) throws IOException {
        this.timeout = n;
        this.control.setTimeout(n);
    }

    public void setType(FTPTransferType fTPTransferType) throws IOException, FTPException {
        String string = FTPTransferType.ASCII_CHAR;
        if (fTPTransferType.equals(FTPTransferType.BINARY)) {
            string = FTPTransferType.BINARY_CHAR;
        }
        String string2 = this.control.sendCommand("TYPE " + string);
        this.control.validateReply(string2, "200");
        this.transferType = fTPTransferType;
    }

    public boolean site(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("SITE " + string);
        String[] stringArray = new String[]{"200", "202", "502"};
        this.control.validateReply(string2, stringArray);
        return string2.substring(0, 3).equals("200");
    }

    public String system() throws IOException, FTPException {
        String string = this.control.sendCommand("SYST");
        this.control.validateReply(string, "215");
        return string.substring(4);
    }

    public void user(String string) throws IOException, FTPException {
        String string2 = this.control.sendCommand("USER " + string);
        String[] stringArray = new String[]{"230", "331"};
        this.control.validateReply(string2, stringArray);
    }
}

