/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Document;
import nu.xom.NodeList;
import nu.xom.xslt.XOMResult;
import nu.xom.xslt.XOMSource;
import nu.xom.xslt.XSLException;

public final class XSLTransform {
    private Templates templates;

    private XSLTransform(Source source) throws XSLException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            this.templates = factory.newTemplates(source);
        }
        catch (TransformerFactoryConfigurationError error) {
            throw new XSLException("Could not locate a TrAX TransformerFactory", error);
        }
        catch (TransformerConfigurationException ex) {
            throw new XSLException("Syntax error in stylesheet", ex);
        }
    }

    public XSLTransform(InputStream stylesheet) throws XSLException {
        this(new StreamSource(stylesheet));
    }

    public XSLTransform(Reader stylesheet) throws XSLException {
        this(new StreamSource(stylesheet));
    }

    public XSLTransform(File stylesheet) throws XSLException {
        this(new StreamSource(stylesheet));
    }

    public XSLTransform(Document stylesheet) throws XSLException {
        this(new XOMSource(stylesheet));
    }

    public XSLTransform(String systemID) throws XSLException {
        this(new StreamSource(systemID));
    }

    public NodeList transform(Document in) throws XSLException {
        return this.transform(new XOMSource(in));
    }

    public NodeList transform(NodeList in) throws XSLException {
        return this.transform(new XOMSource(in));
    }

    private NodeList transform(Source in) throws XSLException {
        try {
            XOMResult out = new XOMResult();
            Transformer transformer = this.templates.newTransformer();
            transformer.transform(in, out);
            return out.getResult();
        }
        catch (TransformerException ex) {
            throw new XSLException("XSLT Transformation failed", ex);
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.templates + "]";
    }
}

