/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.NodeList;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class XSLTHandler
implements ContentHandler,
LexicalHandler {
    private NodeList result;
    private Stack parents;
    private NodeFactory factory;
    private Map prefixes;
    private StringBuffer buffer;

    XSLTHandler(NodeFactory factory) {
        if (factory == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        this.factory = factory;
        this.reset();
    }

    NodeList getResult() {
        return this.result;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
        this.reset();
    }

    public void reset() {
        this.result = new NodeList();
        this.parents = new Stack();
        this.buffer = new StringBuffer();
        this.prefixes = new HashMap();
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        this.flushText();
        Element element = this.factory.makeElement(qualifiedName, namespaceURI);
        if (this.parents.isEmpty()) {
            this.result.append(element);
        } else {
            ParentNode parent = (ParentNode)this.parents.peek();
            parent.appendChild(element);
        }
        this.parents.push(element);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            if (attributeName.equals("xmlns") || attributeName.startsWith("xmlns:")) continue;
            String namespace = attributes.getURI(i);
            String value = attributes.getValue(i);
            Attribute attribute = this.factory.makeAttribute(attributeName, namespace, value, this.getType(attributes.getType(i)));
            element.addAttribute(attribute);
        }
        Iterator iterator = this.prefixes.keySet().iterator();
        while (iterator.hasNext()) {
            String prefix = (String)iterator.next();
            String currentURI = element.getNamespaceURI(prefix);
            String newURI = (String)((Stack)this.prefixes.get(prefix)).peek();
            if (newURI.equals(currentURI) || prefix.equals("")) continue;
            element.addNamespaceDeclaration(prefix, newURI);
        }
    }

    private Attribute.Type getType(String saxType) {
        if (saxType.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (saxType.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (saxType.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (saxType.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (saxType.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (saxType.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (saxType.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (saxType.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (saxType.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (saxType.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (saxType.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.flushText();
        this.parents.pop();
    }

    public void characters(char[] text, int start, int length) {
        this.buffer.append(text, start, length);
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            Text data = this.factory.makeText(this.buffer.toString());
            if (this.parents.isEmpty()) {
                this.result.append(data);
            } else {
                ParentNode parent = (ParentNode)this.parents.peek();
                parent.appendChild(data);
            }
            this.buffer.setLength(0);
        }
    }

    public void ignorableWhitespace(char[] text, int start, int length) {
        this.characters(text, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushText();
        if ("saxon:warning".equals(target)) {
            throw new SAXException("continue");
        }
        ProcessingInstruction instruction = this.factory.makeProcessingInstruction(target, data);
        if (this.parents.isEmpty()) {
            this.result.append(instruction);
        } else {
            ParentNode parent = (ParentNode)this.parents.peek();
            parent.appendChild(instruction);
        }
    }

    public void endPrefixMapping(String prefix) {
        Stack uris = (Stack)this.prefixes.get(prefix);
        uris.pop();
    }

    public void startPrefixMapping(String prefix, String uri) {
        Stack<String> uris;
        if (uri == null) {
            uri = "";
        }
        if ((uris = (Stack<String>)this.prefixes.get(prefix)) == null) {
            uris = new Stack<String>();
            this.prefixes.put(prefix, uris);
        }
        if (uris.isEmpty()) {
            uris.push(uri);
        } else {
            String current = (String)uris.peek();
            if (!uri.equals(current)) {
                uris.push(uri);
            }
        }
    }

    public void skippedEntity(String name) {
        this.flushText();
        throw new XMLException("Could not resolve entity " + name);
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String name, String publicID, String systemID) {
    }

    public void endDTD() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void comment(char[] text, int start, int length) {
        this.flushText();
        Comment comment = this.factory.makeComment(new String(text, start, length));
        if (this.parents.isEmpty()) {
            this.result.append(comment);
        } else {
            ParentNode parent = (ParentNode)this.parents.peek();
            parent.appendChild(comment);
        }
    }
}

