/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.IllegalNameException;
import nu.xom.Node;
import nu.xom.NodeList;
import nu.xom.ParentNode;
import nu.xom.xinclude.XPointerSyntaxException;

class XPointer {
    XPointer() {
    }

    public static NodeList resolve(Document doc, String xptr) throws XPointerSyntaxException {
        try {
            xptr = XPointer.decode(xptr);
            NodeList result = new NodeList();
            try {
                new Element(xptr);
                Element identified = XPointer.findByID(doc.getRootElement(), xptr);
                if (identified != null) {
                    result.append(identified);
                }
                return result;
            }
            catch (IllegalNameException ex) {
                List elementSchemeData = XPointer.findElementSchemeData(xptr);
                if (elementSchemeData.size() == 0) {
                    throw new XPointerSyntaxException("No supported XPointer schemes found");
                }
                for (int i = 0; i < elementSchemeData.size(); ++i) {
                    String currentData = (String)elementSchemeData.get(i);
                    int[] keys = new int[]{};
                    ParentNode current = doc;
                    if (currentData.indexOf(47) == -1) {
                        try {
                            new Element(currentData);
                        }
                        catch (IllegalNameException ex2) {
                            throw new XPointerSyntaxException("bad element scheme data " + elementSchemeData);
                        }
                        Element identified = XPointer.findByID(doc.getRootElement(), currentData);
                        if (identified != null) {
                            result.append(identified);
                            return result;
                        }
                    } else if (!currentData.startsWith("/")) {
                        String id = currentData.substring(0, currentData.indexOf(47));
                        current = XPointer.findByID(doc.getRootElement(), id);
                        keys = XPointer.split(currentData.substring(currentData.indexOf(47)));
                    } else {
                        keys = XPointer.split(currentData);
                    }
                    for (int j = 0; j < keys.length && (current = XPointer.findNthChildElement(current, keys[j])) != null; ++j) {
                    }
                    if (current == null) continue;
                    result.append(current);
                    return result;
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            XPointerSyntaxException ex2 = new XPointerSyntaxException(xptr + " is not a syntactically correct XPointer");
            ex2.setRootCause(ex);
            throw ex2;
        }
        catch (NumberFormatException ex) {
            XPointerSyntaxException ex2 = new XPointerSyntaxException(xptr + " is not a syntactically correct XPointer");
            ex2.setRootCause(ex);
            throw ex2;
        }
        throw new XPointerSyntaxException("XPointer " + xptr + " did not locate any nodes in the document " + doc.getBaseURI());
    }

    private static Element findNthChildElement(ParentNode parent, int position) {
        int elementCount = 1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node child = parent.getChild(i);
            if (!(child instanceof Element)) continue;
            if (elementCount == position) {
                return (Element)child;
            }
            ++elementCount;
        }
        return null;
    }

    private static int[] split(String tumbler) {
        int numberOfParts = 0;
        for (int i = 0; i < tumbler.length(); ++i) {
            if (tumbler.charAt(i) != '/') continue;
            ++numberOfParts;
        }
        int[] result = new int[numberOfParts];
        int index = 0;
        StringBuffer part = new StringBuffer(3);
        for (int i = 1; i < tumbler.length(); ++i) {
            if (tumbler.charAt(i) == '/') {
                result[index] = Integer.parseInt(part.toString());
                ++index;
                part = new StringBuffer(3);
                continue;
            }
            part.append(tumbler.charAt(i));
        }
        result[result.length - 1] = Integer.parseInt(part.toString());
        return result;
    }

    private static List findElementSchemeData(String xpointer) throws XPointerSyntaxException {
        char c;
        int i;
        ArrayList<String> result = new ArrayList<String>(1);
        Object firstElementSchemeData = null;
        StringBuffer xptr = new StringBuffer(xpointer.trim());
        StringBuffer scheme = new StringBuffer();
        for (i = 0; i < xptr.length() && (c = xptr.charAt(i)) != '('; ++i) {
            scheme.append(c);
        }
        try {
            new Element(scheme.toString(), "http://www.example.com/");
        }
        catch (IllegalNameException ex) {
            throw new XPointerSyntaxException(ex.getMessage());
        }
        int open = 1;
        ++i;
        StringBuffer schemeData = new StringBuffer();
        while (open > 0) {
            char c2 = xptr.charAt(i);
            if (c2 == '^') {
                c2 = xptr.charAt(i + 1);
                schemeData.append(c2);
                if (c2 != '^' && c2 != '(' && c2 != ')') {
                    throw new XPointerSyntaxException("Illegal XPointer escape sequence");
                }
                ++i;
            } else if (c2 == '(') {
                schemeData.append(c2);
                ++open;
            } else if (c2 == ')') {
                if (--open > 0) {
                    schemeData.append(c2);
                }
            } else {
                schemeData.append(c2);
            }
            ++i;
        }
        if (scheme.toString().equals("element")) {
            result.add(schemeData.toString());
        }
        if (i + 1 < xptr.length()) {
            result.addAll(XPointer.findElementSchemeData(xptr.substring(i)));
        }
        return result;
    }

    public static Element findByID(Element element, String id) {
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute att = element.getAttribute(i);
            if (att.getType() != Attribute.Type.ID || !att.getValue().trim().equals(id)) continue;
            return element;
        }
        Elements children = element.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            Element result = XPointer.findByID(children.get(i), id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static String decode(String xptr) {
        StringBuffer result = new StringBuffer(xptr);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (c != '%') continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (c == '%') {
                result.deleteCharAt(i);
                String hex = result.substring(i, i + 2);
                byte character = (byte)Integer.parseInt(hex, 16);
                out.write(character);
                result.deleteCharAt(i);
                result.deleteCharAt(i);
                c = result.charAt(i);
            }
            byte[] raw = out.toByteArray();
            try {
                String data = new String(raw, "UTF-8");
                result.insert(i, data);
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Broken VM does not support UTF-8");
            }
        }
        return result.toString();
    }
}

