/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.IOException;
import java.io.InputStream;

class EncodingHeuristics {
    private EncodingHeuristics() {
    }

    public static String readEncodingFromStream(InputStream in) throws IOException {
        in.mark(1024);
        try {
            int byte1 = in.read();
            int byte2 = in.read();
            if (byte1 == 254 && byte2 == 255) {
                return "UnicodeBig";
            }
            if (byte1 == 255 && byte2 == 254) {
                return "UnicodeLittle";
            }
            int byte3 = in.read();
            if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
                return "UTF-8";
            }
            int byte4 = in.read();
            if (byte1 == 0 && byte2 == 0 && byte3 == 254 && byte4 == 255) {
                return "UTF32BE";
            }
            if (byte1 == 0 && byte2 == 0 && byte3 == 255 && byte4 == 254) {
                return "UTF32LE";
            }
            if (byte1 == 0 && byte2 == 0 && byte3 == 0 && byte4 == 60) {
                in.reset();
                return "UTF32BE";
            }
            if (byte1 == 60 && byte2 == 0 && byte3 == 0 && byte4 == 0) {
                in.reset();
                return "UTF32LE";
            }
            if (byte1 == 0 && byte2 == 60 && byte3 == 0 && byte4 == 63) {
                in.reset();
                return "UnicodeBigUnmarked";
            }
            if (byte1 == 60 && byte2 == 0 && byte3 == 63 && byte4 == 0) {
                in.reset();
                return "UnicodeLittleUnmarked";
            }
            if (byte1 == 60 && byte2 == 63 && byte3 == 120 && byte4 == 109) {
                byte[] data = new byte[1024];
                data[0] = (byte)byte1;
                data[1] = (byte)byte2;
                data[2] = (byte)byte3;
                data[3] = (byte)byte4;
                int length = in.read(data, 4, 1020) + 4;
                String declaration = new String(data, 0, length, "8859_1");
                String encoding = EncodingHeuristics.findEncodingDeclaration(declaration);
                in.reset();
                return encoding;
            }
            if (byte1 == 76 && byte2 == 111 && byte3 == 167 && byte4 == 148) {
                int c;
                byte[] buffer = new byte[1016];
                for (int i = 0; i < buffer.length && (c = in.read()) != -1; ++i) {
                    buffer[i] = (byte)c;
                }
                in.reset();
                return EncodingHeuristics.findEncodingDeclaration(new String(buffer, "Cp037"));
            }
        }
        catch (Exception ex) {
            in.reset();
            return "UTF-8";
        }
        in.reset();
        return "UTF-8";
    }

    private static String findEncodingDeclaration(String declaration) throws IOException {
        char c;
        int position = declaration.indexOf("encoding") + 8;
        while ((c = declaration.charAt(position++)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        if (c != '=') {
            return "UTF-8";
        }
        while ((c = declaration.charAt(position++)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        char delimiter = c;
        if (delimiter != '\'' && delimiter != '\"') {
            return "UTF-8";
        }
        StringBuffer encodingName = new StringBuffer();
        while ((c = declaration.charAt(position++)) != delimiter) {
            encodingName.append(c);
        }
        return encodingName.toString();
    }
}

