/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;

public class DOMConverter {
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document translate(org.w3c.dom.Document domDocument) {
        org.w3c.dom.Element domRoot = domDocument.getDocumentElement();
        Element xomRoot = DOMConverter.convert(domRoot);
        Document xomDocument = new Document(xomRoot);
        org.w3c.dom.Node current = domDocument.getFirstChild();
        int position = 0;
        while (current.getNodeType() != 1) {
            xomDocument.insertChild(DOMConverter.convert(current), position);
            ++position;
            current = current.getNextSibling();
        }
        for (current = current.getNextSibling(); current != null; current = current.getNextSibling()) {
            xomDocument.appendChild(DOMConverter.convert(current));
        }
        return xomDocument;
    }

    private static Node convert(org.w3c.dom.Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                return DOMConverter.convert((org.w3c.dom.Element)node);
            }
            case 8: {
                return DOMConverter.convert((org.w3c.dom.Comment)node);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node);
            }
            case 3: {
                return DOMConverter.convert((org.w3c.dom.Text)node);
            }
            case 4: {
                return DOMConverter.convert((org.w3c.dom.Text)node);
            }
            case 7: {
                return DOMConverter.convert((org.w3c.dom.ProcessingInstruction)node);
            }
        }
        return null;
    }

    private static Comment convert(org.w3c.dom.Comment comment) {
        return new Comment(comment.getNodeValue());
    }

    private static Text convert(org.w3c.dom.Text text) {
        return new Text(text.getNodeValue());
    }

    private static ProcessingInstruction convert(org.w3c.dom.ProcessingInstruction pi) {
        return new ProcessingInstruction(pi.getTarget(), pi.getNodeValue());
    }

    private static DocType convert(DocumentType doctype) {
        DocType result = new DocType(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
        return result;
    }

    private static Element convert(org.w3c.dom.Element element) {
        Element result = new Element(element.getTagName(), element.getNamespaceURI());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            if (uri.equals(XMLNS_NAMESPACE)) {
                String currentPrefix;
                String prefix;
                String name = attribute.getName();
                if (name.equals("xmlns") || (prefix = name.substring(name.indexOf(58) + 1)).equals(currentPrefix = result.getNamespaceURI(prefix))) continue;
                result.addNamespaceDeclaration(prefix, attribute.getValue());
                continue;
            }
            result.addAttribute(new Attribute(attribute.getName(), uri, attribute.getValue()));
        }
        for (org.w3c.dom.Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            result.appendChild(DOMConverter.convert(current));
        }
        return result;
    }

    public static org.w3c.dom.Document translate(Document document, DOMImplementation impl) {
        Element root = document.getRootElement();
        String rootName = root.getQualifiedName();
        String rootNamespace = root.getNamespaceURI();
        DocType doctype = document.getDocType();
        DocumentType domDOCTYPE = null;
        if (doctype != null) {
            domDOCTYPE = impl.createDocumentType(rootName, doctype.getPublicID(), doctype.getSystemID());
        }
        org.w3c.dom.Document domDoc = impl.createDocument(rootNamespace, rootName, domDOCTYPE);
        org.w3c.dom.Element domRoot = domDoc.getDocumentElement();
        boolean beforeRoot = true;
        for (int i = 0; i < document.getChildCount(); ++i) {
            Node original = document.getChild(i);
            if (original instanceof DocType) continue;
            if (original instanceof Element) {
                DOMConverter.convert((Element)original, domDoc);
                beforeRoot = false;
                continue;
            }
            org.w3c.dom.Node domNode = DOMConverter.convert(original, domDoc);
            if (beforeRoot) {
                domDoc.insertBefore(domNode, domRoot);
                continue;
            }
            domDoc.appendChild(domNode);
        }
        return domDoc;
    }

    private static org.w3c.dom.Node convert(Node node, org.w3c.dom.Document document) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        if (node instanceof Element) {
            return DOMConverter.convert((Element)node, document);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document);
        }
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static org.w3c.dom.Comment convert(Comment comment, org.w3c.dom.Document document) {
        return document.createComment(comment.getValue());
    }

    private static org.w3c.dom.Text convert(Text text, org.w3c.dom.Document document) {
        return document.createTextNode(text.getValue());
    }

    private static org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction pi, org.w3c.dom.Document document) {
        return document.createProcessingInstruction(pi.getTarget(), pi.getValue());
    }

    private static org.w3c.dom.Element convert(Element element, org.w3c.dom.Document document) {
        int i;
        String namespace = element.getNamespaceURI();
        org.w3c.dom.Element result = element.getParent() instanceof Document ? document.getDocumentElement() : (namespace.equals("") ? document.createElement(element.getQualifiedName()) : document.createElementNS(namespace, element.getQualifiedName()));
        for (i = 0; i < element.getAttributeCount(); ++i) {
            Attr attr;
            Attribute attribute = element.getAttribute(i);
            String attns = attribute.getNamespaceURI();
            if (attns.equals("")) {
                attr = document.createAttribute(attribute.getLocalName());
                result.setAttributeNode(attr);
            } else {
                attr = document.createAttributeNS(attns, attribute.getQualifiedName());
                result.setAttributeNodeNS(attr);
            }
            attr.setValue(attribute.getValue());
        }
        for (i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            Attr attr;
            Element parentElement;
            String additionalPrefix = element.getNamespacePrefix(i);
            String uri = element.getNamespaceURI(additionalPrefix);
            ParentNode parentNode = element.getParent();
            if (!(parentNode instanceof Element) ? uri.equals("") : uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix))) continue;
            if ("".equals(additionalPrefix)) {
                attr = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                result.setAttributeNodeNS(attr);
                attr.setValue(uri);
                continue;
            }
            attr = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + additionalPrefix);
            result.setAttributeNodeNS(attr);
            attr.setValue(uri);
        }
        for (i = 0; i < element.getChildCount(); ++i) {
            result.appendChild(DOMConverter.convert(element.getChild(i), document));
        }
        return result;
    }

    private static void addNamespaceAttributeIfNecessary(Element element, org.w3c.dom.Document document, org.w3c.dom.Element result, String namespace, String prefix) {
        boolean addNamespace = false;
        if (!"".equals(namespace)) {
            ParentNode parent = element.getParent();
            if (parent instanceof Document) {
                addNamespace = true;
            } else {
                Element parentElement = (Element)parent;
                if (!element.getNamespaceURI().equals(parentElement.getNamespaceURI(prefix))) {
                    addNamespace = true;
                }
            }
        }
        if (addNamespace) {
            Attr xmlns = "".equals(prefix) ? document.createAttributeNS(XMLNS_NAMESPACE, "xmlns") : document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + prefix);
            xmlns.setValue(namespace);
            result.setAttributeNodeNS(xmlns);
        }
    }
}

