/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.Writer;
import nu.xom.XMLException;

abstract class TextWriter {
    protected Writer out;
    protected String encoding;
    private String lineSeparator = "\r\n";
    private boolean lineSeparatorSet = false;
    private int maxLength = 0;
    private int indent = 0;
    private String indentString = "";
    private int column = 0;
    private boolean preserveSpace = false;
    private boolean lastCharacterWasSpace = false;
    private boolean skipFollowingLinefeed = false;
    private int fakeIndents = 0;

    protected TextWriter(Writer out, String encoding) {
        this.out = out;
        this.encoding = encoding;
    }

    public void reset() {
        this.column = 0;
        this.fakeIndents = 0;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
    }

    public final void writePCDATA(char c) throws IOException {
        if (this.needsEscaping(c)) {
            String s = "&#x" + Integer.toHexString(c) + ';';
            this.out.write(s);
            this.column += s.length();
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '&') {
            this.out.write("&amp;");
            this.column += 5;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '<') {
            this.out.write("&lt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '>') {
            this.out.write("&gt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else {
            this.write(c);
        }
    }

    public final void writeAttributeValue(char c) throws IOException {
        if (this.needsEscaping(c)) {
            String s = "&#x" + Integer.toHexString(c) + ';';
            this.out.write(s);
            this.column += s.length();
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '\"') {
            this.out.write("&quot;");
            this.column += 6;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '&') {
            this.out.write("&amp;");
            this.column += 5;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '<') {
            this.out.write("&lt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else if (c == '>') {
            this.out.write("&gt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        } else {
            this.write(c);
        }
    }

    private void write(char c) throws IOException {
        if (c == ' ' || c == '\r' || c == '\n' || c == '\t') {
            if (this.needsBreak()) {
                this.breakLine();
                this.skipFollowingLinefeed = false;
            } else if (this.preserveSpace || this.indent <= 0 && this.maxLength <= 0) {
                if (c == ' ' || c == '\t') {
                    this.out.write(c);
                    this.skipFollowingLinefeed = false;
                    ++this.column;
                } else if (c == '\r') {
                    this.writeLineSeparator(c);
                    this.skipFollowingLinefeed = true;
                    this.column = 0;
                } else if (c == '\n') {
                    if (!this.lineSeparatorSet || !this.skipFollowingLinefeed) {
                        this.writeLineSeparator(c);
                    }
                    this.skipFollowingLinefeed = false;
                    this.column = 0;
                }
            } else if (!this.lastCharacterWasSpace) {
                this.out.write(32);
                ++this.column;
                this.skipFollowingLinefeed = false;
            }
            this.lastCharacterWasSpace = true;
        } else {
            this.out.write(c);
            ++this.column;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
        }
    }

    private void writeLineSeparator(char c) throws IOException {
        if (!this.lineSeparatorSet || this.preserveSpace) {
            this.out.write(c);
        } else if (this.lineSeparator.equals("\r\n")) {
            this.out.write(13);
            this.out.write(10);
        } else if (this.lineSeparator.equals("\n")) {
            this.out.write(10);
        } else if (this.lineSeparator.equals("\r")) {
            this.out.write(13);
        }
    }

    private boolean needsBreak() {
        if (this.maxLength <= 0 || this.preserveSpace) {
            return false;
        }
        return this.column >= this.maxLength - 10;
    }

    public final void breakLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.out.write(this.indentString);
        this.column = this.indentString.length();
        this.lastCharacterWasSpace = true;
    }

    public final void writeMarkup(char c) throws IOException {
        if (this.needsEscaping(c)) {
            throw new XMLException("Cannot use the character &0x" + Integer.toHexString(c) + "; in the " + this.getEncoding() + " encoding.");
        }
        this.write(c);
    }

    public final void writePCDATA(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writePCDATA(s.charAt(i));
        }
    }

    public final void writeAttributeValue(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeAttributeValue(s.charAt(i));
        }
    }

    public final void writeMarkup(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeMarkup(s.charAt(i));
        }
    }

    public boolean isIndenting() {
        return this.indentString.length() > 0;
    }

    public void incrementIndent() {
        StringBuffer newIndent = new StringBuffer(this.indentString);
        for (int i = 0; i < this.indent; ++i) {
            newIndent.append(' ');
        }
        if (this.maxLength > 0 && newIndent.length() > this.maxLength / 2) {
            ++this.fakeIndents;
        } else {
            this.indentString = newIndent.toString();
        }
    }

    public void decrementIndent() {
        if (this.fakeIndents > 0) {
            --this.fakeIndents;
        } else {
            this.indentString = this.indentString.substring(0, this.indentString.length() - this.indent);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        if (!(lineSeparator.equals("\n") || lineSeparator.equals("\r") || lineSeparator.equals("\r\n"))) {
            throw new IllegalArgumentException("Illegal Line Separator");
        }
        this.lineSeparator = lineSeparator;
        this.lineSeparatorSet = true;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            maxLength = 0;
        }
        this.maxLength = maxLength;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public abstract boolean needsEscaping(char var1);

    public boolean isPreserveSpace() {
        return this.preserveSpace;
    }

    public void setPreserveSpace(boolean preserveSpace) {
        this.preserveSpace = preserveSpace;
    }
}

