/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import nu.xom.LeafNode;
import nu.xom.Node;
import nu.xom.Verifier;

public class Text
extends LeafNode {
    private byte[] data;

    public Text(String data) {
        this.setValue(data);
    }

    public Text(Text text) {
        this.data = new byte[text.data.length];
        System.arraycopy(text.data, 0, this.data, 0, text.data.length);
    }

    private Text() {
    }

    static Text build(String data) {
        Text result = new Text();
        if (data == null) {
            data = "";
        }
        try {
            result.data = data.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
        return result;
    }

    public final void setValue(String data) {
        if (data == null) {
            data = "";
        } else {
            Verifier.checkCharacterData(data);
        }
        this.checkValue(data);
        try {
            this.data = data.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    protected void checkValue(String data) {
    }

    public final String getValue() {
        try {
            return new String(this.data, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    public final Node copy() {
        return new Text(this);
    }

    public final String toXML() {
        return Text.escapeText(this.getValue());
    }

    private static String escapeText(String s) {
        StringBuffer result = new StringBuffer(s.length());
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block5;
                }
                case '>': {
                    result.append("&gt;");
                    continue block5;
                }
                case '&': {
                    result.append("&amp;");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public final String toString() {
        String value = this.getValue();
        if (value.length() <= 40) {
            return "[" + this.getClass().getName() + ": " + value + "]";
        }
        return "[" + this.getClass().getName() + ": " + value.substring(0, 35) + "...]";
    }
}

