/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.EBCDICWriter;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.TextWriter;
import nu.xom.TextWriterFactory;
import nu.xom.XMLException;

public class Serializer {
    private TextWriter escaper;
    private boolean preserveBaseURI = false;

    public Serializer(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("Null OutputStream");
        }
        try {
            Writer writer = new OutputStreamWriter(out, "UTF-8");
            writer = new BufferedWriter(writer);
            this.escaper = TextWriterFactory.getTextWriter(writer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (out == null) {
            throw new NullPointerException("Null OutputStream");
        }
        if (encoding == null) {
            throw new NullPointerException("Null encoding");
        }
        Writer writer = encoding.equals("IBM037") || encoding.equals("CP037") || encoding.equals("EBCDIC-CP-US") || encoding.equals("EBCDIC-CP-CA") || encoding.equals("EBCDIC-CP-WA") || encoding.equals("EBCDIC-CP-NL") || encoding.equals("CSIBM037") ? new EBCDICWriter(out) : (encoding.equals("UTF-16") || encoding.equals("ISO-10646-UCS-2") ? new OutputStreamWriter(out, "UnicodeBig") : new OutputStreamWriter(out, encoding));
        writer = new BufferedWriter(writer);
        this.escaper = TextWriterFactory.getTextWriter(writer, encoding);
    }

    public void write(Document doc) throws IOException {
        this.escaper.reset();
        this.escaper.writeMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeMarkup(this.escaper.getEncoding());
        this.escaper.writeMarkup("\"?>");
        this.escaper.breakLine();
        for (int i = 0; i < doc.getChildCount(); ++i) {
            this.write(doc.getChild(i));
            this.escaper.breakLine();
        }
        this.escaper.flush();
    }

    private int isWhiteSpaceSignificant(ParentNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof Document) {
            return -1;
        }
        Element element = (Element)node;
        String xmlSpace = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
        if ("preserve".equals(xmlSpace)) {
            return 1;
        }
        if ("default".equals(xmlSpace)) {
            return 0;
        }
        return this.isWhiteSpaceSignificant(element.getParent());
    }

    protected void write(Element element) throws IOException {
        if (this.escaper.isIndenting() && !this.escaper.isPreserveSpace()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<");
        this.escaper.writeMarkup(element.getQualifiedName());
        String prefix = element.getNamespacePrefix();
        ParentNode parent = element.getParent();
        String parentURI = "";
        if (parent instanceof Element) {
            parentURI = ((Element)parent).getNamespaceURI(prefix);
        }
        if (this.preserveBaseURI && element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null) {
            ParentNode elemParent = element.getParent();
            String baseValue = element.getBaseURI();
            if (baseValue != null && (elemParent == null || elemParent instanceof Document || !element.getBaseURI().equals(elemParent.getBaseURI()))) {
                this.escaper.writeMarkup(' ');
                this.escaper.writeMarkup("xml:base=\"");
                this.escaper.writeAttributeValue(baseValue);
                this.escaper.writeMarkup("\"");
            }
        }
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute attribute = element.getAttribute(i);
            this.escaper.writeMarkup(' ');
            this.escaper.writeMarkup(attribute.getQualifiedName());
            this.escaper.writeMarkup("=\"");
            this.escaper.writeAttributeValue(attribute.getValue());
            this.escaper.writeMarkup("\"");
        }
        ParentNode parentNode = element.getParent();
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            Element parentElement;
            String additionalPrefix = element.getNamespacePrefix(i);
            if ("xml".equals(additionalPrefix)) continue;
            String uri = element.getNamespaceURI(additionalPrefix);
            if (!(parentNode instanceof Element) ? uri.equals("") : uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix))) continue;
            if ("".equals(additionalPrefix)) {
                this.escaper.writeMarkup(" xmlns");
            } else {
                this.escaper.writeMarkup(" xmlns:");
                this.escaper.writeMarkup(additionalPrefix);
            }
            this.escaper.writeMarkup("=\"");
            this.escaper.writePCDATA(uri);
            this.escaper.writeMarkup('\"');
        }
        if (element.hasChildren()) {
            Node firstChild;
            this.escaper.writeMarkup('>');
            boolean wasPreservingWhiteSpace = this.escaper.isPreserveSpace();
            String newXMLSpaceValue = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
            if (newXMLSpaceValue != null) {
                if ("preserve".equals(newXMLSpaceValue)) {
                    this.escaper.setPreserveSpace(true);
                } else if ("default".equals(newXMLSpaceValue)) {
                    this.escaper.setPreserveSpace(false);
                }
            }
            this.escaper.incrementIndent();
            for (int i = 0; i < element.getChildCount(); ++i) {
                this.write(element.getChild(i));
            }
            this.escaper.decrementIndent();
            if (this.escaper.getIndent() > 0 && (!((firstChild = element.getChild(0)) instanceof Text) || firstChild.getValue().trim().equals(""))) {
                this.escaper.breakLine();
            }
            this.escaper.writeMarkup("</");
            this.escaper.writeMarkup(element.getQualifiedName());
            this.escaper.writeMarkup(">");
            if (newXMLSpaceValue != null) {
                this.escaper.setPreserveSpace(wasPreservingWhiteSpace);
            }
        } else {
            this.escaper.writeMarkup("/>");
        }
        this.escaper.flush();
    }

    protected void write(Comment comment) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<!--");
        this.escaper.writeMarkup(comment.getValue());
        this.escaper.writeMarkup("-->");
    }

    protected void write(ProcessingInstruction instruction) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<?");
        this.escaper.writeMarkup(instruction.getTarget());
        String value = instruction.getValue();
        if (!"".equals(value)) {
            this.escaper.writeMarkup(' ');
            this.escaper.writeMarkup(value);
        }
        this.escaper.writeMarkup("?>");
    }

    protected void write(Text text) throws IOException {
        this.escaper.writePCDATA(text.getValue());
    }

    protected void write(DocType doctype) throws IOException {
        this.escaper.writeMarkup("<!DOCTYPE ");
        this.escaper.writeMarkup(doctype.getRootElementName());
        if (doctype.getPublicID() != null) {
            this.escaper.writeMarkup(" PUBLIC \"" + doctype.getPublicID() + "\" \"" + doctype.getSystemID() + "\"");
        } else if (doctype.getSystemID() != null) {
            this.escaper.writeMarkup(" SYSTEM \"" + doctype.getSystemID() + "\"");
        }
        String internalDTDSubset = doctype.getInternalDTDSubset();
        if (!internalDTDSubset.equals("")) {
            this.escaper.writeMarkup(" [");
            this.escaper.breakLine();
            this.escaper.writeMarkup(internalDTDSubset);
            this.escaper.breakLine();
            this.escaper.writeMarkup("]");
        }
        this.escaper.writeMarkup(">");
    }

    protected void write(Node node) throws IOException {
        if (node instanceof Text) {
            this.write((Text)node);
        } else if (node instanceof Element) {
            this.write((Element)node);
        } else if (node instanceof Comment) {
            this.write((Comment)node);
        } else if (node instanceof ProcessingInstruction) {
            this.write((ProcessingInstruction)node);
        } else if (node instanceof Document) {
            this.write((Document)node);
        } else if (node instanceof DocType) {
            this.write((DocType)node);
        } else {
            throw new XMLException("Serializer cannot directly serialize a " + node.getClass());
        }
    }

    protected final void writePCDATA(String text) throws IOException {
        this.escaper.writePCDATA(text);
    }

    protected final void writeAttributeValue(String value) throws IOException {
        this.escaper.writeAttributeValue(value);
    }

    protected final void writeMarkup(String text) throws IOException {
        this.escaper.writeMarkup(text);
    }

    protected final void breakLine() throws IOException {
        this.escaper.breakLine();
    }

    public void flush() throws IOException {
        this.escaper.flush();
    }

    public int getIndent() {
        return this.escaper.getIndent();
    }

    public void setIndent(int indent) {
        this.escaper.setIndent(indent);
    }

    public String getLineSeparator() {
        return this.escaper.getLineSeparator();
    }

    public void setLineSeparator(String lineSeparator) {
        this.escaper.setLineSeparator(lineSeparator);
    }

    public int getMaxLength() {
        return this.escaper.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.escaper.setMaxLength(maxLength);
    }

    public boolean getPreserveBaseURI() {
        return this.preserveBaseURI;
    }

    public void preserveBaseURI(boolean preserve) {
        this.preserveBaseURI = preserve;
    }
}

