/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.WellformednessException;

public class Document
extends ParentNode {
    public Document(Element root) {
        this.checkRoot(root);
        super.insertChild(root, 0);
    }

    public Document(Document doc) {
        super.insertChild(doc.getRootElement().copy(), 0);
        for (int i = 0; i < doc.getChildCount(); ++i) {
            Node child = doc.getChild(i);
            if (child instanceof Element) continue;
            this.insertChild(child.copy(), i);
        }
        this.setActualBaseURI(doc.getActualBaseURI());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void insertChild(Node child, int position) {
        if (child instanceof Comment || child instanceof ProcessingInstruction) {
            super.insertChild(child, position);
            return;
        } else if (child instanceof DocType) {
            if (position > this.getRootPosition()) throw new IllegalAddException("Cannot add a document type declaration after the root element");
            DocType oldDocType = this.getDocType();
            if (oldDocType != null) {
                throw new IllegalAddException("Tried to insert a second DOCTYPE");
            }
            super.insertChild(child, position);
            return;
        } else {
            if (!(child instanceof Element)) throw new IllegalAddException("Cannot add a " + child.getClass().getName() + " to a Document.");
            throw new IllegalAddException("Cannot add a second root element to a Document.");
        }
    }

    private int getRootPosition() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!(child instanceof Element)) continue;
            return i;
        }
        throw new WellformednessException("Missing root element");
    }

    public final DocType getDocType() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!(child instanceof DocType)) continue;
            return (DocType)child;
        }
        return null;
    }

    public final void setDocType(DocType doctype) {
        DocType oldDocType = this.getDocType();
        if (oldDocType == null) {
            super.insertChild(doctype, 0);
        } else {
            super.insertChild(doctype, this.indexOf(oldDocType));
            if (oldDocType != doctype) {
                oldDocType.detach();
            }
        }
    }

    public final Element getRootElement() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        throw new WellformednessException("Missing root element");
    }

    public final void setRootElement(Element root) {
        this.checkRoot(root);
        super.insertChild(root, this.getRootPosition());
        super.removeChild(this.getRootPosition() + 1);
    }

    protected void checkRoot(Element root) {
    }

    public final Node removeChild(int position) {
        if (position == this.getRootPosition()) {
            throw new WellformednessException("Cannot remove the root element");
        }
        return super.removeChild(position);
    }

    public final Node removeChild(Node child) {
        if (child == this.getRootElement()) {
            throw new WellformednessException("Cannot remove the root element");
        }
        return super.removeChild(child);
    }

    public final void setBaseURI(String URI2) {
        this.setActualBaseURI(URI2);
    }

    public final String getBaseURI() {
        return this.getActualBaseURI();
    }

    public final String getValue() {
        return this.getRootElement().getValue();
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>\r\n");
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.append(this.getChild(i).toXML());
            result.append("\r\n");
        }
        return result.toString();
    }

    public Node copy() {
        return new Document(this);
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getRootElement().getQualifiedName() + "]";
    }
}

