/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.LeafNode;
import nu.xom.Node;
import nu.xom.Verifier;
import nu.xom.WellformednessException;

public class DocType
extends LeafNode {
    private String rootName;
    private String systemID;
    private String publicID;
    private String internalDTDSubset = "";

    public DocType(String rootElementName, String publicID, String systemID) {
        this.setRootElementName(rootElementName);
        this.setSystemID(systemID);
        this.setPublicID(publicID);
    }

    public DocType(String rootElementName, String systemID) {
        this.setRootElementName(rootElementName);
        this.setSystemID(systemID);
    }

    public DocType(String rootElementName) {
        this.setRootElementName(rootElementName);
    }

    public DocType(DocType doctype) {
        this.internalDTDSubset = doctype.internalDTDSubset;
        this.publicID = doctype.publicID;
        this.systemID = doctype.systemID;
        this.rootName = doctype.rootName;
    }

    private DocType() {
    }

    static DocType build(String rootElementName, String publicID, String systemID) {
        DocType result = new DocType();
        result.publicID = publicID;
        result.systemID = systemID;
        result.rootName = rootElementName;
        return result;
    }

    public final void setRootElementName(String name) {
        Verifier.checkXMLName(name);
        this.checkRootElementName(name);
        this.rootName = name;
    }

    public final String getRootElementName() {
        return this.rootName;
    }

    public final String getInternalDTDSubset() {
        return this.internalDTDSubset;
    }

    final void setInternalDTDSubset(String internalSubset) {
        this.internalDTDSubset = internalSubset == null ? "" : internalSubset;
    }

    public final void setPublicID(String id) {
        if (this.systemID == null && id != null) {
            throw new WellformednessException("Cannot have a public ID without a system ID");
        }
        Verifier.checkPublicID(id);
        this.checkPublicID(id);
        this.publicID = id;
    }

    public final String getPublicID() {
        return this.publicID;
    }

    public final void setSystemID(String id) {
        if (id == null && this.publicID != null) {
            throw new WellformednessException("Cannot remove system ID without removing public ID first");
        }
        Verifier.checkSystemLiteral(id);
        this.checkSystemID(id);
        this.systemID = id;
    }

    public final String getSystemID() {
        return this.systemID;
    }

    protected void checkRootElementName(String name) {
    }

    protected void checkSystemID(String systemID) {
    }

    protected void checkPublicID(String publicID) {
    }

    public final String getValue() {
        return "";
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.rootName + "]";
    }

    public final Node copy() {
        return new DocType(this);
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer();
        result.append("<!DOCTYPE ");
        result.append(this.rootName);
        if (this.publicID != null) {
            result.append(" PUBLIC \"");
            result.append(this.publicID);
            result.append("\" \"");
            result.append(this.systemID);
            result.append('\"');
        } else if (this.systemID != null) {
            result.append(" SYSTEM \"");
            result.append(this.systemID);
            result.append('\"');
        }
        if (this.internalDTDSubset.length() != 0) {
            result.append(" [\r\n");
            result.append(this.internalDTDSubset);
            result.append("]");
        }
        result.append(">");
        return result.toString();
    }
}

