/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.NonVerifyingFactory;
import nu.xom.ParseException;
import nu.xom.SAXInvalidException;
import nu.xom.ValidityException;
import nu.xom.XMLException;
import nu.xom.XOMHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Builder {
    private XMLReader parser;
    private static String[] parsers = new String[]{"org.apache.xerces.parsers.SAXParser", "com.bluecast.xml.Piccolo", "gnu.xml.aelfred2.XmlReader", "oracle.xml.parser.v2.SAXParser", "org.apache.crimson.parser.XMLReaderImpl"};

    public Builder() {
        this(false);
    }

    public Builder(boolean validate) {
        this(Builder.findParser(validate), validate, null);
    }

    public Builder(boolean validate, NodeFactory factory) {
        this(Builder.findParser(validate), validate, factory);
    }

    private static XMLReader findParser(boolean validate) {
        XMLReader parser = null;
        for (int i = 0; i < parsers.length; ++i) {
            try {
                parser = XMLReaderFactory.createXMLReader(parsers[i]);
                Builder.setupParser(parser, validate);
                return parser;
            }
            catch (SAXException ex) {
                parser = null;
                continue;
            }
        }
        if (parser == null) {
            try {
                parser = XMLReaderFactory.createXMLReader();
                Builder.setupParser(parser, validate);
            }
            catch (SAXException ex) {
                throw new XMLException("Could not find a suitable SAX2 parser", ex);
            }
        }
        return parser;
    }

    private static void setupParser(XMLReader parser, boolean validate) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!validate) {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (parser.getClass().getName().equals("org.apache.crimson.parser.XMLReaderImpl")) {
                parser.setErrorHandler(new NamespaceWellformednessRequired());
            } else {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", true);
                parser.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            }
        } else {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler(new ValidityRequired());
        }
        try {
            parser.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Builder(XMLReader parser) {
        this(parser, false);
    }

    public Builder(NodeFactory factory) {
        this(Builder.findParser(false), false, factory);
    }

    public Builder(XMLReader parser, boolean validate) {
        this(parser, validate, null);
    }

    public Builder(XMLReader parser, boolean validate, NodeFactory factory) {
        try {
            Builder.setupParser(parser, validate);
        }
        catch (SAXException ex) {
            if (validate) {
                throw new XMLException(parser.getClass().getName() + " does not support validation.", ex);
            }
            throw new XMLException(parser.getClass().getName() + " does not support the entity resolution" + " features XOM requires.", ex);
        }
        this.parser = parser;
        if (factory != null) {
            this.setHandlers(factory);
        } else if (!(parser instanceof XMLFilter)) {
            this.setHandlers(new NonVerifyingFactory());
        } else {
            this.setHandlers(new NodeFactory());
        }
    }

    private void setHandlers(NodeFactory factory) {
        XOMHandler handler = new XOMHandler(factory);
        this.parser.setContentHandler(handler);
        this.parser.setDTDHandler(handler);
        try {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (SAXException ex) {
            // empty catch block
        }
        try {
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Document build(String systemID) throws ParseException, ValidityException, IOException {
        systemID = this.canonicalizeURL(systemID);
        InputSource source = new InputSource(systemID);
        return this.build(source);
    }

    public Document build(InputStream in) throws ParseException, ValidityException, IOException {
        InputSource source = new InputSource(in);
        return this.build(source);
    }

    public Document build(InputStream in, String baseURI) throws ParseException, ValidityException, IOException {
        baseURI = this.canonicalizeURL(baseURI);
        InputSource source = new InputSource(in);
        source.setSystemId(baseURI);
        return this.build(source);
    }

    public Document build(File in) throws ParseException, ValidityException, IOException {
        FileInputStream fin = new FileInputStream(in);
        String absolute = in.getAbsolutePath();
        StringBuffer url = new StringBuffer("file://");
        for (int i = 0; i < absolute.length(); ++i) {
            char c = absolute.charAt(i);
            if (c == File.separatorChar) {
                url.append('/');
                continue;
            }
            url.append(URLEncoder.encode(String.valueOf(c)));
        }
        String base = url.toString();
        return this.build(fin, base);
    }

    public Document build(Reader in) throws ParseException, ValidityException, IOException {
        InputSource source = new InputSource(in);
        return this.build(source);
    }

    public Document build(Reader in, String baseURI) throws ParseException, ValidityException, IOException {
        baseURI = this.canonicalizeURL(baseURI);
        InputSource source = new InputSource(in);
        source.setSystemId(baseURI);
        return this.build(source);
    }

    public Document build(String document, String baseURI) throws ParseException, ValidityException, IOException {
        StringReader reader = new StringReader(document);
        return this.build(reader, baseURI);
    }

    private String canonicalizeURL(String uri) {
        try {
            URL u = new URL(uri);
            String path = u.getFile();
            if (path == null || path.length() == 0 || "/".equals(path) && !uri.endsWith("/")) {
                uri = uri + '/';
            }
            return uri;
        }
        catch (MalformedURLException ex) {
            return uri;
        }
    }

    private Document build(InputSource in) throws ParseException, ValidityException, IOException {
        try {
            this.parser.parse(in);
        }
        catch (SAXInvalidException ex) {
            throw new ValidityException(ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber(), ex);
        }
        catch (SAXParseException ex) {
            Exception nested = ex.getException();
            if (nested instanceof SAXInvalidException) {
                throw new ValidityException(nested.getMessage(), ((SAXInvalidException)nested).getLineNumber(), ((SAXInvalidException)nested).getColumnNumber(), nested);
            }
            throw new ParseException(ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber(), ex);
        }
        catch (SAXException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
        XOMHandler handler = (XOMHandler)this.parser.getContentHandler();
        return handler.getDocument();
    }

    private static class NamespaceWellformednessRequired
    implements ErrorHandler {
        private NamespaceWellformednessRequired() {
        }

        public void warning(SAXParseException exception) {
        }

        public void error(SAXParseException exception) throws SAXParseException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            throw exception;
        }
    }

    private static class ValidityRequired
    implements ErrorHandler {
        private ValidityRequired() {
        }

        public void warning(SAXParseException exception) {
        }

        public void error(SAXParseException exception) throws SAXInvalidException {
            throw new SAXInvalidException(exception.getMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception);
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            throw exception;
        }
    }
}

