/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.NamespaceException;
import nu.xom.XMLException;

final class Attributes {
    private ArrayList attributes = new ArrayList(1);

    Attributes() {
    }

    public int size() {
        return this.attributes.size();
    }

    public Attribute get(int index) {
        return (Attribute)this.attributes.get(index);
    }

    void add(Attribute attribute) {
        this.checkPrefixConflict(attribute);
        Attribute oldAttribute = this.get(attribute.getLocalName(), attribute.getNamespaceURI());
        if (oldAttribute != null) {
            this.remove(oldAttribute);
        }
        this.attributes.add(attribute);
    }

    void fastAdd(Attribute attribute) {
        this.attributes.add(attribute);
    }

    void checkPrefixConflict(Attribute attribute) {
        String prefix = attribute.getNamespacePrefix();
        String namespaceURI = attribute.getNamespaceURI();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (!a.getNamespacePrefix().equals(prefix) || a.getNamespaceURI().equals(namespaceURI)) continue;
            throw new NamespaceException("Prefix of " + attribute.getQualifiedName() + " conflicts with " + a.getQualifiedName());
        }
    }

    void remove(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Tried to remove null attribute");
        }
        boolean removed = this.attributes.remove(attribute);
        if (!removed) {
            throw new XMLException("Tried to remove attribute from non-parent element");
        }
    }

    public Attribute get(String localName, String namespaceURI) {
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (!a.getLocalName().equals(localName) || !a.getNamespaceURI().equals(namespaceURI)) continue;
            return a;
        }
        return null;
    }

    public Attribute get(String localName) {
        return this.get(localName, "");
    }
}

