/****************************************************************************/
/* Copyright 1999 MBARI                                                     */
/****************************************************************************/
/* $Header: /home/cvs/oasis3/src/operations/src/hobi.h,v 1.1 2003/08/20 19:39:44 headley Exp $			    */
/* Summary  : Header file for HobiLabs Instrument Drivers		    */
/* Filename : hobi.c							    */
/* Author   : Kent Headley (klh)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 1.1 $							    */
/* Created  : 03/28/01							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 03jun01 klh - created						    */
/* $Log: hobi.h,v $
/* Revision 1.1  2003/08/20 19:39:44  headley
/* no message
/*
 * Revision 1.1  2001/06/19  13:18:16  13:18:16  oasisa (Oasis users)
 * Initial revision
 * 
*/
/****************************************************************************/


#define HS2_RECORD_SIZE 62 /* size of HS2 ASCII D record */

/*
   For ARGOS, HS2 data is extracted from an HS2 D record (ASCII string) 
   and stored as binary bytes in a buffer as follows:
    S1:buf[0:1]
    S2:buf[2:3]
    S3:buf[4:5]
    G1:buf[6:6 upper nibble]
    G2:buf[6:6 lower nibble]
    G3:buf[7:7 lower nibble]
    TR:buf[8:8]
*/
#define HS2BUF_SIZE 10 /* (9) word-aligned */
#define AOS_SNORM1 10 /* offset in raw data string */
#define BOS_SNORM1 0  /* offset in binary buffer */
#define AOS_SNORM2 14 
#define BOS_SNORM2 2
#define AOS_SNORM3 18 
#define BOS_SNORM3 4
#define AOS_GAIN1 42
#define BOS_GAIN1 6
#define AOS_GAIN2 43 
#define BOS_GAIN2 6
#define AOS_GAIN3 44 
#define BOS_GAIN3 7
#define AOS_TEMPRAW 54 
#define BOS_TEMPRAW 8


