/************************************************************************/
/* Copyright 1997 MBARI							*/
/************************************************************************/
/* Summary  : Program to change first field (date) in data files	*/
/* Filename : chday.c							*/
/* Author   : Bob Herlien (rah)						*/
/* Project  : OASIS							*/
/* Version  : 1.0							*/
/* Created  : 01/10/97							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 10jan97 rah - created						*/
/************************************************************************/

#include <stdio.h>			/* Unix standard I/O		*/
#include <stdlib.h>			/* Unix standard library stuff	*/
#include <mbari/types.h>		/* MBARI standard types		*/
#include <mbari/const.h>		/* MBARI standard constants	*/


/********************************/
/*	Module Local Data	*/
/********************************/

MLocal char	buffer[1024];


/************************************************************************/
/* Function    : main							*/
/* Purpose     : Main routine						*/
/* Inputs      : argc, argv						*/
/* Outputs     : Integer, 0 for success, 1 for failure			*/
/************************************************************************/
	Int32
main( Int32 argc, char **argv )
{
    Int32		position;
    double		offset, date;

    if ( argc < 2 )
    {
	fprintf( stderr, "Usage: %s offset <infile >outfile\n", argv[0] );
	exit( 1 );
    }

    offset = atof( argv[1] );

    while ( gets(buffer) != NULL )
    {
	if ( sscanf(buffer, " %lg%n", &date, &position) >= 1 )
	    printf( "%9.5f %s\n", date + offset, &buffer[position] );
	else
	    puts( buffer );
    }

} /* main() */
